#ifndef rolenetwork_header
#define rolenetwork_header

#include "types.h"

typedef struct rolePacket_t {
	int type;
	RoleFLOAT x;
	RoleFLOAT z;
	RoleFLOAT data;
} RolePACKET;

typedef struct roleReceivingPacket_t {
	int number;
	RolePACKET player[MAX_PLAYER];
} RoleRecevingPACKET;

class RoleNetwork
{
public:
	RoleNetwork(int option, RoleRecevingPACKET * received);
	~RoleNetwork();
	void serverProcess();
	RoleBOOL clientProcess(RolePACKET * packet,RoleRecevingPACKET * receivedPacket);
	static const RoleINT CLIENT;
	static const RoleINT SERVER;

private:
#define BUFFERSIZE 256
#define PACKETSIZE 16
#define PORT 9034
	RoleINT serverInit();
	RoleINT clientInit(RoleRecevingPACKET * received);
	char buffer[BUFFERSIZE];
#ifdef _WIN32
	WSADATA wsaData;
#endif
	fd_set master;
	fd_set read_fds;
	struct sockaddr_in myaddr;
	struct sockaddr_in remoteaddr;
	int fdmax;
	int mysocket;
	int newfd;
	int nbytes;
	int addrlen;
	int i,j;
	RoleINT playerID;
};

#endif