
#include "rolenetwork.h"
#include "player.h"
#include "util.h"
#include "sdl.h"
const RoleINT RoleNetwork::CLIENT = 0;
const RoleINT RoleNetwork::SERVER = 1;

RoleNetwork::RoleNetwork(RoleINT option,RoleRecevingPACKET * received)
{
	if (option == SERVER)
		serverInit();
	else
		clientInit(received);
}





RoleNetwork::~RoleNetwork()
{
#ifdef _WIN32 // for windows
	closesocket(mysocket);
	WSACleanup();
#else
	close(mysocket);
#endif
}





RoleINT RoleNetwork::serverInit()
{
#ifdef _WIN32 // for windows
    if(WSAStartup(MAKEWORD(1, 1), &wsaData))
	{
		rolePrintlog("Cannot initialize network\n");
		quit_role(1);
    }
	char yes ='1';
#else
	int yes = 1;
#endif
	FD_ZERO(&master);
	FD_ZERO(&read_fds);

	if ((mysocket = socket(AF_INET, SOCK_STREAM,0)) == -1) {
		rolePrintlog("Cannot create socket\n");
		quit_role(1);
	}

	if (setsockopt(mysocket, SOL_SOCKET, SO_REUSEADDR, & yes, sizeof(int)) == -1){
		rolePrintlog("Cannot setup socket\n");
		quit_role(1);
	}

	//bind
	myaddr.sin_family = AF_INET;
	myaddr.sin_addr.s_addr = INADDR_ANY;
	myaddr.sin_port = htons(PORT);
	memset(&(myaddr.sin_zero),'\0',8);

	if (bind(mysocket, (struct sockaddr * ) & myaddr, sizeof(myaddr)) == -1) {
		rolePrintlog("Cannot bind\n");
		quit_role(1);
	}
	// listen
	if (listen(mysocket, 10)==-1)
	{
		rolePrintlog("Cannot create mysocket\n");
		quit_role(1);
	}

    // add the listenr to the master set
	FD_SET(mysocket, & master);
	fdmax = mysocket;
	rolePrintlog("Waiting for client\n");
	playerID=1;
	return playerID;
}

RoleBOOL RoleNetwork::clientInit(RoleRecevingPACKET * received)
{
	int numPlayer = received->number;
#ifdef _WIN32 // for windows
    if(WSAStartup(MAKEWORD(1, 1), &wsaData))
	{
		rolePrintlog("Cannot initialize network\n");
		quit_role(1);
    }
#endif
	remoteaddr.sin_addr.s_addr = inet_addr(ipaddress);
	remoteaddr.sin_family = AF_INET;
	remoteaddr.sin_port = htons(PORT);
	memset(&(remoteaddr.sin_zero),'\0',8);
	if ((mysocket = socket(AF_INET, SOCK_STREAM,0)) == -1) {
		rolePrintlog("Cannot create socket\n");
		quit_role(1);
	}

    // add the listenr to the master set
	int result = 0;
	printf("connecting\n");
	if((result = connect(mysocket,(struct sockaddr *) &remoteaddr,sizeof(remoteaddr))) == -1)
	{
		rolePrintlog("error while connecting\n");
	}
	received->number=0;
	while(received->number == 0)
	{
		if ((recv(mysocket,buffer,sizeof(RoleRecevingPACKET),0)) > 0)
		{
				memcpy(received,buffer,sizeof(RoleRecevingPACKET));
				if (received->number!=0)
				{
					rolePrintlog("Get playerID %i ",received->number/256/256);
				}
		}
	}
	playerID = received->number >> 16;
	if (playerID == 0)
	{
		printf("sending init packet\n");
		RolePACKET packet = {0};
		packet.type=numPlayer;// sending number of players
		memcpy(buffer,&packet,sizeof(packet));
		if (send(mysocket,buffer,PACKETSIZE,0) == -1)
		{
			rolePrintlog("sending error\n");
		}
		received->number=0;
		while(received->number == 0)
		{
			if ((recv(mysocket,buffer,sizeof(RoleRecevingPACKET),0)) > 0)
			{
//			printf("get something %i PlayerID %i\n",a,playerID);
				memcpy(received,buffer,sizeof(RoleRecevingPACKET));
				if (received->number!=0)
				{
//					printf("%i %i %i %i %i %f %f %f\n",update,SDL_GetTicks(),mysocket,i,
//					received->player[playerID].type,received->player[playerID].x,received->player[playerID].z,received->player[playerID].data);
				}
			}
		}
	}
	rolePrintlog("Connected to the address %s on socket %d %i\n",inet_ntoa(remoteaddr.sin_addr),mysocket,result);
	return RoleTRUE;
}




void RoleNetwork::serverProcess()
{
	read_fds = master;
	if(select (fdmax+1,&read_fds,NULL,NULL,NULL)==-1) {
		rolePrintlog("network fd error. cannot process server function\n");
		quit_role(1);
	}

	for (i = 0; i<=fdmax;i++) {
		if (FD_ISSET(i, &read_fds)) {
			if (i == mysocket)
			{
				addrlen = sizeof(remoteaddr);
				if((newfd = accept(mysocket, (struct sockaddr *) & remoteaddr,
					&addrlen)) == -1) {
					rolePrintlog("Cannot accept network call\n");
					quit_role(1);
				}
				else 
				{
					FD_SET(newfd,&master);
					if (newfd> fdmax) 
					{
						fdmax = newfd;
					}
					rolePrintlog("selectserver: new connection from %s on socket %d\n", inet_ntoa(remoteaddr.sin_addr),newfd);
				}
			}
			else
			{
				memset(&(buffer),'\0',PACKETSIZE);
				if ((nbytes = recv(i,buffer,sizeof(buffer),0)) <=0) 
				{
					if (nbytes == 0) 
					{
						rolePrintlog("selectserver: socket %d hung up\n",i);
					}
					else
					{
						rolePrintlog("error when the other computer hung up\n");
					}
#ifdef _WIN32
					closesocket (i);
#else
					close(i);
#endif
					FD_CLR(i,&master);
				}
				else
				{
					for(j = 0; j <= fdmax;j++)
					{
						if(FD_ISSET(j,&master))
						{
							if (j != mysocket && j !=i) 
							{
								if (send(j,buffer,nbytes,0) == -1)
								{
									perror("send");
								}
							}
						}
					}
				}
			}
		}
	}
}

/*

clientProcess.

  send current command from this player and get a packet from server

  Note that you are getting only one receiving packet.
  That packet including feedback information too.

*/


RoleBOOL RoleNetwork::clientProcess(RolePACKET * packet,RoleRecevingPACKET * received)
{
	RoleINT a = 0;
	RoleUINT update =0;
	RoleBOOL quit = RoleFALSE;

	update = SDL_GetTicks()+2000;
	memcpy(buffer,packet,PACKETSIZE);
	if (send(mysocket,buffer,PACKETSIZE,0) == -1)
	{
		rolePrintlog("sending error\n");
	}
	received->number=0;
	while(received->number == 0)
	{
		if ((a=recv(mysocket,buffer,sizeof(RoleRecevingPACKET),0)) > 0)
		{
//			printf("get something %i PlayerID %i\n",a,playerID);
			memcpy(received,buffer,sizeof(RoleRecevingPACKET));
			if (received->number!=0)
			{
//				printf("%i %i %i %i %i %f %f %f\n",update,SDL_GetTicks(),mysocket,i,
//				received->player[playerID].type,received->player[playerID].x,received->player[playerID].z,received->player[playerID].data);
			}
		}
		else
		{
			rolePrintlog("get nothing\n");
		}
		if (SDL_GetTicks() > update)
		{
			rolePrintlog("time passed\n");
/*
#ifdef _WIN32 // for windows
			closesocket(mysocket);
			WSACleanup();
#else
			close(mysocket);
#endif
*/			return RoleFALSE;
		}
	}
	return RoleTRUE;
}
