#ifndef roam_header
#define roam_header
#include "heap.h"
#include "types.h"
#include "util.h"
//#define SPLITDEBUG 3

class Player;

typedef struct roamVertexPoint_t
{
	RoleSHORT x;
	RoleSHORT y;
	RoleFLOAT z;
} RoamVertexPoint;


// the following is for split ...
class RoamSplitTriangleNode;
class RoamMergeDiamondNode;

class RoamSplitTriangleNode
{
public:
	/* 
		int nodeNum

		pointing to the heightError node & this node's position in BiTriTree
		This must be integer to locate the correct node number
		In other words, do not use pointer.
		*** Split case
		If you split, nodeNum << 1 is left child's heightError nodeNum
		and nodeNum << 1 + 1 is right child's heightError nodeNum.
		*** Merge case
		just nodeNum >> 1 is merged triangle's nodeNum.
		  =<> when you merge, you always merge to their parent! 
		      =>Never merge with other children.
		    /|\          You can merge the small triangles 
		  /  |  \		 only to its parent because these triangles 
		/    |    \		 are not just randomly created 
	   -------------     but from a binary tree split.

	*/
	int nodeNum; 

	// priority. heap priority (if size is too small priority goes down) 
	RoleFLOAT priority;
	/* The place where this node is in the split queue */
	int heap_index;

	/* 
		int nodeMerge:

		Node number to locate this node in merge priority queue.
		 if you wanna split, you must not only deleteMax() from 
		 split queue but also deleteAt(nodeMerge) from
		 merge queue when the triagle belongs to a triangle pair or diamond
		 in merge queue.
		 Because of the structure of BiTri, there can not be 
		 more than one set of diamond associated with this triangle node.
		 We can store it as pointer, but I don't know which one is faster.
		 On the second thought, this should be a pointer.
	*/
	RoamMergeDiamondNode * nodeMerge;
	RoleBYTE drawn;
	RoleFLOAT faceorientation;
	RoleFLOAT normal[3];


	/* the coordinate of this triangle.
		this could be calculated from nodeNum, but it would be ok to keep
		this coordinate because we have only several thousands of splitNode
		at each frame at most.  (6 shorts + 3 bytes) * 6000 = 15 bytes*6000. 
		 -> Because we are only keeping leaf triangle nodes, 
		 the number of split node is not big.
		Besides, it takes time to calculate the coordinate.
		One alternative is that we could have the coordinate in error node
		but that errorTree contains all possible nodes... too much.
		Besides the new coordinate can be easily calclated from each node.
	*/
	RoamVertexPoint vtop;
	RoamVertexPoint vleft;
	RoamVertexPoint vright;

	// check out the figures in the ROAM paper.
	RoamSplitTriangleNode *BaseNeighbor;
	RoamSplitTriangleNode *LeftNeighbor;
	RoamSplitTriangleNode *RightNeighbor;
	
//  We don't need the following. This node is the leaf.
//	RoamSplitTriangleNode *RightChild;
//	RoamSplitTriangleNode *LeftChild;

	// linked list to save memory allocation.
	// must do init before creating any node.
	static void init(int size);
	static RoamSplitTriangleNode * free;
	static RoamSplitTriangleNode * lastfree;
	static RoamSplitTriangleNode * getEmptyNode();
	static void deleteNode(RoamSplitTriangleNode * node);
private:

	static vector<RoamSplitTriangleNode> nodePool;
};
 

/* checking mergeable.

  1. When we split, there will be one mergeable diamond. Easy enough.
	 And erase all the mergeable diamond (Since we have four reference to
	 one mergeable diamond, first getTop and look for MergeDiamondNode
	 and refer back to change nodeMerge in all the splitNodes associated with it,
	 then remove the nodes from both split&merge queue).
	 Then, add new merge node.

  2. When we merge, check out two possible mergeable diamonds.
  At least one of them should be new diamond.
  if (nodeSplit[0]->BaseNeighbor->LeftNeighbor ==
	  nodeSplit[0]->LeftNeighbor->BaseNeighbor->RightNeighbor)
  {
	  new mergeable diamond 
  }
  if (nodeSplit[1]->BaseNeighbor->LeftNeighbor ==
	  nodeSplit[1]->LeftNeighbor->BaseNeighbor->RightNeighbor)
  {
      new mergeable diamond
  }

  ****** Special case : at the edge.

  if (nodeSplit[0]->BaseNeighbor->LeftNeighbor == NULL)
   new diamond...

   ... and many special case by checking NULL.
   assertion :  there will never be two NULL baseneighbor nodes
                unless it is the children of a root triangle.

*/

class RoamMergeDiamondNode
{
public:
	/* 
		int nodeNum
		it is useful to know where I am and to get the error quickly
	*/
	int nodeNum; 

	// priority. Do we need this? Yes to save time.
	// even if we lost, we can get nodeNum from its split node.
	// priority =
	//    max(nodeSplit[0]->priority,
	//        nodeSplit[1]->priority)
	//

	RoleFLOAT priority;
	/* The place where this node is in the merge queue */
	int heap_index;

	/* 
		RoamSplitTriangleNode * nodeSplit[2]:
		For each diamond, we have four split nodes.
		We store two left children. (Is it better to store all four?)
		    /|\       
		  /  |  \	
		/left|right\
	   -------------
	   \right|left /
		 \   |   /
		   \ | /
		For each split, we will have exactly one new mergeable diamond.
		For each merge, we can have at most two new mergeable diamonds.
		So we don't need to worry about duplication or redunduncy in 
		merge queue. It is sequential operation.

	// note that it is important to merge two children into their parent.
	// since we stored only left children, we can safely assume 
	// that we are merging with left neighborhood of indicated node.
	// (Right child is always the left neghborhood of left child)
	Actually, we can store only left child of the smallest node Number
	Then, we can merge left+right, right neighbor of left + it's right neighbor
	But this will take lots of memory access, so not recomendable.
	*/
	RoamSplitTriangleNode * nodeSplit[2]; 

	/*
		we don't need coordinate. we can get from split queue
		any children's top coord is the coord for error.
	*/

	// We don't need the pointers. they are in the split queue.

	/*
	RoamMergeDiamondNode *BaseNeighbor;
	RoamMergeDiamondNode *LeftNeighbor;
	RoamMergeDiamondNode *RightNeighbor;
	RoamMergeDiamondNode *LeftChild;
	RoamMergeDiamondNode *RightChild;
	*/

	// linked list to save memory allocation.
	// must do init before creating any node.
	RoamMergeDiamondNode * next;
	static void init(int size);
	static RoamMergeDiamondNode * free;
	static RoamMergeDiamondNode * lastfree;
	static RoamMergeDiamondNode * getEmptyNode();
	static void deleteNode(RoamMergeDiamondNode * node);
private:
	static vector<RoamMergeDiamondNode> nodePool;
};

class RoleRoam
{

public:

	RoleRoam(int maxsize, int maxerror, RoleFLOAT * hMap,int map_size);
	void updateFrame(Player * player);
	void draw_triangles(); // rendering procedure, easiest part.
	int counter;
	int mergecounter;
	int splitcounter;
//	this should be changed
	RoleFLOAT cameraX;
	RoleFLOAT cameraY;
	RoleFLOAT cameraZ;
	RoleFLOAT cameraCenterX;
	RoleFLOAT cameraCenterY;
	RoleFLOAT cameraCenterZ;
	RoleFLOAT * p_Frustum[4];
	MaxHeap * splitQueue; 
	MinHeap * mergeQueue;
//private:
	Player * player;
	RoleINT avgMerge;
	void update_triangle();// do 5.2 code in the ROAM paper.
	void updatePriority();
	void split(RoamSplitTriangleNode * node); // update queue while spliting & merging
	int RoleRoam::getParentNodeNum(int nodeNum);
	int RoleRoam::getLeftchildNodeNum(int nodeNum);
	int RoleRoam::getRightchildNodeNum(int nodeNum);

	RoleFLOAT inline getPriority(RoamSplitTriangleNode * node);
	RoleFLOAT inline getPriority(RoleINT nodeNum
	,RoleFLOAT tx, RoleFLOAT ty,RoleFLOAT tz
	,RoleFLOAT lx,RoleFLOAT ly, RoleFLOAT lz
	,RoleFLOAT rx,RoleFLOAT ry,	RoleFLOAT rz
	,RoleFLOAT faceorientation
	,RoleFLOAT normal[3]);
	void inline getOrientation(RoamSplitTriangleNode * node);
	void inline setNormal(RoamSplitTriangleNode * node);
	RoleFLOAT inline getParentPriority(RoleINT pnodeNum,RoamSplitTriangleNode * node);

	vector<RoleFLOAT> errorTree;
	void initializeErrorTree();
	void initializeQueues(); // Do we need this?
	RoleBYTE recurErrorCalculate(RoleINT topX,  RoleINT topY,  RoleFLOAT topZ, 
											RoleINT leftX,  RoleINT leftY,  RoleFLOAT leftZ,
										    RoleINT rightX, RoleINT rightY, RoleFLOAT rightZ,
											RoleINT node);
//	void load_heightmap_from_file();

	void merge(RoamMergeDiamondNode * node);

	// my heap has about 600,000 (insert+delete) per second from 400MHZ pII.
	// if you have better heap, please replace it. 
	/* 
	errorTree can be just an array of Bytes 
	as explained above at nodeNum in class RoamSplitTriangleNode,
	errorTree will be accessed by the nodeNum. 
	we can make it float, but I am not sure.. Maybe float is better.
	*/
	int MAXSIZE;
	RoleFLOAT MAXERROR;
    int SIZEOFERROR;
	int HALFSIZEOFERROR;
	// change the type what ever you want.
	RoleFLOAT * heightMap;

// constants to be calculated or passed down.

// I don't know the size of errorTree. We can calculate.
	int MAP_SIZE;
};


#endif