#include "heap.h"
#include "roam.h"
#include "image.h"
#include "player.h"
#include "terrain.h"
#include "graphic.h"
#include <glut.h>
using namespace std;

RoleRoam * roam;
RoamSplitTriangleNode * RoamSplitTriangleNode::free = NULL;
RoamSplitTriangleNode * RoamSplitTriangleNode::lastfree = NULL;
vector<RoamSplitTriangleNode> RoamSplitTriangleNode::nodePool;


void RoamSplitTriangleNode::init(int size)
{
	RoamSplitTriangleNode::nodePool.resize(size+1);
	free = &(nodePool[0]);
	for (int i = 0; i < size; i++)
	{
		nodePool[i].LeftNeighbor = &(nodePool[i+1]);
	}
	lastfree=&(nodePool[i]);
	lastfree->LeftNeighbor = NULL;
}

void RoamSplitTriangleNode::deleteNode(RoamSplitTriangleNode * node)
{
	node->LeftNeighbor=NULL;
	lastfree->LeftNeighbor = node;
	lastfree = node;
}


RoamSplitTriangleNode * RoamSplitTriangleNode::getEmptyNode()
{
	RoamSplitTriangleNode * r;
	r = free;
	if (free->LeftNeighbor == NULL)
	{
		return NULL; // reaching Maximum
	}
	else
	{
		free = free->LeftNeighbor;
		r->drawn = getDrawn(TRUE);
		r->faceorientation = 1.0f;
		return r;
	}
}

RoamMergeDiamondNode * RoamMergeDiamondNode::free = NULL;
RoamMergeDiamondNode * RoamMergeDiamondNode::lastfree = NULL;
vector<RoamMergeDiamondNode> RoamMergeDiamondNode::nodePool;

void RoamMergeDiamondNode::init(int size)
{
	RoamMergeDiamondNode::nodePool.resize(size+1);
	free = &(nodePool[0]);
	for (int i = 0; i < size; i++)
	{
		nodePool[i].next = &(nodePool[i+1]);
	}
	lastfree=&(nodePool[i]);
	lastfree->next = NULL;
}

void RoamMergeDiamondNode::deleteNode(RoamMergeDiamondNode * node)
{
	node->next=NULL;
	lastfree->next = node;
	lastfree = node;
}

RoamMergeDiamondNode * RoamMergeDiamondNode::getEmptyNode()
{
	RoamMergeDiamondNode * r;
	r = free;
	if (free->next == NULL)
	{
		printf("critical error while allocating node\n");
		exit(1);
		return NULL; // reaching Maximum
	}
	else
	{
		free = free->next;
		return r;
	}
}


////////////////////////////////////////////////////////////////////








////////////////////////////////////////////////////////////////////
RoleRoam::RoleRoam(int maxsize,int maxerror,  RoleFLOAT * hMap, int map_size)
{
	MAXSIZE = maxsize;
	MAXERROR = maxerror;
	MAP_SIZE = map_size;
	mergecounter = 0;
	splitcounter = 0;
	avgMerge=200;
	player = NULL;
	// since there can be some force split, get twice many nodes as the
    // maxsize.
	splitQueue = new MaxHeap(maxsize*2);
	mergeQueue = new MinHeap(maxsize*2);
	// initializing node pools (save memory allocation time)
	RoamSplitTriangleNode::init(maxsize*2);
	RoamMergeDiamondNode::init(maxsize*2);
	heightMap = hMap;
//	load_heightmap_from_file();
	SIZEOFERROR = (MAP_SIZE-1)*(MAP_SIZE-1)*2*2*2+1;
	HALFSIZEOFERROR = SIZEOFERROR/2;
	initializeErrorTree();
	initializeQueues();
	rolePrintlog("Size of error tree: %i\n",SIZEOFERROR);
}


void RoleRoam::initializeErrorTree()
{
	counter = 0;
	errorTree.resize(SIZEOFERROR+1);
	recurErrorCalculate(0,MAP_SIZE-1,heightMap[(MAP_SIZE-1)*(MAP_SIZE)]
		,0,0,heightMap[0]
		,MAP_SIZE-1,MAP_SIZE-1,heightMap[MAP_SIZE*MAP_SIZE-1],1);
	recurErrorCalculate(MAP_SIZE-1,0,heightMap[MAP_SIZE-1]
						, MAP_SIZE-1,MAP_SIZE-1,heightMap[MAP_SIZE*MAP_SIZE-1]
						,0,0,heightMap[0],
						HALFSIZEOFERROR+1);
}
/*
void RoleRoam::load_heightmap_from_file()
{
	Image * hmap_image = (Image *) malloc(sizeof(Image));
	RoleINT i ,j= 0;

	ImageLoad("hmap.bmp",hmap_image);
	MAP_SIZE = hmap_image->sizeX;
	if (MAP_SIZE != hmap_image->sizeY)
	{
		printf("Error in the size of map. Map should be square\n");
		exit(0);
	}
	heightMap = new GLbyte[MAP_SIZE*MAP_SIZE];
	for ( i =0; i < MAP_SIZE; i++)
	{
		for( j = 0; j < MAP_SIZE; j++)
		{
			heightMap[j*MAP_SIZE+i] =	hmap_image->data[(i+j*MAP_SIZE)*4] +
									hmap_image->data[(i+j*MAP_SIZE)*4+1] / 4+
									hmap_image->data[(i+j*MAP_SIZE)*4+2] / 64; 
		}
	}

	free(hmap_image->data);
	free(hmap_image);
}
*/
RoleFLOAT inline myMax (RoleFLOAT a, RoleFLOAT  b)
{
	return (a > b ? a : b);
}

RoleFLOAT inline myMin (RoleFLOAT a, RoleFLOAT  b,RoleFLOAT  c)
{
	return (c < (a < b ? a : b) ? c : (a < b ? a : b));
}


// the following code is based on the code from simpleroam example.
// just a little bit change, but enough.
RoleBYTE RoleRoam::recurErrorCalculate(RoleINT topX,  RoleINT topY,  RoleFLOAT topZ, 
											RoleINT leftX,  RoleINT leftY,  RoleFLOAT leftZ,
										    RoleINT rightX, RoleINT rightY, RoleFLOAT rightZ,
											RoleINT node)
{
	RoleINT centerX = (leftX + rightX) >>1;		// Compute X coordinate of center of Hypotenuse
	RoleINT centerY = (leftY + rightY) >>1;		// Compute Y coord...
	RoleFLOAT heightError;
	counter++;

	// base case, return
	// Get the height value at the middle of the Hypotenuse
	RoleBYTE centerZ  = heightMap[centerY * MAP_SIZE + centerX];

	// Variance of this triangle is the actual height at it's hypotenuse midpoint minus the interpolated height.
	// Use values passed on the stack instead of re-accessing the Height Field.
	heightError = abs(centerZ - ((leftZ + rightZ)/2));

	// if this is not base case, resursively call the next children's height Error
	if ( (abs(leftX - rightX) >= 2 ) ||  //?? is it the bottom??
		 (abs(leftY - rightY) >= 2) )
	{
	// calculate all the way down
	// Final Variance for this node is the max of it's own variance and that of it's children.
		if (node > HALFSIZEOFERROR)
		{
			heightError = myMax(heightError, recurErrorCalculate( centerX, centerY, centerZ, topX,   topY,  topZ, leftX, leftY, leftZ,    ((node-HALFSIZEOFERROR)<<1) +HALFSIZEOFERROR) ); // Left
			heightError = myMax(heightError, recurErrorCalculate( centerX, centerY, centerZ, rightX, rightY, rightZ, topX, topY, topZ, 1+((node-HALFSIZEOFERROR)<<1)+HALFSIZEOFERROR) ); // Right
		}
		else
		{
			heightError = myMax(heightError, recurErrorCalculate( centerX, centerY, centerZ, topX,   topY,  topZ, leftX, leftY, leftZ,    node<<1 ) ); // Left
			heightError = myMax(heightError, recurErrorCalculate( centerX, centerY, centerZ, rightX, rightY, rightZ, topX, topY, topZ, 1+(node<<1)) ); // Right
		}
	}
//	else
//		printf("leaf---------\n");
	// Store the final variance for this node.  Note Variance is never zero.
	errorTree[node] = 1 + heightError;
//	printf("current Node is %i %u leftX: %i,leftY: %i rightX %i  rightY: %i\n"
//		,node,1+heightError,leftX,leftY,rightX,rightY);

	return heightError;
}


void RoleRoam::initializeQueues()
{
	// create the two base triangles and insert into split queue.
	RoamSplitTriangleNode * base1 = RoamSplitTriangleNode::getEmptyNode();
	RoamSplitTriangleNode * base2 = RoamSplitTriangleNode::getEmptyNode();

	base1->nodeNum = 1;
	base1->heap_index = -1;
	base1->nodeMerge=NULL;

	base1->vright.x = MAP_SIZE-1; 
	base1->vright.y = MAP_SIZE-1; 
	base1->vright.z = heightMap[MAP_SIZE*MAP_SIZE-1]; 
	base1->vtop.x = 0; 
	base1->vtop.y = MAP_SIZE-1; 
	base1->vtop.z = heightMap[(MAP_SIZE-1)*(MAP_SIZE)]; 
	base1->vleft.x = 0; 
	base1->vleft.y = 0; 
	base1->vleft.z = heightMap[0]; 

	base1->BaseNeighbor = base2;
	base1->LeftNeighbor = NULL;
	base1->RightNeighbor = NULL;
	base1->priority = 1000.0f;// maximum priority
	setNormal(base1);
	splitQueue->insert(base1);

	base2->nodeNum = HALFSIZEOFERROR+1;
	base2->heap_index = -1;
	base2->nodeMerge=NULL;

	base2->vtop.x = MAP_SIZE-1;  
	base2->vtop.y = 0;
	base2->vtop.z = heightMap[MAP_SIZE-1]; 
	base2->vleft.x = MAP_SIZE-1; 
	base2->vleft.y = MAP_SIZE-1;  
	base2->vleft.z = heightMap[MAP_SIZE*MAP_SIZE-1]; 
	base2->vright.x = 0; 
	base2->vright.y = 0; 
	base2->vright.z = heightMap[0]; 

	base2->BaseNeighbor = base1;
	base2->LeftNeighbor = NULL;
	base2->RightNeighbor = NULL;
	base2->priority = 1000.0f; // maximum priority

	setNormal(base2);
	splitQueue->insert(base2);
}

void inline RoleRoam::getOrientation(RoamSplitTriangleNode * node)
{
	node->faceorientation = dotProduct3f(node->normal
		,cameraX-node->vtop.x,cameraY-node->vtop.y,cameraZ-node->vtop.z);
}

void RoleRoam::updatePriority()
{
	RoleFLOAT temp = 0.0f;
	RoamSplitTriangleNode * node;
	RoleINT qsize = splitQueue->getMySize();
	RoleINT jumpstart = qsize/4;
	RoleINT jumpend = qsize*3/4;

	for (int i = 0; i < qsize;i++)
	{
		// stupid optimaization. but it works perfectly.
		// performance gain x2
		getOrientation(splitQueue->queue[i]);
		if ((i < jumpstart) || (i > jumpend))
		{
			node = splitQueue->queue[i];
			node->priority = getPriority(node);
			splitQueue->changePriorityAt(node->heap_index);
		}
	}
	RoamMergeDiamondNode * mNode;
	qsize = mergeQueue->getMySize();
	for (i = 0; i < qsize;i++)
	{
//		if ((i < 1500) || (i > 4500))
		{
			mNode = mergeQueue->queue[i];
			if (mNode->nodeSplit[0] == NULL)
			{
				node = mNode->nodeSplit[1];
				mNode->priority = getParentPriority(getParentNodeNum(node->nodeNum),node);//node->priority;
			}
			else if (mNode->nodeSplit[1] == NULL)
			{
				node = mNode->nodeSplit[0];
				mNode->priority = getParentPriority(getParentNodeNum(node->nodeNum),node);//node->priority;
			}
			else
			{
				node = mNode->nodeSplit[0];
				RoleFLOAT parent1Priority = getParentPriority(getParentNodeNum(node->nodeNum),node);//node->priority;
				node = mNode->nodeSplit[1];
				RoleFLOAT parent2Priority = getParentPriority(getParentNodeNum(node->nodeNum),node);//node->priority;
				mNode->priority = (parent1Priority > parent2Priority
					? parent1Priority: parent2Priority);
			}
			mergeQueue->changePriorityAt(mNode->heap_index);
		}
	}
}

void RoleRoam::updateFrame(Player * p)
{
	cameraX = p->getCameraX()/Terrain::CELLSIZE;
	cameraY = p->getCameraZ()/Terrain::CELLSIZE;
	cameraZ = p->getCameraY()/Terrain::CELLSIZE;
	cameraCenterX = p->getCameraCenterX()/Terrain::CELLSIZE;
	cameraCenterY = p->getCameraCenterZ()/Terrain::CELLSIZE;
	cameraCenterZ = p->getCameraCenterY()/Terrain::CELLSIZE;
	player = p;
	updatePriority();
	update_triangle();
}


void RoleRoam::update_triangle()
{
	splitcounter = 0;
	mergecounter = 0;
		  // too many triangle
	while (((splitQueue->getMySize() > MAXSIZE+5)
	 	    || (splitQueue->getMySize() < MAXSIZE-5)) 
	 		||
		  // not meeting the required accuracy
		  (splitQueue->top()->priority > mergeQueue->top()->priority))
		  //&& (splitQueue->top()->priority > 1.0))) 
	{
		if (splitQueue->getMySize() > MAXSIZE+5)
		{
			merge(mergeQueue->top());
//			printf("merge\n");
		}
		else
		{
			split(splitQueue->top());
//			printf("split %i\n",splitQueue->getMySize());
		}
		// usually there is more than 200 merge& split due to the 
		// base case (size smaller than 2)
		if ((splitQueue->getMySize() > MAXSIZE+60) || ((splitcounter > 2000) &&
			(splitQueue->top()->priority <= mergeQueue->top()->priority))
			|| (mergecounter > 200))
		{
//			printf("trouble %f %f\n",cameraX,cameraY);
			break;
		}
	}
	avgMerge = (avgMerge+mergecounter)/2;
/*
	printf("splitcounter %i total triangle %i top error %g\n",splitcounter,splitQueue->getMySize()
		, splitQueue->top()->priority);
	printf("mergecounter %i size %i top priority %g\n",mergecounter,mergeQueue->getMySize(),
		mergeQueue->top()->priority);
		*/
}

int RoleRoam::getParentNodeNum(int nodeNum)
{
	if (nodeNum > HALFSIZEOFERROR)
	{
		return ((nodeNum - HALFSIZEOFERROR) >> 1) + HALFSIZEOFERROR;
	}
	else
		return nodeNum >> 1;
}

int RoleRoam::getLeftchildNodeNum(int nodeNum)
{
	if (nodeNum > HALFSIZEOFERROR)
	{
		return ((nodeNum-HALFSIZEOFERROR)<<1) +HALFSIZEOFERROR;
	}
	else
		return (nodeNum << 1); 
}

int RoleRoam::getRightchildNodeNum(int nodeNum)
{
	if (nodeNum > HALFSIZEOFERROR)
	{
		return ((nodeNum-HALFSIZEOFERROR)<<1) +HALFSIZEOFERROR+1;
	}
	else
		return (nodeNum << 1) + 1;
}

void RoleRoam::split(RoamSplitTriangleNode * node)
{
	if ( (abs(node->vleft.x - node->vright.x) < 2 ) &&  //?? is it the bottom??
		 (abs(node->vleft.y - node->vright.y) < 2) )
	{
		node->priority = node->priority/2.0f;
		splitQueue->decreasedPriorityAt(node->heap_index);
//		This is just updating priority in queue, destroying the priority
/*		RoamMergeDiamondNode * mNode = node->nodeMerge;
		if (mNode->nodeSplit[0] == NULL)
		{
			node = mNode->nodeSplit[1];
			mNode->priority = node->priority;
		}
		else if (mNode->nodeSplit[1] == NULL)
		{
			node = mNode->nodeSplit[0];
			mNode->priority = node->priority;
		}
		else
		{
			node = mNode->nodeSplit[0];
			RoleFLOAT parent1Priority = node->priority;
			node = mNode->nodeSplit[1];
			RoleFLOAT parent2Priority = node->priority;
			mNode->priority = (parent1Priority > parent2Priority
				? parent1Priority: parent2Priority);
		}
		mergeQueue->changePriorityAt(mNode->heap_index);
*/		return;
	}

	// to verify this is the top node in the queue
	// this will used to determine whether new merge node are made or not
	// in the last part of this function
	RoleINT temp_heap_index = node->heap_index;
	splitcounter++;
	RoamSplitTriangleNode * base = node->BaseNeighbor;
	// Creating two children (Split nodes)
	RoamSplitTriangleNode * leftchild1 = RoamSplitTriangleNode::getEmptyNode();
	RoamSplitTriangleNode * rightchild1 = RoamSplitTriangleNode::getEmptyNode();
	RoamSplitTriangleNode * leftchild2 = NULL;
	RoamSplitTriangleNode * rightchild2 = NULL;
	RoleBOOL pforceSplit = RoleFALSE;
	if (base !=NULL)
	{
		 leftchild2 = RoamSplitTriangleNode::getEmptyNode();
		 rightchild2 = RoamSplitTriangleNode::getEmptyNode();
	}
#ifdef SPLITDEBUG
	printf("spliting heap_index %i nodeNum %i\n"
			,node->heap_index ,node->nodeNum);
#endif

	RoamMergeDiamondNode * mNode = NULL;
	if ((mNode = node->nodeMerge) !=NULL)
	{
		if (mNode->nodeSplit[0]!=NULL)
		{
			if (mNode->nodeSplit[0]->LeftNeighbor != NULL)
			{
				mNode->nodeSplit[0]->LeftNeighbor->nodeMerge=NULL; 
			}
			mNode->nodeSplit[0]->nodeMerge=NULL;
		}
		if (mNode->nodeSplit[1]!=NULL)
		{
			if (mNode->nodeSplit[1]->LeftNeighbor !=NULL)
			{
				mNode->nodeSplit[1]->LeftNeighbor->nodeMerge=NULL; 
			}
			mNode->nodeSplit[1]->nodeMerge=NULL;
		}
#ifdef SPLITDEBUG
		printf("merge delete %i %i %i %i\n",mNode->nodeNum,node->nodeNum,mNode->heap_index,mergeQueue->getMySize());
#endif
		if (mNode->heap_index == -1)
			exit(1);
		mergeQueue->deleteAt(mNode->heap_index);
		RoamMergeDiamondNode::deleteNode(mNode);
		mNode = NULL;
	}
	if ((base != NULL) && (base->BaseNeighbor!=node))
	{
		// force split if this node is not a boundary or in a diamond
		// recursive call.
#ifdef SPLITDEBUG
		printf("force split heap_index %i\n",node->heap_index);
#endif
		split(node->BaseNeighbor); 
		base = node->BaseNeighbor;
		if (base->heap_index==-1)
		{
			printf("Huge error: base is not in the heap\n");
		}
#ifdef SPLITDEBUG
		printf("base nodeNum %i heap_index %i\n",base->nodeNum,base->heap_index);
#endif
		pforceSplit = RoleTRUE;
	}

	if ((base!=NULL) && ((mNode = base->nodeMerge) !=NULL))
	{
		if (mNode->nodeSplit[0]!=NULL)
		{
			if (mNode->nodeSplit[0]->LeftNeighbor != NULL)
			{
				mNode->nodeSplit[0]->LeftNeighbor->nodeMerge=NULL; 
			}
			mNode->nodeSplit[0]->nodeMerge=NULL;
		}
		if (mNode->nodeSplit[1]!=NULL)
		{
			if (mNode->nodeSplit[1]->LeftNeighbor !=NULL)
			{
				mNode->nodeSplit[1]->LeftNeighbor->nodeMerge=NULL; 
			}
			mNode->nodeSplit[1]->nodeMerge=NULL;
		}
#ifdef SPLITDEBUG
		printf("merge delete %i %i %i %i\n",mNode->nodeNum,node->nodeNum,mNode->heap_index,mergeQueue->getMySize());
#endif
		if (mNode->heap_index == -1)
			exit(1);
		mergeQueue->deleteAt(mNode->heap_index);
		RoamMergeDiamondNode::deleteNode(mNode);
		mNode = NULL;
	}
	// change neighbor's connection.
	if (node->LeftNeighbor!=NULL) 
	{
		if (node->LeftNeighbor->RightNeighbor == node)
		{
			node->LeftNeighbor->RightNeighbor = leftchild1;
		}
		else if (node->LeftNeighbor->BaseNeighbor == node)
		{
			node->LeftNeighbor->BaseNeighbor = leftchild1;
		}
		else 
		{
			printf("critical Error while changing node's left neighbors' %i %i %i\n"
					,node->nodeNum,node->LeftNeighbor->BaseNeighbor->nodeNum
					,node->LeftNeighbor->RightNeighbor->nodeNum);
			printf("Huge Error\n");
			exit(1);
		}
	}
	if (node->RightNeighbor !=NULL)
	{
		if (node->RightNeighbor->LeftNeighbor== node)
		{
			node->RightNeighbor->LeftNeighbor = rightchild1;
		}
		else if (node->RightNeighbor->BaseNeighbor == node)
		{
			node->RightNeighbor->BaseNeighbor = rightchild1;
		}
		else 
		{
			printf("critical Error while changing node's right neighbors' %i %i %i\n"
					,node->nodeNum
					,node->RightNeighbor->nodeNum
					,node->RightNeighbor->LeftNeighbor->nodeNum);
			if (node->RightNeighbor->LeftNeighbor == NULL)
			{
				printf("Huge Error\n");
				exit(1);
			}
//					,node->RightNeighbor->LeftNeighbor->nodeNum);
		}
	}
	// Trust Cache....
	// setting up left child.
	leftchild1->nodeNum = getLeftchildNodeNum(node->nodeNum);
//	printf("leftchild1 nodeNum %i\n",leftchild1->nodeNum);
	leftchild1->heap_index=-1;
	leftchild1->nodeMerge=NULL;
	// vtop of leftchild1 == center
	leftchild1->vtop.x = rightchild1->vtop.x
		= (node->vleft.x + node->vright.x) >> 1; 
	leftchild1->vtop.y = rightchild1->vtop.y
		= (node->vleft.y + node->vright.y) >> 1; 
	leftchild1->vtop.z = rightchild1->vtop.z 
		= heightMap[(leftchild1->vtop.x)+(leftchild1->vtop.y)*MAP_SIZE];
	// vleft of leftchild1 == top
	leftchild1->vleft.x = node->vtop.x; 
	leftchild1->vleft.y = node->vtop.y; 
	leftchild1->vleft.z = node->vtop.z; 
	// vright. of leftchild1 == left
	leftchild1->vright.x = node->vleft.x; 
	leftchild1->vright.y = node->vleft.y; 
	leftchild1->vright.z = node->vleft.z; 
	leftchild1->BaseNeighbor = node->LeftNeighbor;
	leftchild1->LeftNeighbor = rightchild1;
	leftchild1->RightNeighbor = rightchild2;
	setNormal(leftchild1);
	leftchild1->priority = getPriority(leftchild1);

	// setting up right child.
	rightchild1->nodeNum = getRightchildNodeNum(node->nodeNum);
	rightchild1->heap_index=-1;
	rightchild1->nodeMerge=NULL;
	// vtop of rightchild1 == center or same as leftchild1
	// check out leftchild1

	// vleft of rightchild1 == top
	rightchild1->vright.x = node->vtop.x; 
	rightchild1->vright.y = node->vtop.y; 
	rightchild1->vright.z = node->vtop.z; 
	// vright. of leftchild1 == left
	rightchild1->vleft.x = node->vright.x; 
	rightchild1->vleft.y = node->vright.y; 
	rightchild1->vleft.z = node->vright.z; 
	rightchild1->BaseNeighbor = node->RightNeighbor;
	rightchild1->LeftNeighbor = leftchild2;
	rightchild1->RightNeighbor = leftchild1;
	setNormal(rightchild1);
	rightchild1->priority = getPriority(rightchild1);

	if (base != NULL) // has a BaseNeighbor
	{
	// change neighbor's connection.
		if (base->LeftNeighbor!=NULL) 
		{
			if (base->LeftNeighbor->RightNeighbor == base)
			{
				base->LeftNeighbor->RightNeighbor = leftchild2;
			}
			else if (base->LeftNeighbor->BaseNeighbor == base)
			{
				base->LeftNeighbor->BaseNeighbor = leftchild2;
			}
			else 
			{
				printf("critical Error while changing base's left neighbors' %i %i\n",base->nodeNum
					,base->LeftNeighbor->nodeNum);
				printf("Huge Error\n");
				exit(1);
			}
		}
		if (base->RightNeighbor !=NULL)
		{
			if (base->RightNeighbor->LeftNeighbor== base)
			{
				base->RightNeighbor->LeftNeighbor = rightchild2;
			}	
			else if (base->RightNeighbor->BaseNeighbor == base)
			{
				base->RightNeighbor->BaseNeighbor = rightchild2;
			}
			else 
			{
//				printf("critical Error while changing base's right neighbors' %i %i %i\n"
//					,base->nodeNum,base->RightNeighbor->BaseNeighbor->nodeNum
//					,base->RightNeighbor->LeftNeighbor->nodeNum);
				printf("Huge Error\n");
				exit(1);
			}
		}
		if ((rightchild2 == NULL) || (leftchild2 == NULL))
		{
			printf("Not enough children\n");
			exit(1);
		}
		// setting up left child.
		leftchild2->nodeNum = getLeftchildNodeNum(base->nodeNum);
		leftchild2->heap_index=-1;
		leftchild2->nodeMerge=NULL;
		// vtop of leftchild1 == center
		leftchild2->vtop.x = rightchild2->vtop.x
			= (base->vleft.x + base->vright.x) >> 1; 
		leftchild2->vtop.y = rightchild2->vtop.y
			= (base->vleft.y + base->vright.y) >> 1; 
		leftchild2->vtop.z = rightchild2->vtop.z 
			= heightMap[(leftchild2->vtop.x)+(leftchild2->vtop.y)*MAP_SIZE];
		// vleft of leftchild1 == top
		leftchild2->vleft.x = base->vtop.x; 
		leftchild2->vleft.y  = base->vtop.y; 
		leftchild2->vleft.z = base->vtop.z; 
		// vright. of leftchild1 == left
		leftchild2->vright.x = base->vleft.x; 
		leftchild2->vright.y = base->vleft.y; 
		leftchild2->vright.z = base->vleft.z; 
		leftchild2->BaseNeighbor = base->LeftNeighbor;
		leftchild2->LeftNeighbor = rightchild2;
		leftchild2->RightNeighbor = rightchild1;
		setNormal(leftchild2);
		leftchild2->priority = getPriority(leftchild2);
		// setting up right child.
		rightchild2->nodeNum = getRightchildNodeNum(base->nodeNum);
		rightchild2->heap_index=-1;
		rightchild2->nodeMerge=NULL;

		// vtop of rightchild1 == center or same as leftchild1
		// check out leftchild1

		// vleft of rightchild1 == top
		rightchild2->vright.x = base->vtop.x; 
		rightchild2->vright.y = base->vtop.y; 
		rightchild2->vright.z = base->vtop.z; 
		// vright. of leftchild1 == left
		rightchild2->vleft.x = base->vright.x; 
		rightchild2->vleft.y = base->vright.y; 
		rightchild2->vleft.z = base->vright.z; 
		rightchild2->BaseNeighbor = base->RightNeighbor;
		rightchild2->LeftNeighbor = leftchild1;
		rightchild2->RightNeighbor = leftchild2;
		setNormal(rightchild2);
		rightchild2->priority = getPriority(rightchild2);
	}

	if (temp_heap_index == 0)
	{
		// if this split is at the top of split queue,
		// this node will be part of new mergeQueue
		// otherwise it is a waste to create merge node because it is going to be
		// deleted in the recursion process.
		mNode = RoamMergeDiamondNode::getEmptyNode();
		mNode->heap_index = -1;
		if ((base !=NULL) && 
			(node->priority < base->priority))
		{
			mNode->nodeNum = base->nodeNum;
			mNode->priority = base->priority;
		}
		else
		{
			mNode->nodeNum = node->nodeNum;
			mNode->priority = node->priority;
		}
		mNode->nodeSplit[0] = leftchild1;
		mNode->nodeSplit[1] = leftchild2; // don't care if it is NULL or not.
		mergeQueue->insert(mNode);
		leftchild1->nodeMerge = mNode;
		rightchild1->nodeMerge = mNode;
		if (leftchild2!=NULL)
		{
			leftchild2->nodeMerge = mNode;
			rightchild2->nodeMerge = mNode;
		}
#ifdef SPLITDEBUG
		printf("merge insert mNode nodeNum: %i  nodeNum %i %i %i\n",mNode->nodeNum,node->nodeNum,mNode->heap_index,mergeQueue->getMySize());
#endif
	}
	///////Finally!!!!!!!!!!!
	// taking care of splitQueue!
	if (base !=NULL)
	{
		splitQueue->insert(leftchild2);
		splitQueue->insert(rightchild2);
#ifdef SPLITDEBUG
		printf("deleting base heap_index %i %i %i\n",base->heap_index,base->nodeNum,splitQueue->getMySize());
#endif
		splitQueue->deleteAt(base->heap_index);
		RoamSplitTriangleNode::deleteNode(base);
	}
	splitQueue->insert(leftchild1);
	splitQueue->insert(rightchild1);
	// free node .
#ifdef SPLITDEBUG
	printf("deleting node heap_index %i nodeNum %i size %i\n",node->heap_index,node->nodeNum,splitQueue->getMySize());
	if (node->heap_index==-1)
		exit(1);
#endif
	splitQueue->deleteAt(node->heap_index);
	RoamSplitTriangleNode::deleteNode(node);
#ifdef SPLITDEBUG
	printf("successfully split split size %i merge size %i\n"
		,splitQueue->getMySize(),mergeQueue->getMySize());
#endif
}

void RoleRoam::merge(RoamMergeDiamondNode * node)
{
#define RIGHTCHILD 3
#define LEFTCHILD 4
#define WHOLE 5

	mergecounter++;
	// Children
	RoamSplitTriangleNode * leftchild1 = node->nodeSplit[0];
	RoamSplitTriangleNode * leftchild2 = node->nodeSplit[1];
/*	if ( ((leftchild1!=NULL) && (abs(leftchild1->vleft.x - leftchild1->vright.x) < 2 ) &&  //?? is it the bottom??
		  (abs(leftchild1->vleft.y - leftchild1->vright.y) < 2)) ||
		 ((leftchild2!=NULL) && (abs(leftchild2->vleft.x - leftchild2->vright.x) < 2 ) &&  //?? is it the bottom??
		  (abs(leftchild2->vleft.y - leftchild2->vright.y) < 2)))
	{
//		This is just updating priority in queue, destroying the priority
		if (leftchild1 == NULL)
		{
			node->priority = leftchild2->priority*1.5;//getPriority(leftchild2)/1.5;
			leftchild2->priority = node->priority;
			splitQueue->changePriorityAt(leftchild2->heap_index);
		}
		else if (leftchild2 == NULL)
		{
			node->priority = leftchild1->priority*1.5;//getPriority(leftchild1);
			leftchild1->priority = node->priority;
			splitQueue->changePriorityAt(leftchild1->heap_index);
		}
		else
		{
			RoleFLOAT parent1Priority = leftchild1->priority*1.5;//getPriority(leftchild1);
			leftchild1->priority= parent1Priority;
			splitQueue->changePriorityAt(leftchild1->heap_index);
			RoleFLOAT parent2Priority = leftchild2->priority*1.5;//getPriority(leftchild2);
			leftchild2->priority= parent2Priority;
			splitQueue->changePriorityAt(leftchild2->heap_index);

			node->priority = (parent1Priority > parent2Priority
				? parent1Priority: parent2Priority);
		}
		mergeQueue->changePriorityAt(node->heap_index);
		return;
	}
*/	RoamSplitTriangleNode * tri1 = NULL;
	RoamSplitTriangleNode * tri2 = NULL;
	// check if there is any left child.
	if (leftchild1!=NULL)
		tri1 = RoamSplitTriangleNode::getEmptyNode();
	if (leftchild2!=NULL)
		tri2 = RoamSplitTriangleNode::getEmptyNode();
	if (leftchild1 != NULL)
	{
		RoamSplitTriangleNode * rightchild1 = leftchild1->LeftNeighbor;
		leftchild1->nodeMerge=NULL; 
		rightchild1->nodeMerge=NULL;
		node->nodeSplit[0]=NULL;
		// creating new triangle (parent)
		tri1->nodeNum = getParentNodeNum(leftchild1->nodeNum);
		tri1->heap_index=-1;
		tri1->nodeMerge=NULL;
		// vtop of tri1 
		tri1->vtop.x = leftchild1->vleft.x;
		tri1->vtop.y = leftchild1->vleft.y;
		tri1->vtop.z = leftchild1->vleft.z;

		// vleft of tri1 
		tri1->vleft.x = leftchild1->vright.x; 
		tri1->vleft.y = leftchild1->vright.y; 
		tri1->vleft.z = leftchild1->vright.z; 

		// vright. of tri1
		tri1->vright.x = rightchild1->vleft.x; 
		tri1->vright.y = rightchild1->vleft.y; 
		tri1->vright.z = rightchild1->vleft.z; 
	
		tri1->BaseNeighbor = tri2;
		tri1->LeftNeighbor = leftchild1->BaseNeighbor;
		tri1->RightNeighbor = rightchild1->BaseNeighbor;
		setNormal(tri1);
		tri1->priority = getPriority(tri1);
		// change neighbor connection
		if (leftchild1->BaseNeighbor != NULL)
		{
			if (leftchild1->BaseNeighbor->BaseNeighbor == leftchild1)
			{
				leftchild1->BaseNeighbor->BaseNeighbor = tri1;
			}
			else if (leftchild1->BaseNeighbor->RightNeighbor == leftchild1)
			{
				leftchild1->BaseNeighbor->RightNeighbor = tri1;
			}
			else
			{
				printf("Critical error while mergeing leftchild1\n");
				exit(1);
			}
		}

		if (rightchild1->BaseNeighbor != NULL)
		{
			if (rightchild1->BaseNeighbor->BaseNeighbor == rightchild1)
			{
				rightchild1->BaseNeighbor->BaseNeighbor = tri1;
			}
			else if (rightchild1->BaseNeighbor->LeftNeighbor == rightchild1)
			{
				rightchild1->BaseNeighbor->LeftNeighbor = tri1;
			}
			else
			{
				printf("Critical error while mergeing rightchild1\n");
				exit(1);
			}
		}

		// check new mergeable diamond1.

		RoleINT pnewDiamond1 = 0;
		RoamMergeDiamondNode * newDiamond1 = NULL;
		if (leftchild1->BaseNeighbor == NULL)
		{
		// on the edge
			if ((rightchild1->BaseNeighbor!=NULL) && 
				(rightchild1->BaseNeighbor->RightNeighbor==NULL))
			{
				pnewDiamond1 = RIGHTCHILD; // on the edge.
			}
		}
		else if (rightchild1->BaseNeighbor == NULL)
		{
			if ((leftchild1->BaseNeighbor!=NULL) && 
				(leftchild1->BaseNeighbor->LeftNeighbor==NULL))
			{
				pnewDiamond1 = LEFTCHILD; // on the edge.
			}
		}
		else if (((leftchild1->BaseNeighbor->LeftNeighbor) 
			== (rightchild1->BaseNeighbor->RightNeighbor)) 
			&& ((leftchild1->BaseNeighbor->LeftNeighbor) != NULL))
			  
		{
			if ((tri1->nodeNum % 2) == 0)
			{
				pnewDiamond1 = LEFTCHILD; // new diamond.
			}
			else
			{
				pnewDiamond1 = RIGHTCHILD; // new diamond.
			}
		}
		if (pnewDiamond1==LEFTCHILD)
		{
			RoamSplitTriangleNode * left1 = tri1;
			RoamSplitTriangleNode * left2 =NULL;

			newDiamond1 = RoamMergeDiamondNode::getEmptyNode();
			newDiamond1->heap_index = -1;
			left1->nodeMerge=newDiamond1;
			left1->LeftNeighbor->nodeMerge=newDiamond1;

			left2 = leftchild1->BaseNeighbor->LeftNeighbor;
			RoleINT parent1Node = getParentNodeNum(left1->nodeNum);
			RoleFLOAT temp1 = getParentPriority(parent1Node,left1);
			if (left2 == NULL)
			{
				// it is certain that left1 != NULL
				// otherwise bug. let it blow  :)
				newDiamond1->nodeNum = parent1Node;
				newDiamond1->priority = temp1;
			}
			else
			{
				left2->nodeMerge=newDiamond1;
				left2->LeftNeighbor->nodeMerge=newDiamond1;
				RoleINT parent2Node = getParentNodeNum(left2->nodeNum);
				RoleFLOAT temp2 = getParentPriority(parent2Node,left2);//left2->priority;
				if	(temp1 > temp2)
				{
					newDiamond1->nodeNum = parent1Node;
					newDiamond1->priority = temp1;
				}
				else
				{
					newDiamond1->nodeNum = parent2Node;
					newDiamond1->priority = temp2;
				}
			}
			
			newDiamond1->nodeSplit[0] = left1;
			newDiamond1->nodeSplit[1] = left2; // don't care if it is NULL or not.
			mergeQueue->insert(newDiamond1);
#ifdef MERGEDEBUG
			printf("merging leftchild of node\n");
#endif
		}
		else if (pnewDiamond1==RIGHTCHILD)
		{
			RoamSplitTriangleNode * left1 = rightchild1->BaseNeighbor;
			RoamSplitTriangleNode * left2 =NULL;

			newDiamond1 = RoamMergeDiamondNode::getEmptyNode();
			newDiamond1->heap_index = -1;
			left1->nodeMerge=newDiamond1;
			tri1->nodeMerge=newDiamond1;//left1->LeftNeighbor==tri1
			RoleINT parent1Node = getParentNodeNum(left1->nodeNum);
			RoleFLOAT temp1 = getParentPriority(parent1Node,left1);//left1->priority;
			if (leftchild1->BaseNeighbor!=NULL)
				left2 = leftchild1->BaseNeighbor;
			if (left2 == NULL)
			{
				// it is certain that left1 != NULL
				// otherwise bug. let it blow  :)
				newDiamond1->nodeNum = parent1Node;
				newDiamond1->priority = temp1;
			}
			else
			{
				left2->nodeMerge=newDiamond1;
				left2->LeftNeighbor->nodeMerge=newDiamond1;
				RoleINT parent2Node = getParentNodeNum(left2->nodeNum);
				RoleFLOAT temp2 = getParentPriority(parent2Node,left2);//left2->priority;
				if	(temp1 > temp2)
				{
					newDiamond1->nodeNum = parent1Node;
					newDiamond1->priority = temp1;
				}
				else
				{
					newDiamond1->nodeNum = parent2Node;
					newDiamond1->priority = temp2;
				}
			}
			newDiamond1->nodeSplit[0] = left1;
			newDiamond1->nodeSplit[1] = left2; // don't care if it is NULL or not.
#ifdef MERGEDEBUG
			printf("merging rightchild of node\n");
#endif
			mergeQueue->insert(newDiamond1);
		}
		// Now delete all children from split queue
		splitQueue->deleteAt(leftchild1->heap_index);
		// index will be updated. don't worry.
		splitQueue->deleteAt(rightchild1->heap_index); 
		RoamSplitTriangleNode::deleteNode(leftchild1);
		RoamSplitTriangleNode::deleteNode(rightchild1);
		// Now, insert new triangles into split queue.
		splitQueue->insert(tri1);
	}
	if (leftchild2 != NULL)
	{
		RoamSplitTriangleNode * rightchild2 = leftchild2->LeftNeighbor;
		leftchild2->nodeMerge=NULL; 
		rightchild2->nodeMerge=NULL;
		node->nodeSplit[1]=NULL;
		// creating new triangle (parent)
		tri2->nodeNum = getParentNodeNum(leftchild2->nodeNum);
		tri2->heap_index=-1;
		tri2->nodeMerge=NULL;
		// vtop of tri1 
		tri2->vtop.x = leftchild2->vleft.x;
		tri2->vtop.y = leftchild2->vleft.y;
		tri2->vtop.z = leftchild2->vleft.z;
	
		// vleft of tri1 
		tri2->vleft.x = leftchild2->vright.x; 
		tri2->vleft.y = leftchild2->vright.y; 
		tri2->vleft.z = leftchild2->vright.z; 
	
		// vright. of tri1
		tri2->vright.x = rightchild2->vleft.x; 
		tri2->vright.y = rightchild2->vleft.y; 
		tri2->vright.z = rightchild2->vleft.z; 
		
		tri2->BaseNeighbor = tri1;
		tri2->LeftNeighbor = leftchild2->BaseNeighbor;
		tri2->RightNeighbor = rightchild2->BaseNeighbor;
		setNormal(tri2);
		tri2->priority = getPriority(tri2);

		if (leftchild2->BaseNeighbor != NULL)
		{
			if (leftchild2->BaseNeighbor->BaseNeighbor == leftchild2)
			{
				leftchild2->BaseNeighbor->BaseNeighbor = tri2;
			}
			else if (leftchild2->BaseNeighbor->RightNeighbor == leftchild2)
			{
				leftchild2->BaseNeighbor->RightNeighbor = tri2;
			}
			else
			{
				printf("Critical error while mergeing leftchild2\n");
				exit(1);
			}
		}

		if (rightchild2->BaseNeighbor != NULL)
		{
			if (rightchild2->BaseNeighbor->BaseNeighbor == rightchild2)
			{
				rightchild2->BaseNeighbor->BaseNeighbor = tri2;
			}
			else if (rightchild2->BaseNeighbor->LeftNeighbor == rightchild2)
			{
				rightchild2->BaseNeighbor->LeftNeighbor = tri2;
			}
			else
			{
				printf("Critical error while mergeing rightchild2\n");
				exit(1);
			}
		}

		// check new mergeable diamond2.

		RoleINT pnewDiamond2 = 0;
		RoamMergeDiamondNode * newDiamond2 = NULL;
		if (leftchild2->BaseNeighbor == NULL)
		{
		// on the edge
			if ((rightchild2->BaseNeighbor!=NULL) && 
				(rightchild2->BaseNeighbor->RightNeighbor==NULL))
			{
				pnewDiamond2 = RIGHTCHILD; // on the edge.
			}
		}
		else if (rightchild2->BaseNeighbor == NULL)
		{
			if ((leftchild2->BaseNeighbor!=NULL) && 
				(leftchild2->BaseNeighbor->LeftNeighbor==NULL))
			{
				pnewDiamond2 = LEFTCHILD; // on the edge.
			}
		}
		else if (((leftchild2->BaseNeighbor->LeftNeighbor) 
			== (rightchild2->BaseNeighbor->RightNeighbor)) 
			&& ((leftchild2->BaseNeighbor->LeftNeighbor) != NULL))
		{
			if ((tri2->nodeNum % 2) == 0)
				pnewDiamond2 = LEFTCHILD; // new diamond.
			else
			{
				pnewDiamond2 = RIGHTCHILD; // new diamond.
			}
		}
		if (pnewDiamond2==LEFTCHILD)
		{
			RoamSplitTriangleNode * left1 = tri2;
			RoamSplitTriangleNode * left2 =NULL;

			newDiamond2 = RoamMergeDiamondNode::getEmptyNode();
			newDiamond2->heap_index = -1;
			left1->nodeMerge=newDiamond2;
			left1->LeftNeighbor->nodeMerge=newDiamond2;

			left2 = leftchild2->BaseNeighbor->LeftNeighbor;
			RoleINT parent1Node = getParentNodeNum(left1->nodeNum);
			RoleFLOAT temp1 = getParentPriority(parent1Node,left1);//left1->priority;
			if (left2 == NULL)
			{
				// it is certain that left1 != NULL
				// otherwise bug. let it blow  :)
				newDiamond2->nodeNum = parent1Node;
				newDiamond2->priority = temp1;
			}
			else
			{
				left2->nodeMerge=newDiamond2;
				left2->LeftNeighbor->nodeMerge=newDiamond2;
				RoleINT parent2Node = getParentNodeNum(left2->nodeNum);
				RoleFLOAT temp2 = getParentPriority(parent2Node,left2);//left2->priority;
				if	(temp1 > temp2)
				{
					newDiamond2->nodeNum = parent1Node;
					newDiamond2->priority = temp1;
				}
				else
				{
					newDiamond2->nodeNum = parent2Node;
					newDiamond2->priority = temp2;
				}
			}
			newDiamond2->nodeSplit[0] = left1;
			newDiamond2->nodeSplit[1] = left2; // don't care if it is NULL or not.
#ifdef MERGEDEBUG
			printf("merging leftchild of base\n");
#endif
			mergeQueue->insert(newDiamond2);
		}
		else if (pnewDiamond2==RIGHTCHILD)
		{
			RoamSplitTriangleNode * left1 = rightchild2->BaseNeighbor;
			RoamSplitTriangleNode * left2 =NULL;

			newDiamond2 = RoamMergeDiamondNode::getEmptyNode();
			newDiamond2->heap_index = -1;
			left1->nodeMerge=newDiamond2;
			tri2->nodeMerge=newDiamond2;//left1->LeftNeighbor
			RoleINT parent1Node = getParentNodeNum(left1->nodeNum);
			RoleFLOAT temp1 = getParentPriority(parent1Node,left1);//left1->priority;
			if (leftchild2->BaseNeighbor!=NULL)
				left2 = leftchild2->BaseNeighbor;
			if (left2 == NULL)
			{
				// it is certain that left1 != NULL
				// otherwise bug. let it blow  :)
				newDiamond2->nodeNum = parent1Node;
				newDiamond2->priority = temp1;
			}
			else
			{
				left2->nodeMerge=newDiamond2;
				left2->LeftNeighbor->nodeMerge=newDiamond2;
				RoleINT parent2Node = getParentNodeNum(left2->nodeNum);
				RoleFLOAT temp2 = getParentPriority(parent2Node,left2);//left2->priority;
				if	(temp1 > temp2)
				{
					newDiamond2->nodeNum = parent1Node;
					newDiamond2->priority = temp1;
				}
				else
				{
					newDiamond2->nodeNum = parent2Node;
					newDiamond2->priority = temp2;
				}
			}
			newDiamond2->nodeSplit[0] = left1;
			newDiamond2->nodeSplit[1] = left2; // don't care if it is NULL or not.
#ifdef MERGEDEBUG
			printf("merging rightchild of base\n");
#endif
			mergeQueue->insert(newDiamond2);
		}
/*
		// check new mergeable diamond2.
		RoleBOOL pnewDiamond2 = RoleFALSE;
		RoamMergeDiamondNode * newDiamond2 = NULL;
		if (leftchild2->BaseNeighbor == NULL)
		{
		// on the edge
			if ((rightchild2->BaseNeighbor!=NULL) && 
				(rightchild2->BaseNeighbor->RightNeighbor==NULL))
			{
				pnewDiamond2 = RoleTRUE; // on the edge.
			}
		}
		else if (rightchild2->BaseNeighbor == NULL)
		{
			if ((leftchild2->BaseNeighbor!=NULL) && 
				(leftchild2->BaseNeighbor->LeftNeighbor==NULL))
			{
				pnewDiamond2 = RoleTRUE; // on the edge.
			}
		}
		else if ((leftchild2->BaseNeighbor->LeftNeighbor) 
			== (rightchild2->BaseNeighbor->RightNeighbor)) 
			  
		{
			pnewDiamond2 = RoleTRUE; // new diamond.
		}
		if (pnewDiamond2)
		{
			RoamSplitTriangleNode * left1 = rightchild2->BaseNeighbor;
			RoamSplitTriangleNode * left2 = leftchild2->BaseNeighbor;
			newDiamond2 = RoamMergeDiamondNode::getEmptyNode();
			newDiamond2->heap_index = -1;
			RoleINT parent1Node = getParentNodeNum(left1->nodeNum);
			RoleINT parent2Node = getParentNodeNum(left2->nodeNum);
			RoleINT temp1 = getPriority(parent1Node);
			RoleINT temp2 = getPriority(parent2Node);
			if (left2 == NULL)
			{
				// it is certain that left1 != NULL
				// otherwise bug. let it blow  :)
				newDiamond2->nodeNum = parent1Node;
				newDiamond2->priority = temp1;
			}
			else if (left1 == NULL)
			{
				// it is certain that left2 != NULL
				// otherwise bug. let it blow  :)
				newDiamond2->nodeNum = parent2Node;
				newDiamond2->priority = temp2;
			}
			else if	(temp1 > temp2)
			{
				newDiamond2->nodeNum = parent1Node;
				newDiamond2->priority = temp1;
			}
			else
				{
					newDiamond2->nodeNum = parent2Node;
					newDiamond2->priority = temp2;
				}	
			newDiamond2->nodeSplit[0] = left1; // don't care if it is NULL or not.
			newDiamond2->nodeSplit[1] = left2; // don't care if it is NULL or not.
			mergeQueue->insert(newDiamond2);
		}
*/		// Now delete all children from split queue
		splitQueue->deleteAt(leftchild2->heap_index);
		splitQueue->deleteAt(rightchild2->heap_index);
		RoamSplitTriangleNode::deleteNode(leftchild2);
		RoamSplitTriangleNode::deleteNode(rightchild2);
		// Now, insert new triangles into split queue.
		splitQueue->insert(tri2);
	}
	// Now it is time to delete current node from merge queue.
#ifdef MERGEDEBUG
//	printf("merge delete %i %i %i %i\n",mNode->nodeNum,node->nodeNum,mNode->heap_index,mergeQueue->getMySize());
	if (node->heap_index == -1)
		exit(1);
#endif
	mergeQueue->deleteAt(node->heap_index);
	RoamMergeDiamondNode::deleteNode(node);
#ifdef MERGEDEBUG
	printf("successfully merge split size %i merge size %i\n"
		,splitQueue->getMySize(),mergeQueue->getMySize());
#endif
}

RoleFLOAT inline RoleRoam::getPriority(RoamSplitTriangleNode * node)
{
	return getPriority(node->nodeNum
		,node->vtop.x,node->vtop.y,node->vtop.z
		,node->vleft.x,node->vleft.y, node->vleft.z
		,node->vright.x,node->vright.y,node->vright.z
		,node->faceorientation
		,node->normal);
}

RoleFLOAT inline RoleRoam::getParentPriority(RoleINT pnodeNum,RoamSplitTriangleNode * node)
{
	RoleFLOAT face = -10;
	RoleFLOAT normal[3] = {0.0f};
	normal[0] = -1000;
	return getPriority(pnodeNum
		,node->vleft.x,node->vleft.y,node->vleft.z
		,node->vright.x,node->vright.y,node->vright.z
		,2*node->vtop.x-node->vright.x
		,2*node->vtop.y-node->vright.y
		,2*node->vtop.z-node->vright.z
		,face
		,normal);
}

void inline RoleRoam::setNormal(RoamSplitTriangleNode * node)
{
	RoleFLOAT tx = (RoleFLOAT) node->vtop.x;
	RoleFLOAT ty = (RoleFLOAT) node->vtop.y;
	RoleFLOAT tz = (RoleFLOAT) node->vtop.z;
	crossProduct3f(node->vleft.x-tx
		,node->vleft.y-ty
		,node->vleft.z-tz
		,node->vright.x-tx
		,node->vright.y-ty
		,node->vright.z-tz
		,node->normal);
	RoleFLOAT size = sqrt(node->normal[0]*node->normal[0]
		+node->normal[1]*node->normal[1]+node->normal[2]*node->normal[2]);
	node->normal[0] /=size;
	node->normal[1] /=size;
	node->normal[2] /=size;
	node->faceorientation = dotProduct3f(node->normal
		,cameraX-tx,cameraY-ty,cameraZ-tz);
}

RoleFLOAT inline RoleRoam::getPriority(RoleINT nodeNum
	,RoleFLOAT tx, RoleFLOAT ty,RoleFLOAT tz
	,RoleFLOAT lx,RoleFLOAT ly, RoleFLOAT lz
	,RoleFLOAT rx,RoleFLOAT ry,	RoleFLOAT rz
	,RoleFLOAT faceorientation
	,RoleFLOAT normal[3])
{
	if (normal[0] < -10)
	{
		crossProduct3f(lx-tx,ly-ty,lz-tz,rx-tx,ry-ty,rz-tz,normal);
		faceorientation = dotProduct3f(normal
		,cameraX-tx,cameraY-ty,cameraZ-tz);
	}

	RoleFLOAT dx = myMin(absolute(cameraX-lx),
				   absolute(cameraX-rx),
				   absolute(cameraX-tx));
	RoleFLOAT dy = myMin(absolute(cameraY-ly),
				   absolute(cameraY-ry),
				   absolute(cameraY-ty));
	RoleFLOAT priority = 0;
	// need to include a lot of stuff.
//	return ((RoleFLOAT) errorTree[node->nodeNum]);
	if (dx < 1)
	{
		dx = 1;
	}
	if (dy < 1)
	{
		dy = 1;
	}
	// need to include a lot of stuff.
//	return ((RoleFLOAT) errorTree[node]);
//	return ((RoleFLOAT) errorTree[node])/sqrt(dx*dx+dy*dy)*40;

//	return priority;
	priority = errorTree[nodeNum];

	if ((((lx - cameraX)*(rx - cameraX) <= 0) ||
		 ((tx - cameraX)* (rx - cameraX) <= 0))
	&&(((ly - cameraY)*(ry - cameraY) <= 0) ||
		((ty - cameraY)* (ry - cameraY) <= 0)))
	{
		priority *= 2.0f;
	}
	else if (((tx  > cameraCenterX-5) && (tx < cameraCenterX+5)
			&& (ty  > cameraCenterY-5) && (ty < cameraCenterY+5)
			&& (tz > cameraCenterZ-5) && (tz < cameraCenterZ+5))
			|| ((lx  > cameraCenterX-5) && (lx < cameraCenterX+5)
			&& (ly  > cameraCenterY-5) && (ly < cameraCenterY+5)
			&& (lz > cameraCenterZ-5) && (lz < cameraCenterZ+5))
			|| ((rx  > cameraCenterX-5) && (rx < cameraCenterX+5)
			&& (ry  > cameraCenterY-5) && (ry < cameraCenterY+5)
			&& (rz > cameraCenterZ-5) && (rz < cameraCenterZ+5)))
	{
		priority *= 2.0f;
	}
	// culling.
/*	RoleFLOAT sizex = node->vtop.x-node->vright.x;
	RoleFLOAT sizey = node->vtop.y-node->vright.y;
	RoleFLOAT size = sqrt(sizex*sizex+sizey*sizey);
*/
	RoleINT size = nodeNum;
	if (size > HALFSIZEOFERROR)
	{
		size = size-HALFSIZEOFERROR;
	}
/*	for MAP_SIZE 256
	if ((size >> 18) > 0)
		size = MAP_SIZE >> 7;
	if ((size >> 16) > 0)
		size = MAP_SIZE >> 7;
	else if ((size >> 13) > 0)
		size = MAP_SIZE >> 6;
	else if ((size >> 9) > 0)
		size = MAP_SIZE >> 5;
	else if ((size >> 7) > 0)
		size = MAP_SIZE >> 4;
	else if ((size >> 5) > 0)
		size = MAP_SIZE >> 3;
	else if ((size >> 3) > 0)
		size = MAP_SIZE >> 2;
	else
		size = MAP_SIZE >> 1;
*/
	if ((size >> 18) > 0)
		size = MAP_SIZE >> 8;
	else if ((size >> 16) > 0)
		size = MAP_SIZE >> 7;
	else if ((size >> 14) > 0)
		size = MAP_SIZE >> 6;
	else if ((size >> 12) > 0)
		size = MAP_SIZE >> 5;
	else if ((size >> 9) > 0)
		size = MAP_SIZE >> 4;
	else if ((size >> 5) > 0)
		size = MAP_SIZE >> 3;
	else if ((size >> 3) > 0)
		size = MAP_SIZE >> 2;
	else
		size = MAP_SIZE >> 1;
	if (!areaInFrustum(tx*Terrain::CELLSIZE,ty*Terrain::CELLSIZE, size*Terrain::CELLSIZE/2 ,MAP_SIZE,player->m_Frustum))
	{
		faceorientation = -100.0f;
		priority /=100000000.0f;
	}
	else if (faceorientation > 0.2)
	{
		priority =2.0f*(priority+1.0f/(dx*dx+dy*dy));
	}
	else
	{
		priority += 1.0f/(dx*dx+dy*dy);//avoid sqrt expensive
	}

	if ( (absolute(lx - rx) < 2 ) &&  //?? is it the bottom??
		 (absolute(ly - ry) < 2) )
	{
		priority /=2.0f;
	}
	return priority;
}


void inline drawTriangle(RoamSplitTriangleNode * node)
{
	glBegin(GL_TRIANGLES);
	glVertex3i((node->vtop.x),node->vtop.y,node->vtop.z);
	glVertex3i((node->vleft.x),node->vleft.y,node->vleft.z);
	glVertex3i((node->vright.x),node->vright.y,node->vright.z);
	glEnd();
}


void RoleRoam::draw_triangles()// rendering procedure, easiest part.
{
	glPolygonMode(GL_FRONT,GL_LINE);
	glDisable(GL_TEXTURE_2D);
	for (int i = 0; i < splitQueue->getMySize();i++)
	{
		glColor3f(1.0,0.0,1.0);
		drawTriangle(splitQueue->queue[i]);
	}
	if (i > 0)
	{
		if (splitQueue->queue[0]->BaseNeighbor !=NULL)
		{
			glColor3f(0.0,1.0,1.0);
			drawTriangle(splitQueue->queue[0]->BaseNeighbor);
		}
		if (splitQueue->queue[0]->RightNeighbor !=NULL)
		{
			glColor3f(0.0,0.5,1.0);
			drawTriangle(splitQueue->queue[0]->RightNeighbor);
		}
		if (splitQueue->queue[0]->LeftNeighbor !=NULL)
		{
			glColor3f(0.0,1.0,0.5);
			drawTriangle(splitQueue->queue[0]->LeftNeighbor);
		}
		glColor3f(1.0,1.0,1.0);
		drawTriangle(splitQueue->queue[0]);
	}
	if (mergeQueue->getMySize() > 0)
	{
		glColor3f(1.0,0.7,0.7);
		if (mergeQueue->queue[0]->nodeSplit[0]!=NULL)
			drawTriangle(mergeQueue->queue[0]->nodeSplit[0]);
		if (mergeQueue->queue[0]->nodeSplit[1]!=NULL)
			drawTriangle(mergeQueue->queue[0]->nodeSplit[1]);
	}
	glColor3f(1.0,1.0,1.0);
	glBegin(GL_QUADS);
	glVertex3f(cameraX-1,cameraY-1,cameraZ);
	glVertex3f(cameraX-1,cameraY+1,cameraZ);
	glVertex3f(cameraX+1,cameraY-1,cameraZ);
	glVertex3f(cameraX+1,cameraY+1,cameraZ);
	glEnd();
	glPolygonMode(GL_FRONT,GL_FILL);
	glColor3f(1.0,1.0,1.0);
	RoleFLOAT x = (player->getCameraCenterX()/Terrain::CELLSIZE);
	RoleFLOAT y = (player->getCameraCenterY()/Terrain::CELLSIZE);
	RoleFLOAT z = (player->getCameraCenterZ()/Terrain::CELLSIZE);

	rotateCoord(RIGHT,20*800/600,cameraX,cameraZ,cameraY,&x,&y,&z);
	glBegin(GL_LINES);
	glVertex3f(x,z,y);
	glVertex3f(cameraX,cameraY,cameraZ);
	glEnd();
	rotateCoord(LEFT,40*800/600,cameraX,cameraZ,cameraY,&x,&y,&z);
	glBegin(GL_LINES);
	glVertex3f(x,z,y);
	glVertex3f(cameraX,cameraY,cameraZ);
	glEnd();
	glEnable(GL_TEXTURE_2D);
}

/*

void display(void)
{
	glClearColor(0.0,0.0,0.0,0.0);
//	glColor3f(0.0,0.0,0.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();
	gluLookAt(0.0f,0.0f,10.0f,0.0f,0.0f,0.0f,0.0f,1.0f,0.0f);
	roam->draw_triangles();
	printf("in display\n");
	glPopMatrix();
	glFlush();
	glutSwapBuffers();

}

void reshape(int w, int h)
{
	glViewport(0,0,(GLsizei) w, (GLsizei) h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
//	gluPerspective(40.0f, (GLfloat) (w)/(GLfloat) (h), 0.1f, 500.0f);
	glOrtho(0,w/2,0,h/2,-100,100);		
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	printf("in reshape\n");
}
int gsplitcounter = 0;
int gmergecounter = 0;
void keyboard(unsigned char key, int x, int y)
{
	switch (key) {
	case '8':
		roam->cameraY+=10.0f;
		roam->updateFrame();
		glutPostRedisplay();
		break;
	case '9':
		roam->cameraX+=1.0f;
		roam->cameraY+=1.0f;
		roam->updateFrame();
		glutPostRedisplay();
		break;
	case '1':
		roam->cameraX-=1.0f;
		roam->cameraY-=1.0f;
		roam->updateFrame();
		glutPostRedisplay();
		break;
	case '6':
		roam->cameraX+=1.0f;
		roam->updateFrame();
		glutPostRedisplay();
		break;
	case 'm':
		gmergecounter++;
		printf("mergecounter %i size of queue %i size of merge %i\n",gmergecounter,
			roam->splitQueue->getMySize(),roam->mergeQueue->getMySize());
		roam->merge(roam->mergeQueue->top());
		glutPostRedisplay();
		break;
	case 's':
		gsplitcounter++;
		printf("splitcounter %i size of queue %i priority of top %g\n",gsplitcounter,
			roam->splitQueue->getMySize(),roam->splitQueue->top()->priority);
		roam->split(roam->splitQueue->top());
		glutPostRedisplay();
		break;
	case 'Y':
		glutPostRedisplay();
		break;
	default:
		break;
	}
}
GLfloat light_position[] = {1.0,1.0,1.0,1.0};

void init (void)
{
//	glEnable(GL_LIGHT0);
	glClearColor(0.0,0.0,0.0,0.0);
	glShadeModel(GL_FLAT);
}


int main(int argc, char ** argv)
{
	roam = new RoleRoam(4000,15.5, "hmap.bmp");
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
	glutInitWindowSize(512,512);
	glutInitWindowPosition(100,100);
	glutCreateWindow(argv[0]);
	init();
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
	glutMainLoop();
/*	for (int i = 0 ; i < roam->SIZEOFERROR;i++)
	{
		printf(" %4u ",roam->errorTree[i]);
		if ((i% 20) == 0)
		{
			printf("\n");
		}
	}
	printf(" %4u ",roam->counter);
//	update_triangle();
	return 0;
}
*/


