/*
	player.h
	
	  Player class for Role Project.
	 
	Player class is mainly dealing with local player.
	In multiplayer mode, just do the same thing for player objects. 
	see more about multiplayer after private:

	(c) 2001 by Byung Gil Yuh

*/
#ifndef player_header
#define player_header

#include "types.h"
#include "RoleNetwork.h"

class Object;
class Area;

class Player
{
public:
	
	/* default constructor.*/
	
	Player(Area * a, RoleINT network);

	~Player();

	// object culling function.
	RoleBOOL culling(Object * ob);
	RoleBOOL Player::pick_culling(Object * ob);

/*
	
	  controlling of camera

*/
	void cameraGoFront(RoleFLOAT  amount);
	void cameraGoBack(RoleFLOAT  amount);
	void cameraZoomIn(RoleFLOAT  amount);
	void cameraZoomOut(RoleFLOAT  amount);
	void cameraGoUp(RoleFLOAT  amount);
	void cameraGoDown(RoleFLOAT  amount);
	void cameraTurnRight(RoleFLOAT  amount);
	void cameraTurnLeft(RoleFLOAT  amount);
	void cameraGoRight(RoleFLOAT  amount);
	void cameraGoLeft(RoleFLOAT  amount);
	// setting camera at the object location
	void cameraSetObject(Object * ob);
	// set the comera coordinate manually
	void cameraSetCoord(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z);

	void setControlObj(Object * ob);
	Object * getControlObj() const;
	// object control. For multiplayer purpose,
	// everycommands that affects object should go through 
	// the following functions.
	void ObjectGoToAndAttack(RoleINT idx, RoleFLOAT amount); // added by Raymond
	void ObjectCastFireball(RoleFLOAT newDirX, RoleFLOAT newDirZ);
	void ObjectCastLightning();
	void ObjectAttack();
	void ObjectGoFront(RoleFLOAT  amount);
	void ObjectGoBack(RoleFLOAT  amount);
	void ObjectTurnRight(RoleFLOAT  amount);
	void ObjectTurnLeft(RoleFLOAT  amount);
	void ObjectGoRight(RoleFLOAT  amount);
	void ObjectGoLeft(RoleFLOAT  amount);
	void ObjectGoToObject(RoleINT idx, RoleFLOAT  amount);
	void ObjectGoToXZ(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT  amount);
	// temp methods... must be modified
	void switchWeapon(RoleINT wid);

	void preevents();
	void processObjectEvents();

	// model view transformation. 
	// cameraSet Must be in display() function in Role.cpp
	void cameraSet(); 
	void setVisibility(RoleFLOAT cutting);
	RoleFLOAT getVisibility();
	void gotoObj();
	RoleFLOAT getCameraX();
	RoleFLOAT getCameraY();
	RoleFLOAT getCameraZ();
	RoleFLOAT getCameraCenterX();
	RoleFLOAT getCameraCenterY();
	RoleFLOAT getCameraCenterZ();
	RoleFLOAT getDistanceFromCamera(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z);
	RoleINT getCameraMode();
	void setCameraMode(RoleINT mode);


	/* 
	this flag is for the interaction with NPC in order to create story line.
	Initialization is done when the game starts.
	the format of flag is undecided yet.
	*/
	void initializeFlag();
	void setFlag(int flagNum);


	RoleFLOAT m_Frustum[6][4];  // Frustum of player
	RoleFLOAT p_Frustum[6][4];  // Frustum of player
	void enterArea(Area * a);
	void enterArea(Area * a,RoleRecevingPACKET * receivedPacket);
	Area * getArea() const;

private:

	// the following type is for multiplayer. total 14 bytes.
	// this is not designed for massive multiplayer but for 8 players
	// with 56K modem connected to internet. (in worst case.)
	// for each tick, the server must receive packet from each client.
	// otherwise all games halt until the response comes back. 
	/*

1. each computer sending new user input data to server
2. as soon as the server gets new data, sending back to all clients.
3. the processing player object is always the same order. After getting all data's
from other computers.

	for client : sending 14bytes -> receiving 14bytes*(num of players - 1)
	for server : receiving 14bytes * (num of players - 1)
				 sending  14bytes * (num of players - 1)

  so input reaction time :  server's sending&receiving time 
  + some extra delaying time for sending & receiving packet. 
	8 Players :	total bytes :14*14 = 252bytes. 
	And 56K modem can get only 4Kbytes data per seconds.
	: Then...196B/4.0(K/S)/1024B/K= 0.04785 seconds. at most.
	This plus some delaying... then about 20frames/seconds.

  This is synchronized version.
  See processObjectEvents to understand the process.

  asynchronized version? I don't know...

	typedef struct rolePacket_t {
		RoleSHORT type;
		RoleFLOAT x;
		RoleFLOAT z;
		RoleINT data;
	} RolePACKET;
*/
//	Player must have area & control object to exist... 
	Area * area;
	Object * controlObj;
	RoleFLOAT camera_position[3];
	RoleFLOAT camera_center[3];
	RoleFLOAT camera_up[3];
	RoleFLOAT cut;
	RoleINT cameraMode;
	RoleFLOAT centerFromObject[3];
	RoleFLOAT positionFromCenter[3];
	RoleFLOAT angleDiffObject;
	RoleFLOAT heightDiffObject;
//	this will be the list of flag 
	vector<RoleINT *> listofFlag;
	void addFlag(RoleINT flag);
	RolePACKET packet;
	RoleRecevingPACKET receivedPacket;
	RoleINT playerID;
	Object * players[MAX_PLAYER];
	void processPlayer(RolePACKET * packet);

	/* 
	these are for the multiplayer information for the future.

	long unsigned int PlayerID;
	Log * playerlog;
	Passwd * password;
	LoginID * loginID;

	*/
	RoleNetwork * connection;
};

#endif
