/*
	player.cpp
	
	  Player class for the Role Project.
	  see player.h for more information.

	(c) 2001 by Byung Gil Yuh

*/

#include "player.h"
#include "area.h"
#include "object.h"
#include "actionObj.h"
#include "util.h"
#include "rolenetwork.h"
#include "graphic.h"
Player::~Player()
{
	if (connection != NULL) 
		delete connection;
}

Player::Player(Area * a,RoleINT numPlayer)
{
	heightDiffObject=2.0;
	positionFromCenter[1]=3.7;
	camera_up[0]=0.0;
	camera_up[1]=1.0;
	camera_up[2]=0.0;
	cut = 1100.0;
	cameraMode = MANUAL;
	angleDiffObject = 180;
	if (numPlayer > 1)
	{
		receivedPacket.number = numPlayer;
		connection = new RoleNetwork(RoleNetwork::CLIENT,&receivedPacket);
		enterArea(a,&receivedPacket); // initialize other things
		controlObj=players[playerID];
		rolePrintlog("PlayerID = %i\n",playerID);
		packet.type=0;
	}
	else
	{
		connection = NULL;
		enterArea(a); // initialize other things
	}
}

// multiplayer enter area
void Player::enterArea(Area * a,RoleRecevingPACKET * receivedPacket)
{
	if (a == NULL)
	{
		rolePrintlog("Area does not exist\n");
		quit_role(1);
	}
	area = a;
	// initial position
	playerID = receivedPacket->number >> 16;
	camera_center[0]=receivedPacket->player[playerID].x;
	camera_center[2]=receivedPacket->player[playerID].z;
	camera_center[1]=area->getTerrain()->getHeight(camera_center[0],
						camera_center[2])+heightDiffObject;
	packet.x = camera_center[0];
	packet.z = camera_center[2];
	packet.data=0;

	positionFromCenter[0] = 0;
	positionFromCenter[1] = 3.0f;
	positionFromCenter[2] = -10.5f;
	camera_position[0]=camera_center[0]+positionFromCenter[0];
	camera_position[1]=camera_center[1]+positionFromCenter[1];
	camera_position[2]=camera_center[2]+positionFromCenter[2];
	for (int i = 0; i < MAX_PLAYER; i++)
	{
		if (receivedPacket->player[i].type!=-1)
		{
			if (i != 0)
			{
				players[i] = new ActionObject(area,NULL,receivedPacket->player[i].x ,
						0.0f,
						receivedPacket->player[i].z,0.5,1.0,0.5,"yohko",Object::PLAYER);
				players[i]->setMode(Object::STANDING);
				Object * weapon = new Object(area,NULL,receivedPacket->player[i].x  ,
								0.0f,
								receivedPacket->player[i].z,0.5,5.0,0.5,"w_yohko",Object::WEAPON);
				area->getObjectManager()->removeObject(weapon);
				players[i]->getItem(weapon);
				players[i]->equipItem(0,0);
			}
			else 
			{
				players[i] = new ActionObject(area,NULL,receivedPacket->player[i].x ,
						0.0f,
						receivedPacket->player[i].z,0.5,1.0,0.5,"knight",Object::PLAYER);
				players[i]->setMode(Object::STANDING);
				Object * weapon = new Object(area,NULL,receivedPacket->player[i].x ,
							0.0f,
							receivedPacket->player[i].z,0.5,5.0,0.5,"W_bfg",Object::WEAPON);
				area->getObjectManager()->removeObject(weapon);
				players[i]->getItem(weapon);
				weapon = new Object(area,NULL,receivedPacket->player[i].x ,
							0.0f,
							receivedPacket->player[i].z,0.5,5.0,0.5,"sword",Object::WEAPON);
				area->getObjectManager()->removeObject(weapon);
				players[i]->getItem(weapon);
				weapon = new Object(area,NULL,receivedPacket->player[i].x ,
								0.0f,
								receivedPacket->player[i].z,0.5,5.0,0.5,"mace",Object::WEAPON);
				area->getObjectManager()->removeObject(weapon);
				players[i]->getItem(weapon);
				players[i]->equipItem(0,0);		
			}
		}
	}
}

void Player::enterArea(Area * a)
{
	if (a == NULL)
	{
		rolePrintlog("Area does not exist\n");
		quit_role(1);
	}
	area = a;
	// initial position
	camera_center[0]=area->getTerrain()->getSizeX()*Terrain::CELLSIZE/2.0f;
	camera_center[1]=area->getTerrain()->getHeight(camera_center[0],
						camera_center[2])+heightDiffObject;
	camera_center[2]=area->getTerrain()->getSizeY()*Terrain::CELLSIZE/2.0f;
	positionFromCenter[0] = 0;
	positionFromCenter[1] = 3.0f;
	positionFromCenter[2] = -10.5f;
	camera_position[0]=camera_center[0]+positionFromCenter[0];
	camera_position[1]=camera_center[1]+positionFromCenter[1];
	camera_position[2]=camera_center[2]+positionFromCenter[2];
	if (controlObj == NULL)
	{
		controlObj = new ActionObject(area,NULL,camera_center[0] ,
				0.0f,
				camera_center[2],0.5,1.0,0.5,"knight",Object::PLAYER);
		controlObj->setMode(Object::STANDING);
/*		Object * weapon = new Object(area,NULL,camera_center[0] ,
						0.0f,
						camera_center[2],0.5,5.0,0.5,"w_yohko",Object::WEAPON);
		area->getObjectManager()->removeObject(weapon);
		controlObj->getItem(weapon);
		controlObj->equipItem(0,0);
*/
		Object * weapon = new Object(area,NULL,camera_center[0] ,
						0.0f,
						camera_center[2],0.5,5.0,0.5,"W_bfg",Object::WEAPON);
		area->getObjectManager()->removeObject(weapon);
		controlObj->getItem(weapon);
		weapon = new Object(area,NULL,camera_center[0] ,
						0.0f,
						camera_center[2],0.5,5.0,0.5,"sword",Object::WEAPON);
		area->getObjectManager()->removeObject(weapon);
		controlObj->getItem(weapon);
		weapon = new Object(area,NULL,camera_center[0] ,
						0.0f,
						camera_center[2],0.5,5.0,0.5,"mace",Object::WEAPON);
		area->getObjectManager()->removeObject(weapon);
		controlObj->getItem(weapon);
		controlObj->equipItem(0,0);

		packet.x = camera_center[0];
		packet.z = camera_center[2];
		packet.data=0;
		players[0] = controlObj;
	}
	else
	{
		controlObj->enterArea(area);
	}
}

Area * Player::getArea() const
{
	return area;
}

RoleBOOL Player::culling(Object * ob)
{
	return !(cubeInFrustum(ob->getLocationX(),ob->getLocationY(),
					ob->getLocationZ(), ob->getWidth(), m_Frustum));

/*	return ((ob->getLocationX()+cut < camera_position[0]) ||
			(ob->getLocationZ()+cut < camera_position[2]) ||
			(ob->getLocationX()-cut > camera_position[0]) ||
			(ob->getLocationZ()-cut > camera_position[2]));
*/	// no culling now...
//	return 0;
}

RoleBOOL Player::pick_culling(Object * ob)
{
	return !(cubeInFrustum(ob->getLocationX(),ob->getLocationY(),
					ob->getLocationZ(), ob->getWidth(), p_Frustum));

/*	return ((ob->getLocationX()+cut < camera_position[0]) ||
			(ob->getLocationZ()+cut < camera_position[2]) ||
			(ob->getLocationX()-cut > camera_position[0]) ||
			(ob->getLocationZ()-cut > camera_position[2]));
*/	// no culling now...
//	return 0;
}

/*********************************************************
			Camera Control Begin
*********************************************************/
RoleINT Player::getCameraMode()
{
	return cameraMode;
}
void Player::setCameraMode(RoleINT mode)
{
	cameraMode = mode;
}

// Camera Direction --------------------------------------
void Player::cameraZoomIn(RoleFLOAT amount)
{
	RoleFLOAT dx = positionFromCenter[0];
	RoleFLOAT dz = positionFromCenter[2];
	RoleFLOAT damount = sqrt(absolute(dx*dx) + absolute(dz*dz));
	if (damount > amount)
	{
		positionFromCenter[0] -= dx/damount*amount;
		positionFromCenter[2] -= dz/damount*amount;
	}
	area->getTerrain()->updateTerrain();
}

void Player::cameraZoomOut(RoleFLOAT  amount)
{
	RoleFLOAT dx = positionFromCenter[0];
	RoleFLOAT dz = positionFromCenter[2];
	RoleFLOAT damount = sqrt(absolute(dx*dx) + absolute(dz*dz));
	positionFromCenter[0] += dx/damount*amount;
	positionFromCenter[2] += dz/damount*amount;
	area->getTerrain()->updateTerrain();
}

void Player::cameraGoFront(RoleFLOAT  amount)
{
	// buggy. change it later
	RoleFLOAT dx = positionFromCenter[0];
	RoleFLOAT dz = positionFromCenter[2];
	RoleFLOAT damount = sqrt(absolute(dx*dx) + absolute(dz*dz));

	if (damount <= 1.0)
	{
		damount = 1.0;
	}
	if (camera_position[0] < camera_center[0])
	{
		camera_position[0] += amount*dx / damount;
	}
	else
	{
		camera_position[0] -= amount*dx / damount;
	}
	if (camera_position[2] < camera_center[2])
	{
		camera_position[2] += amount*dz / damount;
	}
	else
	{
		camera_position[2] -= amount*dz / damount;
	}
	area->getTerrain()->updateTerrain();
}


void Player::cameraGoBack(RoleFLOAT  amount)
{
	// buggy. change it later
	RoleFLOAT dx = camera_center[0]-camera_position[0];
	RoleFLOAT dz = camera_center[2]-camera_position[2];
	RoleFLOAT damount = sqrt(absolute(dx*dx) + absolute(dz*dz));

	if (damount <= 1.0)
	{
		damount = 1.0;
	}
	if (camera_position[0] > camera_center[0])
	{
		camera_position[0] += amount*dx / damount;
	}
	else
	{
		camera_position[0] -= amount*dx / damount;
	}
	if (camera_position[2] > camera_center[2])
	{
		camera_position[2] += amount*dz / damount;
	}
	else
	{
		camera_position[2] -= amount*dz / damount;
	}
	area->getTerrain()->updateTerrain();
}


void Player::cameraGoRight(RoleFLOAT  amount)
{
	rotateCoord(LEFT,amount, 0.0f,0.0f,0.0f
		,&(positionFromCenter[0]),&(positionFromCenter[1]),&(positionFromCenter[2]));
	area->getTerrain()->updateTerrain();
}

void Player::cameraGoLeft(RoleFLOAT  amount)
{
	rotateCoord(RIGHT,amount, 0.0f,0.0f,0.0f
		,&(positionFromCenter[0]),&(positionFromCenter[1]),&(positionFromCenter[2]));
	area->getTerrain()->updateTerrain();
}

void Player::cameraTurnRight(RoleFLOAT  amount)
{
}
void Player::cameraTurnLeft(RoleFLOAT  amount)
{
}

void Player::cameraGoUp(RoleFLOAT  amount)
{
	positionFromCenter[1]+=amount;
	area->getTerrain()->updateTerrain();
}
void Player::cameraGoDown(RoleFLOAT  amount)
{
	positionFromCenter[1]-=amount;
	area->getTerrain()->updateTerrain();
}
// Camera Direction End --------------------------------------

// setting camera at the object location
void Player::cameraSetObject(Object * ob)
{
}
	// set the comera coordinate manually
void Player::cameraSetCoord(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z)
{
	camera_position[0] = x;
	camera_position[1] = y;
	camera_position[2] = z;
	if (controlObj ==NULL)
	{
		camera_center[0] = x;
		camera_center[1] = y;
		camera_center[2] = z+1;
	}
	else
	{
		camera_center[0] = controlObj->getLocationX();
		camera_center[1] = controlObj->getLocationY();
		camera_center[2] = controlObj->getLocationZ();
	}
	area->getTerrain()->updateTerrain();
}

void Player::gotoObj()
{
	camera_center[0] = controlObj->getLocationX();
	camera_center[1] = controlObj->getLocationY()+heightDiffObject;
	camera_center[2] = controlObj->getLocationZ();
	positionFromCenter[0] = 0;
	positionFromCenter[1] = 3.0f;
	positionFromCenter[2] = -10.5f;
	angleDiffObject = 180;
	area->getTerrain()->updateTerrain();
}

void cameraFollowObj()
{
	// by using two directional vectors, get some smooth camera moving toward object direction.

}

void Player::cameraSet()
{
	if (cameraMode == AUTO)
	{
		RoleFLOAT damount = sqrt(positionFromCenter[0]*positionFromCenter[0]
			+positionFromCenter[2]*positionFromCenter[2]);
		positionFromCenter[0] = controlObj->getDirectionX()*damount;
		positionFromCenter[2] = controlObj->getDirectionZ()*damount;
		rotateCoord(LEFT,angleDiffObject, 0.0f,0.0f,0.0f
			,&(positionFromCenter[0]),&(positionFromCenter[1]),&(positionFromCenter[2]));
		
	}
	camera_center[0] = controlObj->getLocationX();
	camera_center[1] = controlObj->getLocationY()+heightDiffObject;
	camera_center[2] = controlObj->getLocationZ();
	camera_position[0] = camera_center[0]+positionFromCenter[0];
	camera_position[1] = camera_center[1]+positionFromCenter[1];
	camera_position[2] = camera_center[2]+positionFromCenter[2];
	gluLookAt(camera_position[0], camera_position[1], camera_position[2],
		camera_center[0],camera_center[1],camera_center[2],
		camera_up[0],camera_up[1],camera_up[2]);
}


/*********************************************************
			Camera Control End
*********************************************************/

/*********************************************************
 object control. Probably main character - For multiplayer... how would you do?
*********************************************************/

// Added by Raymond
void Player::ObjectGoToAndAttack(RoleINT idx, RoleFLOAT amount)
{
	packet.type = COMMANDGOTOANDATTACK;
	packet.data = amount;
	packet.x = (RoleFLOAT) idx;
	packet.z = 0;
}

void Player::ObjectCastFireball(RoleFLOAT newDirX, RoleFLOAT newDirZ)
{
	packet.type = COMMANDFIREBALL;
	packet.x = (RoleFLOAT) newDirX;
	packet.z = (RoleFLOAT) newDirZ;
}

void Player::ObjectCastLightning()
{
	packet.type = COMMANDLIGHTNING;
}

void Player::ObjectAttack()
{
	packet.type = COMMANDATTACK;
}


void Player::ObjectTurnLeft(RoleFLOAT  amount)
{
//	controlObj->turnLeft(amount);
	if (cameraMode==AUTO)
	{
		cameraGoRight(amount);
	}
	packet.type = COMMANDTURNLEFT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}

void Player::ObjectTurnRight(RoleFLOAT  amount)
{
//	controlObj->turnRight(amount);
	if (cameraMode==AUTO)
	{
		cameraGoLeft(amount);
	}
	packet.type = COMMANDTURNRIGHT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}

void Player::ObjectGoFront(RoleFLOAT  amount)
{
//	RoleBOOL result = controlObj->goFront(amount);
	packet.type = COMMANDGOFRONT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}

void Player::ObjectGoBack(RoleFLOAT  amount)
{
//	RoleBOOL result = controlObj->goBack(amount);
	packet.type = COMMANDGOBACK;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}

void Player::ObjectGoRight(RoleFLOAT  amount)
{
	packet.type = COMMANDGORIGHT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}

void Player::ObjectGoLeft(RoleFLOAT  amount)
{
//	RoleBOOL result = controlObj->goLeft(amount);
	packet.type = COMMANDGOLEFT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}
/* Not valid anymore
void Player::ObjectGoToObject(Object * o, RoleFLOAT  amount)
{
//	controlObj->goToObject(o,amount);
	packet.type = COMMANDGOTOOBJECT;
	packet.data = amount;
	packet.x = 0;
	packet.z = 0;
}
*/
void Player::ObjectGoToObject(RoleINT idx, RoleFLOAT  amount)
{
//	controlObj->goToObject(o,amount);
	packet.type = COMMANDGOTOOBJECT;
	packet.data = amount;
	packet.x = (RoleFLOAT) idx;
	packet.z = 0;
}

void Player::ObjectGoToXZ(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT  amount)
{
	packet.type = COMMANDGOTOXZ;
	packet.data = amount;
	packet.x = x;
	packet.z = z;
}


void Player::switchWeapon(RoleINT wid)
{
	controlObj->equipItem(wid,0);
}


void Player::processPlayer(RolePACKET * packet)
{
	RoleINT playerID =  packet->type >> 16;
	RoleINT type = packet->type%(256*256);
	switch (type)
	{
		// added by Raymond
	case COMMANDGOTOANDATTACK:
		players[playerID]->goToAndDestroy(area->getObjectManager()->getObjectAt((RoleINT)packet->x));
		break;
	case COMMANDFIREBALL:
		players[playerID]->setDirectionX(packet->x);
		players[playerID]->setDirectionZ(packet->z);
		players[playerID]->casting(Object::CASTINGFIREBALL);
		break;
	case COMMANDLIGHTNING:
		players[playerID]->casting(Object::CASTINGLIGHTNING);
		break;
	case COMMANDATTACK:
		players[playerID]->attack();
		break;
	case COMMANDGOTOXZ:
		players[playerID]->goToXZ(packet->x,0.0,packet->z,packet->data);
		break;
	case COMMANDGOTOOBJECT:
		if (packet->x >= 0)
			players[playerID]->goToObject(
					area->getObjectManager()->getObjectAt((RoleINT) packet->x),
					packet->data);
		break;
	case COMMANDGOFRONT:
		players[playerID]->goFront(packet->data);
		break;
	case COMMANDGOBACK:
		players[playerID]->goBack(packet->data);
		break;
	case COMMANDGORIGHT:
		players[playerID]->goRight(packet->data);
		break;
	case COMMANDGOLEFT:
		players[playerID]->goLeft(packet->data);
		break;
	case COMMANDTURNRIGHT:
		players[playerID]->turnRight(packet->data);
		break;
	case COMMANDTURNLEFT:
		players[playerID]->turnLeft(packet->data);
		break;
	default:
		break;
	}
	players[playerID]->playerAction();
}


void Player::processObjectEvents()
{
	if (connection != NULL)
	{
		if (packet.type == 0)
		{
			packet.type = 9999;
		}
		packet.type += playerID*256*256;
		if (connection->clientProcess(&packet,&receivedPacket))
		{
			for (int i = 0; i < MAX_PLAYER; i++)
			{
				if (receivedPacket.player[i].type != -1)
				{
					processPlayer(&(receivedPacket.player[i]));
				}
				else if (players[i]!=NULL)
				{
					area->getObjectManager()->removeObject(players[i]);
					delete players[i];
					players[i] = NULL;
				}
			}
		}
	//		controlObj->playerAction();
		if (packet.type !=0)
			area->getTerrain()->updateTerrain();
		packet.type = 0;
		packet.x = 0;
		packet.z = 0;
		packet.data = 0;
	}
	else
	{
		processPlayer(&packet);
		if (packet.type !=0)
			area->getTerrain()->updateTerrain();
	}

	/*  Byung Gil Yuh. 
	
	  This is multiplayer algorithm I have in mind.

	if (playerID == serverID)
	{
		wait for Player Packets From All Other Players;
		(If the time limit exceeds, ignore the player packet
		 and delay the object action for that player)
		get Packets.
		make Sending Packet for each player.
		send To Every Player In The Order Of Received Time.
	}
	else 
	{
		sendPlayerPacketForThisComputer
		waitServerPacket.
		receiveAndMake data for object actions.
	}

	for (number of players)
	{
		switch (data[i].type)
		{
			do object[objID]->something with x,z,data;
		}

	}
	*/
}

void Player::preevents()
{
	RoleINT mode = 0;
	if (connection != NULL)
	{
		for (int i = 0; i < MAX_PLAYER; i++)
		{
			if (players[i]!=NULL)
			{
				mode = players[i]->getMode();
				if ((mode !=Object::GOTOXZ) && (mode !=Object::GOTOOBJECT) &&
					(mode !=Object::ATTACKING) && (mode !=Object::DEATH) && (mode != Object::PAIN)
					&& (mode !=Object::CASTINGFIREBALL) && (mode != Object::CASTINGLIGHTNING) )
				{
					players[i]->setMode(Object::STANDING);
				}	
				else if ((mode ==Object::GOTOXZ) || (mode ==Object::GOTOOBJECT))
				{
					area->getTerrain()->updateTerrain();
				}
			}
		}
	}
	else
	{
		if (players[0]!=NULL)
		{
			mode = players[0]->getMode();
			if ((mode !=Object::GOTOXZ) && (mode !=Object::GOTOOBJECT) &&
				(mode !=Object::ATTACKING) && (mode !=Object::DEATH) && (mode != Object::PAIN) 
				&& (mode !=Object::CASTINGFIREBALL) && (mode != Object::CASTINGLIGHTNING))
			{
				players[0]->setMode(Object::STANDING);
			}
			else if ((mode ==Object::GOTOXZ) || (mode ==Object::GOTOOBJECT))
			{
				area->getTerrain()->updateTerrain();
			}
		}
	}
	packet.type=0;
	packet.x=0;
	packet.z=0;
	packet.data=0;
}

/*********************************************************
 Get and set functions.
*********************************************************/

RoleFLOAT Player::getDistanceFromCamera(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z)
{
	if (cameraMode == ATZERO)
	{
		return 0.0f;
	}
	RoleFLOAT dx = camera_position[0] - x;
	RoleFLOAT dy = camera_position[1] - y;
	RoleFLOAT dz = camera_position[2] - z;

	return sqrt(dx*dx+dy*dy+dz*dz);
}


RoleFLOAT Player::getVisibility()
{
	return cut;
}

// this function should be removed.. too dangerous..??
void Player::setControlObj(Object * ob)
{
	controlObj = ob;
}

Object * Player::getControlObj() const
{
	return controlObj;
}
RoleFLOAT Player::getCameraX()
{
	return camera_position[0];
}
RoleFLOAT Player::getCameraY()
{
	return camera_position[1];
}
RoleFLOAT Player::getCameraZ()
{
	return camera_position[2];
}
RoleFLOAT Player::getCameraCenterX()
{
	return camera_center[0];
}
RoleFLOAT Player::getCameraCenterY()
{
	return camera_center[1];
}
RoleFLOAT Player::getCameraCenterZ()
{
	return camera_center[2];
}


void Player::setVisibility(RoleFLOAT cutting)
{
	cut = cutting;
}

