/*****************************************************************************
**
**  object.h
**	
**	  Object class for Role Project.
**	
**	  This class is basic unit for the project.
**    Since it is graphic independent, it can be used for any other
**    game unit. 2D, 1D, even for text.
**
**  Major function : contains all necessary info for each object
**  Design Idea       : Everything shown in the game window
** 					 must be an object except the terrain
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/
#ifndef object_header
#define object_header


#include "behavior.h"
#include "types.h"

/*---------------------------------------------------------------------//

   Object class

   The parent of all objects. All objects have basic properties(location,
   height, width, length, graphic) and special attributes for each child class.

//---------------------------------------------------------------------*/
class Area;
class Object;
class Graphic;
class Attribute;
class Player;


class Object
{
public:
	
	/* default constructor.
	to create an object we need basic properties.
	note that blank attribute field is created in this constructor.
	the actual attribute will be created in each child class.*/
	
	Object(Area * curr_area, Attribute * a, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT height, RoleFLOAT width,
		RoleFLOAT length, string name, RoleINT type__);
	// copier
	Object (const Object & source);
	~Object();

	Attribute * getAttributePtr() const;
	void drawStatus(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z); 

	void turnLeft(RoleFLOAT  amount);
	void turnRight(RoleFLOAT  amount);
	RoleBOOL goFront(RoleFLOAT  amount);
	RoleBOOL goBack(RoleFLOAT  amount);
	RoleBOOL goRight(RoleFLOAT  amount);
	RoleBOOL goLeft(RoleFLOAT  amount);
	RoleBOOL attack();
	RoleBOOL gotHit(int);
// Item management
	RoleBOOL getItemFromArea(Object * o);
	RoleBOOL loseItemToArea(Object * o);
	RoleBOOL getItem(Object * o);
	RoleBOOL loseItem(Object * o);
	RoleBOOL getItemFromObject(Object * o, Object * from);
	RoleBOOL loseItemToObject(Object * o, Object * to);
// temporary function.
	RoleBOOL equipItem(RoleINT itemIndex, RoleINT where);
	Object * getWeapon() const;
	vector<Object *> * getItemList();
	void syncronizeLocDirFrame(Object * o);
	
	RoleBOOL goToXZ(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z,RoleFLOAT  amount);
	RoleBOOL goToObject(Object * targetOb, RoleFLOAT  amount);
	// not yet made begin
	RoleBOOL pnearObject(Object * ob,RoleFLOAT howfar);
	// not yet made end

	void wandering(RoleFLOAT  amount);

	RoleFLOAT getLocationX() const;
	RoleFLOAT getLocationY() const;
	RoleFLOAT getLocationZ() const;

	void setLocationX(RoleFLOAT x);
	void setLocationY(RoleFLOAT y);
	void setLocationZ(RoleFLOAT z);

	RoleFLOAT getDirectionX() const;
	RoleFLOAT getDirectionY() const;
	RoleFLOAT getDirectionZ() const;

	void setDirectionX(RoleFLOAT x);
	void setDirectionY(RoleFLOAT y);
	void setDirectionZ(RoleFLOAT z);

	// Maybe these functions are unnecessary.
	RoleFLOAT getHeight() const;
	RoleFLOAT getWidth() const;
	RoleFLOAT getLength() const;

	RoleFLOAT getDestX() const; 
	RoleFLOAT getDestY() const;
	RoleFLOAT getDestZ() const;

	string getName() const;
	RoleINT getType() const;

	Graphic * getGraphicPtr() const;
	Area * getArea() const;

	RoleBOOL pcollide(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z,
					  RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz,Object * ob);

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //
	void seekAndDestroy();
	void goToAndDestroy(Object* enemy);
	vector<Object *> * getObjectsWithinRange(RoleFLOAT range, RoleFLOAT angle);
	RoleBOOL withinRange(Object* enemy, RoleFLOAT range, RoleFLOAT angle); 
	Object * getClosestObject(vector<Object *> *);
	void casting(RoleINT magic);

	RoleBOOL goFrontFireball(RoleFLOAT amount);
	
// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //
	
	long unsigned int getId() const;
	// drawing on the screen if the object is in the frustum.
	// Basically, it is just giving the 3d vertices & textures 
	// for the display function in Role.cpp

	void draw(Player * p);
	void pick_draw(Player * p,RoleUINT pickID);
	void draw(RoleFLOAT x, RoleFLOAT y,RoleFLOAT z,
		RoleFLOAT dx, RoleFLOAT dy, RoleFLOAT dz,Player * p);

	void action();
	void playerAction();
	RoleINT getMode();
	void setMode(RoleINT next_mode);
	static const RoleINT STANDING;// 0
	static const RoleINT RUNNING; //1
	static const RoleINT ATTACKING; //2
	static const RoleINT PAIN; //3
	static const RoleINT DEATH; //4
	static const RoleINT GOTOXZ;
	static const RoleINT GOTOOBJECT;
	static const RoleINT DEAD;// = 7;
	static const RoleINT CASTINGFIREBALL; //8
	static const RoleINT CASTINGLIGHTNING;  //9
	static const RoleINT FIREBALLMODE;  // 20
	static const RoleINT LIGHTNINGMODE;
	static const RoleINT FIREMODE;
	
//Object Type
	// action object
	static const RoleINT ACTIONOBJBEGIN;
	static const RoleINT PLAYER;
	static const RoleINT NPC;
	static const RoleINT MONSTER;
	static const RoleINT FIREBALL;
	static const RoleINT LIGHTNING;
	static const RoleINT FIRE;
	static const RoleINT ACTIONOBJEND;
	// plain object
	static const RoleINT STATIONOBJBEGIN;
	static const RoleINT TREES;
	static const RoleINT HOUSE;
	static const RoleINT STATIONOBJEND;
	// item object
	static const RoleINT ITEMBEGIN;
		static const RoleINT WEAPONBEGIN;
			static const RoleINT WEAPON;
		static const RoleINT WEAPONEND;
		static const RoleINT ARMORBEGIN;
			static const RoleINT ARMOR;
		static const RoleINT ARMOREND;
		static const RoleINT MANAPOTION;
		static const RoleINT HEALTHPOTION;
	static const RoleINT ITEMEND;

	void enterArea(Area * a);


private:

	long unsigned int nextId;
	long unsigned int id;

protected:

	friend class Behavior;
	friend class Graphic;
	friend class Attribute;

	// just for now.. should be changed later.
	Object * weapon;
	Object * armor;

	string name;
	// Essential Variables.. do not change frequently
	Area * area;
	RoleFLOAT location [3];
	RoleFLOAT direction [3];
	RoleINT mode;
	RoleINT type;

	vector<Object *> itemList; 

	/* height, width, length is for collision detection for all objects */
	RoleFLOAT size[3];

	RoleFLOAT nextLocation[3];
	/* use it if object is moving toward some location */
	RoleFLOAT dest[4];

	/* use it if object is targeting some object, Possibly attack and moving*/
	Object * target;
	// Graphic class ... for now I have no idea how to implement this.
	// Check out Graphic header.
	Graphic * graphic;

	Attribute * attribute;

	void makeId();
	void commonAction();

	/* this behavior classs is eventually the script engine. we can create story line 
	by setting special behavior such as...
	-> talking, giving inform, wandering, giving item according to the player's status,
	-> Some kind of interpretor or compiled structure as learned cs61a... 
	but for now just c++ class.
	*/
	Behavior * behavior;
};

#endif
