/*****************************************************************************
**
**  object.cpp (needs OpenGL lib)
**	
**	  Object class for the Role Project.
**	
**	  This class is the basic unit for the project.
**
**	see more in object.h
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/
#include "object.h"
#include "player.h"
#include "area.h"
#include "util.h"
#include "attribute.h"
#include "graphic.h"
#include "actionObj.h"
#include <string.h>
#include "audio.h"
//#define GOTODEBUG 5

// Mode Constants...
const RoleINT Object::STANDING = 0;
const RoleINT Object::RUNNING = 1;
const RoleINT Object::ATTACKING = 2;
const RoleINT Object::PAIN = 3;
const RoleINT Object::DEATH = 4;
const RoleINT Object::GOTOXZ = 5;
const RoleINT Object::GOTOOBJECT = 6;
const RoleINT Object::DEAD = 7;
const RoleINT Object::CASTINGFIREBALL = 8;
const RoleINT Object::CASTINGLIGHTNING = 9;
const RoleINT Object::FIREBALLMODE = 20;
const RoleINT Object::LIGHTNINGMODE = 21;
const RoleINT Object::FIREMODE = 22;
// action object
const RoleINT Object::ACTIONOBJBEGIN = 0;
const RoleINT Object::PLAYER = 1;
const RoleINT Object::NPC= 2;
const RoleINT Object::MONSTER= 3;
const RoleINT Object::FIREBALL = 4;
const RoleINT Object::LIGHTNING = 5;
const RoleINT Object::FIRE = 6;
const RoleINT Object::ACTIONOBJEND = 100000;
	// plain object
const RoleINT Object::STATIONOBJBEGIN = 100001;
const RoleINT Object::TREES= 100002;
const RoleINT Object::HOUSE= 100003;
const RoleINT Object::STATIONOBJEND = 199999;
	// Item 
const RoleINT Object::ITEMBEGIN = 200000;
	const RoleINT Object::WEAPONBEGIN = 200001;
		const RoleINT Object::WEAPON = 200002;
	const RoleINT Object::WEAPONEND = 209999;
	const RoleINT Object::ARMORBEGIN = 210000;
		const RoleINT Object::ARMOR = 210001;
	const RoleINT Object::ARMOREND = 219999;
const RoleINT Object::MANAPOTION = 220004;
const RoleINT Object::HEALTHPOTION = 220005;
const RoleINT Object::ITEMEND = 1000000;

Object::Object(Area * curr_area, Attribute * a, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT width, RoleFLOAT height,
			   RoleFLOAT length, string n, RoleINT type__ ):name(n),type(type__)
{

	if (curr_area == NULL)
	{
		rolePrintlog("curr_area is null, cannot create object\n");
	}
	area = NULL;
	armor = NULL;
	weapon = NULL;
	attribute = a;
	graphic = new Graphic(name,this);
	location[0] = x;
	location[1] = 0.0f;
	location[2] = z;
	direction[0] = 0;
	direction[1] = 0;
	direction[2] = 1.0;

	size[0]=width;
	size[1]=height;
	size[2]=length;
	behavior = NULL;
	mode = STANDING;
	dest[0]=0.0f;
	dest[1]=0.0f;
	dest[2]=0.0f;
	dest[3]=0.0f;
	target = NULL;
	behavior = NULL;
	enterArea(curr_area);
	location[1] = area->getTerrain()->getHeight(x,z)+y;

	if (type__ == Object::PLAYER || type__ == Object::MONSTER || type__ == Object::NPC || type__ == Object::FIREBALL || type__ == Object::LIGHTNING || type__ == Object::FIRE)  {
		if (attribute == NULL) {
			attribute = new Attribute(1);
		}
	}
}

void Object::drawStatus(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z) 
{
	// HP BAR
	if (attribute !=NULL) {

		glDisable(GL_TEXTURE_2D);
//		printChars (x, y, "Hit  Point");

//		printChars (x + 0.200, y, "(%i/%i)",
//			attribute->hp,
//			attribute->level * HP_PER_LEVEL);

		glDisable (GL_TEXTURE_2D);
		glColor3f(1.0f,0.2f,0.3f);
		glBegin(GL_QUADS);
			glVertex3f(x +0.5f - (1.0f * attribute->hp /
				(attribute->level * HP_PER_LEVEL)) *
				1.0f , y, z);
			glVertex3f(x +0.5f- (1.0f * attribute->hp /
				(attribute->level * HP_PER_LEVEL)) *
				1.0f + x , y + 0.15, z);
			glVertex3f(x +0.5f, y + 0.15, z);
			glVertex3f(x +0.5f, y, z );
		glEnd();
		glColor3f(1.0f,1.0f,1.0f);
		glBegin(GL_QUADS);
			glVertex3f(x -0.5f, y, z);
			glVertex3f(x -0.5f, y + 0.15,z);
			glVertex3f(x+0.5f-(1.0f * attribute->hp /
				(attribute->level * HP_PER_LEVEL)) *
				1.0f , y + 0.15 , z);
			glVertex3f(x+0.5f-(1.0f * attribute->hp /
				(attribute->level * HP_PER_LEVEL)) *
				1.0f , y, z);
		glEnd();
		glColor3f(1.0f,1.0f,1.0f);
		glEnable (GL_TEXTURE_2D);
	}
}
	


Object::Object( const Object &source ) 
{
	// fill up later.
}

Object::~Object()
{
	delete graphic;
	delete behavior;
	if (attribute != NULL) delete attribute;
}

void Object::enterArea(Area * a)
{
	if (area !=NULL)
	{
		if (!area->removeObject(this))
		{
			rolePrintlog("Cannot Remove Object from area %s\n",area->getName().data());
			quit_role(1);
		}
	}
	area = a;
	if (a == NULL)
	{
		rolePrintlog("Area does not exist\n");
		quit_role(1);
	}
	area->addObject(this);
}

RoleBOOL Object::pcollide(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z ,
						  RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz ,Object * ob)
{
	if (((x - location[0] < size[0]+sx) && (x  - location[0] > -size[0]- sx))
		&& ((y - location[0]  < (size[1]+sy)*2.0) && (y - location[1] > -size[1] - sy))
		&& ((z - location[2]  < size[2]+sz) && (z -location[2] > -size[2]- sz)))
	{
		if (this != ob)
		{
//			rolePrintlog("%f,%f,%f %f %f %f  can go?\n",location[0],size[0],location[1],size[1]
//			,location[2],size[2]);
			//ob->location[1]=0.0f;
			return RoleTRUE;
		}
		return RoleFALSE;
	}
	else
		return RoleFALSE;
}


void Object::playerAction()
{
	commonAction();
}

void Object::action()
{
	if ((behavior !=NULL) && 
		(type!=Object::PLAYER))
	{
//		mode = STANDING;
		commonAction();
	}
}

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //
void Object::casting(RoleINT magic) {
	if (attribute->canAttack == RoleTRUE) {
		mode = magic;
	}
}

void Object::seekAndDestroy() {
	vector<Object *>* rangeObjects = getObjectsWithinRange(SIGHT_RANGE, SIGHT_ANGLE);
	Object* enemy = getClosestObject(rangeObjects);
	delete rangeObjects;

	if (enemy == NULL || enemy->getType() == Object::FIREBALL) {
		// no enemy within sight
		wandering(0.5);
		return;
	}
	goToAndDestroy(enemy);
}

void Object::goToAndDestroy(Object* enemy) {
	if (withinRange(enemy, attribute->range, ATTACKABLE_ANGLE) == RoleTRUE) {
		// enemy within range, attack!
		goToObject(enemy, 0.5);
		mode = ATTACKING;
	} else {
		// walk towards the enemy
		goToObject(enemy, 0.5);
	}
}

void Object::commonAction()
{
	if (behavior !=NULL)
	{
		behavior->action(mode);
	}

	// Process sound effects (how to tell players appart in multiplayer though?
	if (getType() == Object::PLAYER) {
		vector<Object *>* objectList = getObjectsWithinRange(128.0f, 3.15f);
		Object* currentObject = NULL;
		RoleFLOAT xDist, zDist;
		int distance;
		for (int i = 0; i < objectList->size(); i++) {
			currentObject = (*objectList)[i];
			xDist = currentObject->getLocationX() - getLocationX();
			zDist = currentObject->getLocationZ() - getLocationZ();

			distance = 	sqrt(xDist * xDist + zDist * zDist);
			cout << distance << endl;
			if (distance <= 128) {
				if (currentObject->getMode() == Object::PAIN) {
					bgmusic->ReplayAudio(1, 128 - distance);
				} else if (currentObject->getMode() == Object::DEATH) {
				}
			}
		}
	}

	if (mode==GOTOXZ)
	{
		RoleFLOAT dx = dest[0]-location[0];
		RoleFLOAT dz = dest[2]-location[2];
		if ((absolute(dx) > 0.5)
			|| (absolute(dz) > 0.5))
		{
			RoleFLOAT damount = sqrt(dx*dx+dz*dz);
			direction[0] = dx/damount;
			direction[2] = dz/damount;
			goFront(dest[3]);
			mode = GOTOXZ;
#ifdef GOTODEBUG
			rolePrintlog("keep going to %f %f now %f %f\n",dest[0],dest[2],location[0],location[2]);
#endif
		}
		else
		{
			mode = STANDING;
		}
	}
	else if (mode==GOTOOBJECT)  
	{
		if (target != NULL)
		{
			dest[0] = target->getLocationX();
			dest[2] = target->getLocationZ();
			RoleFLOAT dx = dest[0]-location[0];
			RoleFLOAT dz = dest[2]-location[2];
			if ((absolute(dx) > size[0]+target->getWidth()+0.5)
				|| (absolute(dz) > size[2]+target->getLength()+0.5))
			{
				RoleFLOAT damount = sqrt(dx*dx+dz*dz);
				direction[0] = dx/damount;
				direction[2] = dz/damount;
				goFront(dest[3]);
				mode = GOTOOBJECT;
#ifdef GOTODEBUG
				rolePrintlog("keep going to %f %f now %f %f\n",dest[0],dest[2],location[0],location[2]);
#endif
			}
			else
			{
				mode = STANDING;
			}
		}
	}
	else if (mode==ATTACKING)
	{
		// Code for checking attack
#ifdef ATTACKDEBUG
//		rolePrintlog("keep attacking\n");
#endif
		
		if (graphic->getModel()->getCurrentFrame() == graphic->getModel()->getLastFrame(ATTACKING)) {
			// get range set and locate enemy to decrease its HP
			
			vector<Object *>* rangeObjects = getObjectsWithinRange(attribute->range, ATTACKABLE_ANGLE);
			Object* enemy = getClosestObject(rangeObjects);
			// changed by Gil. ------ Better use delete when it is created by new.
			// Or maybe it is better to use dereference? (&)
			delete rangeObjects;
			if (enemy == NULL) {
				return;
			}
			RoleINT damage = 0;
			if ((float)rand() / (float)RAND_MAX <= attribute->hit) {
				damage = attribute->level * ATK_PER_LEVEL + 0;
			}
			// target's mode should be changed to PAIN and decrease HP
			if (enemy->getName() == "chicken") {
				if (enemy->gotHit(damage) == RoleTRUE) {
					attribute->hp = HP_PER_LEVEL * attribute->level;
					attribute->canAttack = RoleTRUE;
				}
			} else if (attribute->canAttack == RoleTRUE && enemy->gotHit(damage) == RoleTRUE) {
				// killed a non-chicken
				attribute->exp += enemy->getAttributePtr()->level * EXP_PER_LEVEL;
				if (attribute->exp >= attribute->level * attribute->level) {
					attribute->exp = 0;
					attribute->level++;
				}
			}
			mode = STANDING; // won't continue attacking
		}
	} 
	else if (mode==PAIN) {
		// Code for in pain mode
#ifdef ATTACKDEBUG
//		rolePrintlog("being attacked/Pain");
#endif
		if (graphic->getModel()->getCurrentFrame() == graphic->getModel()->getLastFrame(PAIN)) {
			mode = STANDING;
		}
	}
	// added by gil yuh.
	else if (mode==DEATH) {
		if ( graphic->getModel()->getCurrentFrame() == graphic->getModel()->getLastFrame(DEATH)) {
			mode = DEAD;
		}
	} else if (mode==CASTINGFIREBALL)
	{
		if (graphic->getModel()->getCurrentFrame() == graphic->getModel()->getLastFrame(CASTINGFIREBALL)) {
			if (attribute->mp >= MP_PER_FIREBALL) { 	
				attribute->mp -= MP_PER_FIREBALL;
	
				// Introduce fireball object -- currently just a chicken
				Object * new_ob = new ActionObject(area, NULL,
					location[0] + direction[0] * (FIREBALL_HITRANGE + 0.1), 0, location[2] + direction[2] * (FIREBALL_HITRANGE + 0.1), 0.5f, 1.0f, 0.5f,
					"fireball",Object::FIREBALL);
	
		
				new_ob->getAttributePtr()->owner = this;
				new_ob->mode = FIREBALLMODE;
				new_ob->dest[0] = location[0] + direction[0] * 20;
				new_ob->dest[1] = location[1] + direction[1] * 20;
				new_ob->dest[2] = location[2] + direction[2] * 20;
				new_ob->dest[3] = 0.5;
				new_ob->direction[0] = direction[0];
				new_ob->direction[1] = direction[1];
				new_ob->direction[2] = direction[2];
			}	
			mode = STANDING;
		}
	} else if (mode == FIREBALLMODE) {
		//cout << "Fireball introduced and looping action" << endl;
		RoleFLOAT dx = dest[0]-location[0];
		RoleFLOAT dz = dest[2]-location[2];
		if ((absolute(dx) > 0.5) || (absolute(dz) > 0.5)) {
			// Haven't reached destination yet
			RoleFLOAT damount = sqrt(dx*dx+dz*dz);
			direction[0] = dx/damount;
			direction[2] = dz/damount;
			if (goFrontFireball(dest[3]) == RoleFALSE) {
				// collide with something
				vector<Object *>* rangeObjects = getObjectsWithinRange(FIREBALL_HITRANGE, FIREBALL_HITANGLE);
				Object* enemy = getClosestObject(rangeObjects);
				delete rangeObjects;
				if (enemy != NULL) {
					if (enemy->gotHit(FIREBALL_DAMAGE_PER_LEVEL * attribute->owner->getAttributePtr()->level) == RoleTRUE) {
						attribute->owner->getAttributePtr()->exp += enemy->getAttributePtr()->level * EXP_PER_LEVEL;
						if (attribute->owner->getAttributePtr()->exp >= attribute->owner->getAttributePtr()->level * 
																		attribute->owner->getAttributePtr()->level) {
							attribute->owner->getAttributePtr()->exp = 0;
							attribute->owner->getAttributePtr()->level++;
						}
					}
					//bgmusic->ReplayAudio(1);
				}
				//area->getObjectManager()->getCollisionTable()->removeObject(this);
				area->removeObject(this);
				delete this;
				return; 
			}
			// keep going
		} else {
			// Reached destination without hitting
			//area->getObjectManager()->getCollisionTable()->removeObject(this);
			area->removeObject(this);
			delete this;
			return;
		}
		mode = FIREBALLMODE;
	} else if (mode == CASTINGLIGHTNING) {
		if (graphic->getModel()->getCurrentFrame() == graphic->getModel()->getLastFrame(CASTINGLIGHTNING)) {
			if (attribute->mp >= MP_PER_LIGHTNING) { 	
				attribute->mp -= MP_PER_LIGHTNING;
	
				vector<Object *>* rangeObjects = getObjectsWithinRange(LIGHTNING_HITRANGE, LIGHTNING_HITANGLE);
				Object* enemy;
				for (int i = 0; i < rangeObjects->size(); i++) {
					enemy = (*rangeObjects)[i];
					if (this != enemy && enemy->getAttributePtr() != NULL) {
						// Introduce lightning object 
						Object * new_ob = new ActionObject(area, NULL,
							enemy->getLocationX(), 0, enemy->getLocationZ(), 0.5f, 1.0f, 0.5f,
							"lightning",Object::LIGHTNING);
	
						// need to remove new_ob from collision table

						new_ob->getAttributePtr()->owner = enemy;
						new_ob->mode = LIGHTNINGMODE;
						new_ob->direction[0] = direction[0];
						new_ob->direction[1] = direction[1];
						new_ob->direction[2] = direction[2];
						
						if (enemy->gotHit(LIGHTNING_DAMAGE_PER_LEVEL * attribute->level) == RoleTRUE) {
							attribute->exp += enemy->getAttributePtr()->level * EXP_PER_LEVEL;
							if (attribute->exp >= attribute->level * attribute->level) {
								attribute->exp = 0;
								attribute->level++;
							}
						}
						//new_ob->getAttributePtr()->set_level(2); // to increase hp for lightning to determine how long it lasts
					}
				}
				delete rangeObjects;
			}
			mode = STANDING;
		}		
	} else if (mode == LIGHTNINGMODE) {
		attribute->owner->setMode(Object::PAIN);
		attribute->hp--;
		if (attribute->hp <= 0) {
			area->removeObject(this);
			delete this;
			return;
		}
	} else if (mode == FIREMODE) {
		if (attribute->owner->getAttributePtr()->hp > 0) {
			area->removeObject(this);
			delete this;
			return;
		}
		if (attribute->owner != NULL)
		{
			dest[0] = attribute->owner->getLocationX();
			dest[2] = attribute->owner->getLocationZ();
			RoleFLOAT dx = dest[0]-location[0];
			RoleFLOAT dz = dest[2]-location[2];
		
			RoleFLOAT damount = sqrt(dx*dx+dz*dz);
			if (damount < 1) {
				damount = 0.7;
			}
			direction[0] = dx/damount;
			direction[2] = dz/damount;
			location[0] += direction[0] * 0.7;
			location[2] += direction[2] * 0.7;
			location[1] = area->getTerrain()->getHeight(location[0],location[2]) + attribute->owner->getHeight();
			
		}
	} else if (mode == STANDING) {
		attribute->counter_for_mp++;
		if (attribute->counter_for_mp >= COUNTER_PER_MP) {
			attribute->mp = min(attribute->mp + 1, MP_PER_LEVEL * attribute->level);
			attribute->counter_for_mp = 0;
		}
	}

}

RoleBOOL Object::gotHit(RoleINT damage) {
	//printChars(150, 50, "HIT!!!!!!!");

	if (type == Object::FIREBALL) {
		// fireball is destoryed
		//area->getObjectManager()->getCollisionTable()->removeObject(this);
		area->removeObject(this);
		delete this;
		return RoleFALSE;
	}

	if (type == Object::LIGHTNING) {
		return RoleFALSE;
	}

	if (type == Object::FIRE) {
		return RoleFALSE;
	}

	attribute->hp -= damage;
	if (attribute->hp <= 0) {
		attribute->hp = 0;
		mode = DEATH;
		if (type == Object::PLAYER) {
			mode = STANDING;
			if (attribute->canAttack == RoleTRUE) {
			attribute->canAttack = RoleFALSE;
	//		Object * new_ob = new ActionObject(area, NULL,
	//				location[0], 0, location[2], 0.5f, 1.0f, 0.5f,
	//				"fire",Object::FIRE);
	//		new_ob->getAttributePtr()->owner = this;
	//		new_ob->setMode(FIREMODE);
	//		new_ob->direction[0] = direction[0];
	//		new_ob->direction[1] = direction[1];
	//		new_ob->direction[2] = direction[2];
	//		area->getObjectManager()->getCollisionTable()->removeObject(new_ob);
			}
			return RoleFALSE;
		}
		area->getObjectManager()->getCollisionTable()->removeObject(this);
		return RoleTRUE;
	} else {
		mode = PAIN;
		return RoleFALSE;
	}
}

RoleBOOL Object::goFrontFireball(RoleFLOAT  amount) {
	RoleFLOAT nextLocX = location[0] + direction[0]*amount;
	RoleFLOAT nextLocY =  area->getTerrain()->getHeight(location[0],location[2]);
	RoleFLOAT nextLocZ = location[2] + direction[2]*amount;

	nextLocation[1]=0.0f;
	if (area->getObjectManager()->canGo(nextLocX,nextLocY,nextLocZ,
			size[0],size[1],size[2],this)) {
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		
		return RoleTRUE;
	} else {
		return RoleFALSE;
	}
}

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

RoleBOOL Object::goToObject(Object * targetOb, RoleFLOAT  amount)
{
	if (targetOb !=NULL)
	{
		target = targetOb;
		dest[3] = amount;
		mode = GOTOOBJECT;
		return RoleTRUE;
	}
	else
		return RoleFALSE;
}

RoleBOOL Object::getItemFromArea(Object * o)
{
	area->loseItemToObject(o,this);
	itemList.push_back(o);
	rolePrintlog("Object %s is getting %s from area\n",name.data(),o->getName().data());
	return RoleTRUE;
}

string Object::getName() const
{
	return name;
}

void Object::syncronizeLocDirFrame(Object * o)
{
	location[0] =o->getLocationX();
	location[1] =o->getLocationY();
	location[2] =o->getLocationZ();
	direction[0] = o->getDirectionX();
	direction[1] = o->getDirectionY();
	direction[2] = o->getDirectionZ();
	graphic->syncronizeFrame(o->getGraphicPtr());
}

RoleBOOL Object::loseItemToArea(Object * o)
{
	vector<Object *>::iterator itor = itemList.begin();
	int i = 0;
	for (i=0; i< itemList.size();i++)
	{
		if (itemList[i] == o)
		{
			itemList.erase(itor);
			// just precaution. Area will set up too.. redundancy.
			o->setLocationX(location[0]);
			o->setLocationY(location[1]);
			o->setLocationZ(location[2]);
			if (!area->getItemFromObject(o,this))
			{
				rolePrintlog("error while dropping an item\n");
				quit_role(1);
			}
			rolePrintlog("Object %s is losing %s to area\n",name.data(),o->getName().data());
			return RoleTRUE;
		}
		itor++;
	}
	return RoleFALSE;
}

Object * Object::getWeapon() const
{
	return weapon;
}

RoleINT Object::getType() const
{
	return type;
}

vector<Object *> * Object::getItemList()
{
	return &(itemList);
}

RoleBOOL Object::equipItem(RoleINT itemIndex, RoleINT where)
{
	if ((where > 1) || (where < 0) || (itemIndex < 0) ||
		(itemIndex > itemList.size()-1))
	{
		return RoleFALSE;
	}
	switch(where)
	{
	case 0:
		weapon = itemList[itemIndex];
		break;
	case 1:
		armor = itemList[itemIndex];
		break;
	default:
		return RoleFALSE;
		break;
	}
	return RoleTRUE;
}

RoleBOOL Object::getItem(Object * o)
{
	itemList.push_back(o);
	rolePrintlog("Object %s is getting %s from nowhere\n",name.data(),o->getName().data());
	return RoleTRUE;
}

RoleBOOL Object::loseItem(Object * o)
{
	vector<Object *>::iterator itor = itemList.begin();
	int i = 0;
	for (i=0; i< itemList.size();i++)
	{
		if (itemList[i] == o)
		{
			itemList.erase(itor);
			// just precaution. Area will set up too.. redundancy.
			rolePrintlog("Object %s is losing %s to nowhere\n",name.data(),o->getName().data());
			o->~Object();
			return RoleTRUE;
		}
		itor++;
	}
	return RoleFALSE;
}

void Object::wandering(RoleFLOAT  amount)
{
	RoleINT decision = rand()*10/(RAND_MAX+1);
	switch (decision)
	{
	case 1:
		goFront(amount/2);
		break;
	case 2:
		turnLeft(amount*60);
		break;
	case 3:
		turnRight(amount*60);
		break;
	case 4:
		turnLeft(amount*60);
		goFront(amount/2);
		break;
	case 5:
		turnRight(amount*60);
		goFront(amount/2);
		break;
	}
}

RoleBOOL Object::attack()
{
	mode = ATTACKING;
	// something has to be done.. here
	return RoleTRUE;
}

void Object::turnLeft(RoleFLOAT  amount)
{
	rotateCoord(LEFT,amount, 0.0,0.0,0.0,&(direction[0]),&(direction[1]),&(direction[2]));
	mode = RUNNING;
}

void Object::turnRight(RoleFLOAT  amount)
{
	rotateCoord(RIGHT,amount, 0.0,0.0,0.0,&(direction[0]),&(direction[1]),&(direction[2]));
	mode = RUNNING;
}
/*
void Object::smoothingMove(RoleINT step, RoleINT step, RoleFLOAT amount)
{

}
*/
RoleBOOL Object::goFront(RoleFLOAT  amount)
{
	RoleFLOAT nextLocX = location[0] + direction[0]*amount;
	RoleFLOAT nextLocY =  area->getTerrain()->getHeight(location[0],location[2]);
	RoleFLOAT nextLocZ = location[2] + direction[2]*amount;

	nextLocation[1]=0.0f;
	mode = RUNNING;
	if (area->getObjectManager()->canGo(nextLocX,nextLocY,nextLocZ,
			size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleTRUE;
	}
	else if(area->getObjectManager()->canGo(nextLocX,nextLocY,location[2],
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		return RoleXAXIS;
	}
	else if(area->getObjectManager()->canGo(location[0],nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleZAXIS;
	}
	return RoleFALSE;
}

RoleBOOL Object::goBack(RoleFLOAT  amount)
{
	RoleFLOAT nextLocX = location[0] - direction[0]*amount;
	RoleFLOAT nextLocY =  area->getTerrain()->getHeight(location[0],location[2]);
	RoleFLOAT nextLocZ = location[2] - direction[2]*amount;

	mode = RUNNING;

	nextLocation[1]=0.0f;
	if (area->getObjectManager()->canGo(nextLocX,nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		
		return RoleTRUE;
	}
	else if(area->getObjectManager()->canGo(nextLocX,nextLocY,location[2],
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		return RoleXAXIS;
	}
	else if(area->getObjectManager()->canGo(location[0],nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleZAXIS;
	}
	return RoleFALSE;
}

RoleBOOL Object::goRight(RoleFLOAT  amount)
{
	RoleFLOAT nextLocX = location[0] - direction[2]*amount;
	RoleFLOAT nextLocY =  area->getTerrain()->getHeight(location[0],location[2]);
	RoleFLOAT nextLocZ = location[2] + direction[0]*amount;

	mode = RUNNING;
	nextLocation[1]=0.0f;
	if (area->getObjectManager()->canGo(nextLocX,nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleTRUE;
	}
	else if(area->getObjectManager()->canGo(nextLocX,nextLocY,location[2],
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		return RoleXAXIS;
	}
	else if(area->getObjectManager()->canGo(location[0],nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleZAXIS;
	}
	return RoleFALSE;
}

RoleBOOL Object::goLeft(RoleFLOAT  amount)
{
	RoleFLOAT nextLocX = location[0] + direction[2]*amount;
	RoleFLOAT nextLocY =  area->getTerrain()->getHeight(location[0],location[2]);
	RoleFLOAT nextLocZ = location[2] - direction[0]*amount;

	mode = RUNNING;
	nextLocation[1]=0.0f;
	if (area->getObjectManager()->canGo(nextLocX,nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleTRUE;
	}
	else if(area->getObjectManager()->canGo(nextLocX,nextLocY,location[2],
		size[0],size[1],size[2],this))
	{
		location[0] = nextLocX;
		location[1] = nextLocY+nextLocation[1];
		return RoleXAXIS;
	}
	else if(area->getObjectManager()->canGo(location[0],nextLocY,nextLocZ,
		size[0],size[1],size[2],this))
	{
		location[1] = nextLocY+nextLocation[1];
		location[2] = nextLocZ;
		return RoleZAXIS;
	}
	return RoleFALSE;
}

RoleBOOL Object::goToXZ(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z,RoleFLOAT  amount)
{
	mode = GOTOXZ;
	dest[0] = x;
	dest[1] = y; // for later purpose
	dest[2] = z;
	dest[3] = amount;
#ifdef GOTODEBUG
	rolePrintlog("start to goto %f %f %f %f %f\n",x,y,z,location[0],location[2]);
#endif
	return RoleTRUE;
}

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

vector<Object *>* Object::getObjectsWithinRange(RoleFLOAT range, RoleFLOAT angle) {
	RoleFLOAT endLocation[3];
	vector<Object*>* tempList;
	vector<Object*>* objList = new vector<Object*>;
	Object* obj;
//	RoleFLOAT enemyDirection[3];
//	RoleFLOAT product;
//	RoleFLOAT angle;
//	RoleFLOAT length;
	RoleFLOAT to[3];
	RoleFLOAT from[3];
	
	endLocation[0] = location[0] + (range * direction[0]);
	endLocation[1] = location[1];
	endLocation[2] = location[2] + (range * direction[2]);
	
	from[0] = minFloat(location[0], endLocation[0]);
	from[0] /= Terrain::CELLSIZE;
	from[1] = minFloat(location[1], endLocation[1]);
	from[1] /= Terrain::CELLSIZE;
	from[2] = minFloat(location[2], endLocation[2]);
	from[2] /= Terrain::CELLSIZE;
	
	to[0] = maxFloat(location[0], endLocation[0]);
	to[0] /= Terrain::CELLSIZE;
	to[1] = maxFloat(location[1], endLocation[1]);
	to[1] /= Terrain::CELLSIZE;
	to[2] = maxFloat(location[2], endLocation[2]);
	to[2] /= Terrain::CELLSIZE;


	for (RoleINT x = (RoleINT)from[0]; x <= (RoleINT)to[0]; x+=1) {
		for (RoleINT z = (RoleINT)from[2]; z <= (RoleINT)to[2]; z+=1) {
			tempList = getArea()->getObjectManager()->getCollisionTable()->getCellObjlist(x,z);
			for (int i = 0; i < tempList->size(); i++) {
				obj = (*tempList)[i];
				if (this != obj && withinRange(obj, range, angle) == RoleTRUE) {
					objList->push_back(obj);
				}
			}
		}
	}
	return objList;
}

RoleBOOL Object::withinRange(Object* enemy, RoleFLOAT range, RoleFLOAT angle) {
	RoleFLOAT enemyDirection[3];
	RoleFLOAT product;
	RoleFLOAT dot_angle;
	RoleFLOAT length;
	
	enemyDirection[0] = enemy->location[0] - location[0];
	enemyDirection[1] = enemy->location[1] - location[1];
	enemyDirection[2] = enemy->location[2] - location[2];
	length = sqrt(enemyDirection[0] * enemyDirection[0] + 
				  enemyDirection[1] * enemyDirection[1] + 
				  enemyDirection[2] * enemyDirection[2]);
	enemyDirection[0] /= length;
	enemyDirection[1] /= length;
    enemyDirection[2] /= length;

	product	= dotProduct3f(direction, enemyDirection);
	//printf("attacking dot product %f\n", product);
	dot_angle = acos(product);
	//printf("attacking angle %f\n", angle);
	//cout << "X: " << x << " Z: " << z << endl;
	//cout << "Distance: " << length << endl;
	if ((dot_angle <= angle && dot_angle >= -angle) &&
		(length <= range) &&
		(enemy->mode != DEAD && enemy->mode != DEATH) &&
		((type == Object::MONSTER) || // && enemy->getType() == Object::PLAYER) || // Monster can only kill Players
		(type == Object::PLAYER) || // Player can kill anyone
		(type == Object::FIREBALL) || // Fireball can kill....
		(type == Object::LIGHTNING)  || // lightning kills everything but not used here
		(type == Object::FIRE)
		)) { 	
		return RoleTRUE;
	}
	return RoleFALSE;
}

Object* Object::getClosestObject(vector<Object *> * objectList) {
	Object* closestObject = NULL;
	int minDistance = 100000;
	Object* temp;
	int distance;

	for (int i = 0; i < objectList->size(); i++) {
		temp = (*objectList)[i];
		distance = 	sqrt(temp->getLocationX() * temp->getLocationX() + temp->getLocationZ() * temp->getLocationZ());
		if (temp != this && temp->getAttributePtr() != NULL && temp->getAttributePtr()->hp > 0 && distance < minDistance) {
			closestObject = temp;
			minDistance = distance;
		}
	}
	return closestObject;
}


// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

void Object::setLocationX(RoleFLOAT x){location[0] = x;} 
void Object::setLocationY(RoleFLOAT y){location[1] = y;} 
void Object::setLocationZ(RoleFLOAT z) {location[2] = z;}

void Object::setDirectionX(RoleFLOAT x){direction[0] = x;} 
void Object::setDirectionY(RoleFLOAT y){direction[1] = y;} 
void Object::setDirectionZ(RoleFLOAT z) {direction[2] = z;}

void Object::draw(RoleFLOAT x, RoleFLOAT y,RoleFLOAT z,
				  RoleFLOAT dx, RoleFLOAT dy, RoleFLOAT dz,Player * p)
{
	graphic->draw(x,y,z,dx,dy,dz,p);
}

void Object::draw(Player * p)
{
	graphic->draw(p);
}

void Object::pick_draw(Player * p, RoleUINT pickID)
{
	graphic->pick_draw(p,pickID);
}

RoleINT Object::getMode() {return mode;}
void Object::setMode(RoleINT next_mode)
{
	mode = next_mode;
}


long unsigned int Object::getId() const {return id;};
Attribute * Object::getAttributePtr() const { return attribute ;};
RoleFLOAT Object::getLocationX() const { return location[0];};
RoleFLOAT Object::getLocationY() const { return location[1];};
RoleFLOAT Object::getLocationZ() const { return location[2];};

RoleFLOAT Object::getDirectionX() const { return direction[0];};
RoleFLOAT Object::getDirectionY() const { return direction[1];};
RoleFLOAT Object::getDirectionZ() const { return direction[2];};

	// Maybe these functions are unnecessary.
RoleFLOAT Object::getHeight() const { return size[0];}
RoleFLOAT Object::getWidth() const { return size[1];}
RoleFLOAT Object::getLength() const { return size[2];}
RoleFLOAT Object::getDestX() const {return dest[0];}
RoleFLOAT Object::getDestY() const {return dest[1];}
RoleFLOAT Object::getDestZ() const {return dest[2];}


Graphic * Object::getGraphicPtr() const {return graphic;};
Area * Object::getArea() const {return area;}

	// drawing on the screen if the object is in the frustum.
	// Basically, it is just giving the 3d vertices & textures 
	// for the display function in Role.cpp


void Object::makeId()
{
	/* Must be changed later */
	id = nextId;
	nextId++;

}

