/*****************************************************************************
**
**  objManager.h
**	
**	  Object management class for Role Project.
**	
**  Major function : Mainly dealing with object management in an area.
**  Design Idea    : Efficient object management including 
**					 collision detection coordinates, 					
** 					 adding, removing object from area,(except items...!?)
**					 giving statistics about object or info to player.					
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef object_manager_header
#define object_manager_header

#include "object.h"
#include "types.h"
#include "actionObj.h"



class Player;
class Area;
class RoleCollisionTable;

class ObjectManager
{
public:
	
	/* default constructor.*/
	
	ObjectManager(Area * a);

	~ObjectManager();

	void draw_all(Player * p);
	RoleUINT pick_draw_all(Player * p);
	const char * getNameAt(RoleINT idx);
	Object * getObjectAt(RoleINT idx) const;
	void action();
	RoleBOOL addObject(Object * ob);
	RoleBOOL removeObject(Object * ob);
	RoleUINT getSizeOfObjList() const;
	RoleCollisionTable * getCollisionTable() const {return objTable;}


	RoleBOOL canGo(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z,
		RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz, Object * ob);
private:
	friend class Area;
	Area * area;
	RoleBOOL sortObject(RoleINT option);
	vector<Object *> objList; // any data structure... maybe vector?
	RoleCollisionTable * objTable;
	void load_object_from_file(string name); // name is the reference to the location in a file...
};

#endif
