/*****************************************************************************
**
**	objManager.cpp
**	
**	  Object management class for Role Project.
**	
**    see more in objManager.h				
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#include "objManager.h"
#include "object.h"
#include "util.h"
#include "area.h"
#include "player.h"


ObjectManager::ObjectManager(Area * a)
{
	if (a == NULL)
	{
		rolePrintlog("Fatal error while creating object manager");
		quit_role(1);
	}
	area = a;
	objTable = new RoleCollisionTable(area);
}

ObjectManager::~ObjectManager()
{
	delete objTable;
	int size = objList.size()-2;
	for (int i = 0; i < size;i++)
	{
//		printf("after obj %s deletion %i\n",objList[i]->getName().data(),i);
		delete objList[i];
	}
}


RoleBOOL ObjectManager::addObject(Object * ob )
{
	// Really simple... change it later
	if (objTable == NULL)
	{
		objTable = new RoleCollisionTable(area);
	}
	objList.push_back(ob);
	objTable->addObject(ob);
	return RoleTRUE;
}

RoleBOOL ObjectManager::canGo(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, 
						  RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz ,Object * ob)
{
	int i = 0;
	int j = 0;
	int k = 0;
	int counter  = 0;
//	checking area boundary
	if ((x-sx < 0.0f) || (z-sz < 0.0f) || (x+sx > (area->getSizeX()-1)*Terrain::CELLSIZE)
		|| (z+sz > (area->getSizeY()-1)*Terrain::CELLSIZE))
	{
			return RoleFALSE;
	}
	/* It's much better to use Collision Table  counter is at most 3~4 compared to some thousands 
	from list version. But this implementation violates encapsulation...*/

	RoleINT startx = (RoleINT) (x/Terrain::CELLSIZE)-1-(RoleINT) ob->getWidth()*2/Terrain::CELLSIZE;
	RoleINT startz = (RoleINT) (z/Terrain::CELLSIZE)-1-(RoleINT) ob->getLength()*2/Terrain::CELLSIZE;
	RoleINT endx = (RoleINT) (x/Terrain::CELLSIZE)+2+(RoleINT) ob->getWidth()*2/Terrain::CELLSIZE;
	RoleINT endz = (RoleINT) (z/Terrain::CELLSIZE)+2+(RoleINT) ob->getLength()*2/Terrain::CELLSIZE;
	vector<Object *> * v;
	if (startx < 0)
		startx = 0;
	if (startz < 0)
		startz = 0;
	if (endx >= area->getSizeX())
		endx = area->getSizeX()-1;
	if (endz >= area->getSizeY())
		endz = area->getSizeY()-1;

	for (j = startx; j < endx ; j++)
	{
		for(k= startz; k < endz; k++)
		{
			v = objTable->getCellObjlist(j,k);
			for (i = 0; i < v->size(); i++)
			{
				if ((*v)[i]->pcollide(x,y,z,sx,sy,sz,ob))
				{
//					rolePrintlog("collide  at %.1f %.1f\n",x,z);
					return RoleFALSE;
				}
				counter++;
			}
		}
	}
/*	List Version counter will be the number of object... huge...
	for (i = 0; i < objList.size();i++)
	{
		if (objList[i]->pcollide(x,y,z,sx,sy,sz,ob))
		{
			return RoleFALSE;
		}
		counter ++;
	}
	
	if (counter > 0)
	{
		rolePrintlog("collision check %i times\n",counter);
	}
*/
	objTable->moveObject(ob,x,y,z);
	return RoleTRUE;
}

RoleUINT ObjectManager::getSizeOfObjList() const
{
	return objList.size();
}


void ObjectManager::load_object_from_file(string name)
{
	Object * new_ob = NULL;
	int i = 0;
	rolePrintlog("creating ObjectManger for %s\n",name.data());
	RoleFLOAT xsize = (area->getSizeX()-1)*Terrain::CELLSIZE;
	RoleFLOAT ysize = (area->getSizeY()-1)*Terrain::CELLSIZE;
	// this is only for test... 

  // moving soldier?
		new_ob = new ActionObject(area,NULL, xsize/2.0f,0.0f,ysize/2.0f+10.0f,0.5f,1.0f,0.5f,"soldier",Object::MONSTER);
		new_ob = new ActionObject(area,NULL, xsize/2.0f+5.0f,0.0f,ysize/2.0f+10.0f,0.5f,1.0f,0.5f,"goblin",Object::MONSTER);
		new_ob = new Object(area,NULL, 80.0+1000,0.0f,0.0+1000,16.0,40.0,16.0,"building.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, 350.0+1000,0.0f,250.0+1000,16.0,40.0,32.0,"building.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, -250.0+1000,0.0f,-140.0+1000,16.0,40.0,32.0,"building.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, -290.0+1000,0.0f,250.0+1000,16.0,40.0,16.0,"building.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, -150.0+1000,0.0f,120.0+1000,16.0,40.0,16.0,"building.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, 330.0f+1000.0f,0.0f,400.0+1000.0f,16.0,40.0,16.0,"building2.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, 50.0+1000,0.0f,250.0+1000,16.0,40.0,32.0,"building2.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, 150.0+1000,0.0f,-140.0+1000,16.0,40.0,32.0,"building2.bmp",Object::HOUSE);
		new_ob = new Object(area,NULL, 290.0+1000,0.0,-250.0+1000,16.0,40.0,16.0,"building2.bmp",Object::HOUSE);
	
		//new_ob = new ActionObject(area, NULL, xsize/2.0f-5.0f, 0.0f, ysize/2.0+10.0f, 0.5f, 1.0f, 0.5f, "angel.bmp", Object::MONSTER);
		//new_ob = new ActionObject(area,NULL, 1300.0f,120.0f,1000.0f,10.0,20.0,20.0,"angel.bmp");
		for (i= 0; i < 1000; i++)
		{
			new_ob = new ActionObject(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),0.5,1.0,0.5,"soldier",Object::MONSTER);
		}
		for (i= 0; i < 1000; i++)
		{
			new_ob = new ActionObject(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),0.5,1.0,0.5,"goblin",Object::MONSTER);
		}
		for (i= 0; i < 500; i++)
		{
			new_ob = new ActionObject(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),0.5,1.0,0.5,"chicken",Object::NPC);
		}
		for (i= 0; i < 200; i++)
		{
//			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),8.0,20.0,8.0,"tree2.bmp",Object::TREES);
			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),5.0,12.0,5.0,"tree2.bmp",Object::TREES);
		}
		for (i= 0; i < 200; i++)
		{
//			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),8.0,20.0,8.0,"tree4.bmp",Object::TREES);
			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),5.0,12.0,5.0,"tree4.bmp",Object::TREES);
		}
		for (i= 0; i < 200; i++)
		{
//			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),4.0,3.0,4.0,"flower1.bmp",Object::TREES);
			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),2.0,1.5,2.0,"flower1.bmp",Object::TREES);
		}
		for (i= 0; i < 200; i++)
		{
//			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),3.0,3.0,3.0,"flower2.bmp",Object::TREES);
			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),1.5,1.5,1.5,"flower2.bmp",Object::TREES);
		}
		for (i= 0; i < 500; i++)
		{
//			new_ob = new Object(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),3.0,3.0,3.0,"dragon_green.bmp",Object::NPC);
			new_ob = new ActionObject(area,NULL, rand()*xsize/(RAND_MAX+1),0.0f,rand()*ysize/(RAND_MAX+1),1.5,1.5,1.5,"dragon_green.bmp",Object::MONSTER);
			Object * weapon = new Object(area,NULL,new_ob->getLocationX(),
								0.0f,
								new_ob->getLocationZ(),0.5,5.0,0.5,"dknight",Object::WEAPON);
			area->getObjectManager()->removeObject(weapon);
			new_ob->getItem(weapon);
			new_ob->equipItem(0,0);

		}

	/* Real one should load all the objects from a file */
}

void ObjectManager::draw_all(Player * p)
{
	for (int i = 0; i < objList.size();i++)
	{
		if (!p->culling(objList[i]))
		{
			objList[i]->draw(p);
		}
	}

}



RoleUINT ObjectManager::pick_draw_all(Player * p)
{
	RoleUINT i = 0;
	RoleUINT num = 0;
	for (i = 0; i < objList.size();i++)
	{
	
		if (!p->pick_culling(objList[i]))
		{
			objList[i]->pick_draw(p,i);
			num++;
		}
	}
#ifdef SELECTDEBUG
	rolePrintlog("Object checked num %i ",num);
#endif
	return i;
}

const char * ObjectManager::getNameAt(RoleINT idx)
{
	return objList[idx]->getName().data();
}

Object * ObjectManager::getObjectAt(RoleINT idx) const
{
	return objList[idx];
}

void ObjectManager::action()
{
	// Later it would be better to divide non moving object and moving object >> reduce
	// action time

	for (int i = 0; i < objList.size();i++)
	{
			objList[i]->action();
	}
}


RoleBOOL ObjectManager::removeObject(Object * ob )
{
	vector<Object *>::iterator itor = objList.begin();
	int i = 0;
	for (i=0; i< objList.size();i++)
	{
		if (objList[i] == ob)
		{
			objList.erase(itor);
			objTable->removeObject(ob);
			return RoleTRUE;
		}
		itor++;
	}
	return RoleFALSE;
}

