/*****************************************************************************
**
**  mouse.h (needs OpenGL lib)
**	
**	  Mouse class for Role Project.
**	
**	  This class is pretty much done.
**
**  Major function : converting 2D mouse coordinate to modelview 3D coordinate.
**  Big Idea       : using OpenGL glRenderMode(GL_SELECT);, get the depth
**					value for the nearest point to the mouse.
**					Then using projection and modelview matrix, conduct 
**					linear transformation of (2D coord + depth) -> 3D coord.
	// added features :  For GeForce series, I added Ray Casting method to get the
	//				correct mouse location.
**	Note: need to change processHits & processMouse to use this class in
**	other application. & also need util.h.
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef role_mouse_header
#define role_mouse_header


#include "types.h"

/*---------------------------------------------------------------------//

   Mouse class

  mouse handling. getting 3d coord, selected obj
  Heavily depend on the other classes. especially ObjectManager idx.


//---------------------------------------------------------------------*/

class Object;
class Player;

class RoleMouse
{
public:
	
	/* default constructor.*/
	
	RoleMouse(RoleINT resolution_width, RoleINT resolution_height,
		RoleINT viewportLeftX,	RoleINT viewportBottomY,
		RoleINT viewportWidth, RoleINT viewportHeight, Player * p);
	~RoleMouse();
	// note that processMouse draws another frame on the screen, so really slow down the program
	// => use it as little as possible. at most once at each frame.
	void processMouse();
	void processMouse(RoleINT screenX,RoleINT screenY);
	RoleFLOAT getMouse3dX();
	RoleFLOAT getMouse3dY();
	RoleFLOAT getMouse3dZ();
	Object * getSelectedObj();
	RoleINT getSelectedObjNum() const;
	RoleINT getScreenX() const;
	RoleINT getScreenY() const;

private:
	#define BUFSIZE 512
	#define PICKSIZE 5.0

	Player * player;
	RoleINT width,height;
	RoleINT screenX,screenY;
	RoleFLOAT mouseX,mouseY,mouseZ;
	RoleDOUBLE z1, z2;
	GLuint selectBuf[BUFSIZE];
	RoleINT viewport[4];
	RoleINT hits;
	RoleINT selectIdx;
	Object * selectedObj;
	RoleINT selectedObjNum;
	void processHits();
	RoleBOOL convertScreenTo3DCoord();

};

#endif
