/*****************************************************************************
**
**  mouse.cpp (needs OpenGL lib)
**	
**	  Mouse class for Role Project.
**	
**	  This class is pretty much done.
**
**  see more in mouse.h
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/


#include "mouse.h"
#include "graphic.h"
#include "player.h"
#include "area.h"
#include "sdl.h"
#include "util.h"
//#define  MOUSEDEBUG 3

/**********************************************************************************
	processHits : when there is hits, process with num hits, and buffer[]
	**reference: P540~541 OpenGL programming guide.
*/

RoleMouse::RoleMouse(RoleINT resolution_width, RoleINT resolution_height,
		RoleINT viewportLeftX,	RoleINT viewportBottomY,
		RoleINT viewportWidth, RoleINT viewportHeight, Player * p)
{
	player = p;
	width = resolution_width;
	height = resolution_height;
	screenX=screenY=0;
	mouseX=mouseY=mouseZ=0.0f;
	z1=z2=0.0;
	viewport[0] = viewportLeftX;
	viewport[1] = viewportBottomY;
	viewport[2] = viewportWidth;
	viewport[3] = viewportHeight;
	hits = 0;
	selectIdx = -1;
	selectedObj = NULL;
}

void RoleMouse::processHits()
{
	RoleUINT i,j;
	RoleUINT names, *ptr;
	RoleDOUBLE inZ1 = 2.0;
	RoleDOUBLE inZ2 = 2.0;
	z1 = 2.0;
	z2 = 2.0;
//	rolePrintlog("Hits = %d\n",hits);

	selectIdx = -1;
	if (hits > 0)
	{
		ptr = (RoleUINT *) selectBuf;
		for (i=0; i < hits;i++)
		{
			names = *ptr;
//			rolePrintlog("Number of names for hits = %d\n",hits);
			ptr++;
			inZ1=((RoleDOUBLE) *ptr)/0x7fffffff;
			ptr++;
			inZ2=((RoleDOUBLE) *ptr)/0x7fffffff;
			ptr++;
			for (j=0; j < names; j++) {
//				rolePrintlog("%d %s",*ptr,world->getObjectManager()->getNameAt(*ptr));
				if ((z1 > inZ1) && (j ==0))
				{
					selectIdx = *ptr;
					z1 = inZ1;
					z2 = inZ2;
				}
				ptr++;
			}
		}
		convertScreenTo3DCoord();
		if ((selectIdx < player->getArea()->getObjectManager()->getSizeOfObjList()) 
			&& (selectIdx >= 0))
		{
			selectedObj =player->getArea()->getObjectManager()->getObjectAt(selectIdx);
			selectedObjNum = selectIdx;
		}
		else 
		{
			selectedObj = NULL;
			selectedObjNum = -1;
		}
	}
	else
		selectIdx = -1;
}


void RoleMouse::processMouse()
{
	SDL_GetMouseState(&screenX, &screenY);
	processMouse(screenX,screenY);
}

/**********************************************************************************
	processMouse : when there is hits, process with num hits, and buffer[]
			This is picking drawing using depth buffer.
		**reference: P540~541 OpenGL programming guide.
*/

void RoleMouse::processMouse(RoleINT x,RoleINT y)
{
	screenX = x;
	screenY = y;
	glEnable(GL_DEPTH_TEST);
	glDepthMask(GL_TRUE);
	glDisable (GL_TEXTURE_2D);
	glViewport(viewport[0],viewport[1], viewport[2],viewport[3]);

	glSelectBuffer(BUFSIZE, selectBuf);
	(void) glRenderMode(GL_SELECT);

//	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glInitNames();
	glPushName(0);
// saving projection matrix. 
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();

	glLoadIdentity();
	gluPickMatrix((GLdouble) screenX,(GLdouble) (height-screenY), PICKSIZE*2, PICKSIZE*2, viewport);
	gluPerspective(40.0f, ((RoleFLOAT) (viewport[2]))/((RoleFLOAT) (viewport[3])), 0.1f, player->getVisibility());
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	player->cameraSet();
// Object Picking draw. Only for object.
	player->getArea()->pick_draw(player); // different drawing than world->draw. All objects will be box.
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	hits = glRenderMode(GL_RENDER);
#ifdef MOUSEDEBUG
	if (hits>0)
		rolePrintlog("hit at %i %i *********************\n",screenX,screenY);
#endif
	processHits();
	glFlush();
}

RoleFLOAT RoleMouse::getMouse3dX() { return mouseX;}
RoleFLOAT RoleMouse::getMouse3dY() { return mouseY;}
RoleFLOAT RoleMouse::getMouse3dZ() { return mouseZ;}
/***************************************************************************
convertScreenTo3DCoord: Linear transformation from (mousex, mousey, average(z-depth near,z-depth-far),1.0f)
to model coordinate, (x,y,z,1.0)

  (x,y,z,1.0) = (inverse(proj*model)*
				{ 
					(mousex in viewport)/viewport width-1.0,
					(mousex in viewport)/viewport width-1.0,
					average(z-near, z-far) in [0-2.0] scale - 1.0
					1.0
				})  /  the bottom row of obtained matrix.

*/

RoleBOOL RoleMouse::convertScreenTo3DCoord()
{
	RoleFLOAT modl[16];
	// the following is depending on the projection of gameplay. Normalize mouse coord with [-1.0,1.0] scale.
	// and also normalize z value [-1.0, 1.0]. incoming z value should be getting from pickObj
	RoleDOUBLE modelCoord[4] = {((RoleDOUBLE) (screenX-viewport[0]))/((RoleDOUBLE) viewport[2])*2.0-1.0 ,((RoleDOUBLE) (viewport[3]-screenY))/((RoleDOUBLE)viewport[3])*2.0-1.0 , (z1+z2)/2.0-1.0,1.0};

	if (selectIdx < 0)
		return RoleFALSE;

#ifdef SCHOOL_COMPUTER_SUCKS
// For those stupid computers that do not give correct depth value Z.  Especially Soda 330!!!.

	Terrain * t = player->getArea()->getTerrain();
	if (selectIdx >= SCHOOL_COMPUTER_SUCKS) {
		RoleINT tempX = (selectIdx - SCHOOL_COMPUTER_SUCKS)%512;
		RoleINT tempZ = (selectIdx - SCHOOL_COMPUTER_SUCKS)/512;
		RoleINT xsize = t->xsize;
		RoleFLOAT mouseVect[3] = {0};

		RoleFLOAT tempY4 = Terrain::CELLSIZE*(t->heightmap[ ((tempZ+1)*(xsize)+tempX+1)]);
	
		// the coordinate of the pointed terrain cell. (min(x), min(z))
		modelCoord[0] = tempX*Terrain::CELLSIZE;
		modelCoord[1] = Terrain::CELLSIZE*(t->heightmap[ ((tempZ)*(xsize)+tempX)]);
		modelCoord[2] = tempZ*Terrain::CELLSIZE;
		modelCoord[3] = 0.0;

		
		mouseVect[0] = player->getCameraCenterX()-player->getCameraX();
		mouseVect[1] = player->getCameraCenterY()-player->getCameraY();
		mouseVect[2] = player->getCameraCenterZ()-player->getCameraZ();
//
//		RoleDOUBLE mag = sqrt(mouseVect[0]*mouseVect[0]
//				+mouseVect[1]*mouseVect[1]+mouseVect[2]*mouseVect[2]);
//		mouseVect[0] /= mag; 
//		mouseVect[1] /= mag; 
//		mouseVect[2] /= mag; 
		RoleFLOAT axis[3];
		RoleFLOAT upaxis[3] = {0.0f,1.0f,0.0f};
		crossProduct3f(mouseVect,upaxis,axis);
//		printf("%f %f %f\n",axis[0],axis[1],axis[2]);
		rotateCoord(RIGHT,atan((screenX-400)*tan(20.0*PIE/180.0)/243)*180.0/PIE, 0.0 ,0.0, 0.0,
						&(mouseVect[0]),&(mouseVect[1]),&(mouseVect[2]));

		rotateCoordOnXZ(axis,-atan((screenY-265)*tan(20.0*PIE/180.0)/260)*180.0/PIE, 0.0 ,0.0, 0.0,
						&(mouseVect[0]),&(mouseVect[1]),&(mouseVect[2]));
		modl[ 0] = -mouseVect[0];
		modl[ 1] = -mouseVect[1];
		modl[ 2] = -mouseVect[2];
		modl[ 3] = 0.0;
		modl[ 4] = Terrain::CELLSIZE; //(tempX+1)*Terrain::CELLSIZE - tempX1;
		modl[ 5] = Terrain::CELLSIZE*(t->heightmap[ ((tempZ)*(xsize)+tempX+1)]) - modelCoord[1];
		modl[ 6] = 0.0f; //tempZ*Terrain::CELLSIZE - tempZ1;
		modl[ 7] = 0.0f;
		modl[ 8] = 0.0f; //tempX*Terrain::CELLSIZE - tempX1;
		modl[ 9] = Terrain::CELLSIZE*(t->heightmap[ ((tempZ+1)*(xsize)+tempX)]) - modelCoord[1];
		modl[10] = Terrain::CELLSIZE; //(tempZ+1)*Terrain::CELLSIZE - tempZ1;
		modl[11] = 0.0f;
		modl[12] = 0.0f;
		modl[13] = 0.0f;
		modl[14] = 0.0f;
		modl[15] = 1.0f;

		if (!inverse(modl))
			return RoleFALSE;

		modelCoord[0] = player->getCameraX() - modelCoord[0];
		modelCoord[1] = player->getCameraY() - modelCoord[1];
		modelCoord[2] = player->getCameraZ() - modelCoord[2];
		modelCoord[3] = 1.0;

		RoleDOUBLE paramT = modelCoord[0] * modl[0] + modelCoord[1] * modl[4] + modelCoord[2] * modl[ 8];// + modelCoord[3] * inv[12];

		mouseX = paramT*mouseVect[0]+ player->getCameraX();
		mouseY = paramT*mouseVect[1]+ player->getCameraY();
		mouseZ = paramT*mouseVect[2]+ player->getCameraZ();
//  Rough Direction.
//		mouseX = (RoleFLOAT) ((selectIdx - SCHOOL_COMPUTER_SUCKS)%512) * Terrain::CELLSIZE;
//		mouseY = 1.0f;
//		mouseZ = (RoleFLOAT) ((selectIdx - SCHOOL_COMPUTER_SUCKS)/512) * Terrain::CELLSIZE;
	}
	else if (selectedObj != NULL)
	{
		mouseX = selectedObj->getLocationX();
		mouseY = selectedObj->getLocationY();
		mouseZ = selectedObj->getLocationZ();
	}
#else

	RoleFLOAT proj[16];
	RoleFLOAT inv[16];
	RoleDOUBLE originalCoord[4];

/* Get the current MODELVIEW matrix from OpenGL    the following is what the proj matrix get 
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glViewport(50,100, (GLsizei) (700), (GLsizei) (500));
	gluPerspective(40.0f, ((RoleFLOAT) (700))/((RoleFLOAT) (500)), 0.1f, 500.0f);
*/

    glGetFloatv(GL_PROJECTION_MATRIX, proj);
/* the following is what the modl matrix get 

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	player->cameraSet();
*/
	glGetFloatv(GL_MODELVIEW_MATRIX, modl);
/* if you uncomment above code, uncomment this too 
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glViewport(50,100, (GLsizei) (700), (GLsizei) (500));
*/
    /* Combine the two matrices (multiply projection by modelview) */
	matrixMultiply4by4(proj,modl,inv);
	if (!inverse(inv))
		return RoleFALSE;

	originalCoord[0] = modelCoord[0] * inv[0] + modelCoord[1] * inv[4] + modelCoord[2] * inv[ 8] + modelCoord[3] * inv[12];
	originalCoord[1] = modelCoord[0] * inv[1] + modelCoord[1] * inv[5] + modelCoord[2] * inv[ 9] + modelCoord[3] * inv[13];
	originalCoord[2] = modelCoord[0] * inv[2] + modelCoord[1] * inv[6] + modelCoord[2] * inv[10] + modelCoord[3] * inv[14];
	originalCoord[3] = modelCoord[0] * inv[3] + modelCoord[1] * inv[7] + modelCoord[2] * inv[11] + modelCoord[3] * inv[15];

	mouseX = (RoleFLOAT) originalCoord[0]/originalCoord[3];
	mouseY = (RoleFLOAT) originalCoord[1]/originalCoord[3];
	mouseZ = (RoleFLOAT) originalCoord[2]/originalCoord[3];
#endif

#ifdef MOUSEDEBUG
	rolePrintlog("Proj******************************\n");
	rolePrintlog("%f,%f,%f,%f\n",proj[0],proj[4],proj[8],proj[12]);
	rolePrintlog("%f,%f,%f,%f\n",proj[1],proj[5],proj[9],proj[13]);
	rolePrintlog("%f,%f,%f,%f\n",proj[2],proj[6],proj[10],proj[14]);
	rolePrintlog("%f,%f,%f,%f\n",proj[3],proj[7],proj[11],proj[15]);

	rolePrintlog("Modl\n");
	rolePrintlog("%f,%f,%f,%f\n",modl[0],modl[4],modl[8],modl[12]);
	rolePrintlog("%f,%f,%f,%f\n",modl[1],modl[5],modl[9],modl[13]);
	rolePrintlog("%f,%f,%f,%f\n",modl[2],modl[6],modl[10],modl[14]);
	rolePrintlog("%f,%f,%f,%f\n",modl[3],modl[7],modl[11],modl[15]);
	if (selectedObj!=NULL)
	{
		rolePrintlog("%s ",selectedObj->getName().data());
	}

	rolePrintlog(" %i %i %f %f %f %g %g %i %i %i %i\n",screenX,screenY,mouseX,mouseY,mouseZ,z1,z2
		, viewport[0], viewport[1], viewport[2], viewport[3] );
#endif
	return RoleTRUE;
}

Object * RoleMouse::getSelectedObj()
{
	return selectedObj;
};

RoleINT RoleMouse::getSelectedObjNum() const
{
	return selectedObjNum;
}

RoleINT RoleMouse::getScreenX() const
{
	return screenX;
};
RoleINT RoleMouse::getScreenY() const
{
	return screenY;
};
