// (c)2001 by Andr Knecke
#ifndef __MD2_H__
#define __MD2_H__

#include <stdio.h>
#include <windows.h>
#include <math.h>

#define MAXMODELS		10		// Max. Number Of Models To Load

#define MAX_TRIANGLES	4096	// Max. Number Of Triangles Per Model
#define MAX_VERTS		2048	// Max. Number Of Vertices
#define MAX_FRAMES		512		// Max. Number Of Frames (Animations) Per Model
#define MAX_MD2SKINS	32		// Max. Number Of Skins Per Model
#define MAX_SKINNAME	64		// Length Of SkinNames


#define MD2_SOLDIER		0		// Soldier-Model
#define MD2_SHOTGUN		1		// Shotgun(in Hand)-Model




typedef struct		// Used in ReadModel()
	{
		short s;
		short t;
	} dstvert_t;

typedef struct		// Used in ReadModel()
	{
		int ident;
		int version;

		int skinwidth;
		int skinheight;
		int framesize;

		int num_skins;
		int num_xyz;
		int num_st;
		int num_tris;
		int num_glcmds;
		int num_frames;

		int ofs_skins;
		int ofs_st;
		int ofs_tris;
		int ofs_frames;
		int ofs_glcmds; 
		int ofs_end;

	} dmdl_t;


typedef struct		// Used in ReadModel()
	{
		short index_xyz[3];
		short index_st[3];
	} dtriangle_t;

	typedef struct	// Used in ReadModel()
	{
		byte v[3];
		byte lightnormalindex;
	} dtrivertx_t;

	typedef struct	// Used in ReadModel()
	{
		float scale[3];
		float translate[3];
		char name[16];
		dtrivertx_t verts[1];
	} daliasframe_t;


	typedef struct	// Used in ReadModel()
	{
		int a, b, c;
		int a_s, a_t,
			b_s, b_t,
			c_s, c_t;
	} make_index_list;

	typedef struct	// Used in ReadModel()
	{
		float x, y, z;
	} make_vertex_list;

	typedef struct	// Used in ReadModel()
	{
		make_vertex_list *vertex;
	} make_frame_list;

// ModelImage-Structure
typedef struct
{
	typedef struct
	{
		float v[3];
	}vec3_t;

	typedef struct
	{
			vec3_t          v;
			int		lightnormalindex;
	} trivert_t;

	typedef struct
	{
			vec3_t          mins, maxs;
			char            name[16];
			trivert_t       v[MAX_VERTS];
	} frame_t;


	make_index_list *m_index_list;
	make_frame_list *m_frame_list;

	long m_iFrames, m_iVertices, m_iTriangles;

	int frame;

	float lastframe;

} ModelImage;

// Allocate Memory for MAXMODELS Models
extern ModelImage models[MAXMODELS];

// Extern Function Declarations
extern int ReadModel(ModelImage *model, char []);
extern void DestroyModels(void);


#endif