// (c)2001 by Andr Knecke
#include <iostream.h>
#include <windows.h>
#include "md2.h"

// Allocate Memory for MAXMODELS Models
ModelImage models[MAXMODELS];


// This Function Destroys ALL Models in Memory
void DestroyModels (void)
{
	for (int loop = 0; loop < MAXMODELS; loop++) // Loop Through All Models		
	{
		if (models[loop].m_frame_list != NULL) // If There Are Frames 
		{
			for (int loop2 = 0; loop2 < models[loop].m_iFrames; loop2++) // Loop Through All Frames
				delete [] models[loop].m_frame_list[loop2].vertex; // Delete The Vertices

			delete [] models[loop].m_frame_list; // Delete Framelist
			models[loop].m_frame_list = NULL; // Clear
		}

		if (models[loop].m_index_list != NULL) // If There Are Triangles
		{
			delete [] models[loop].m_index_list; // Delete Them
			models[loop].m_index_list = NULL; // Clear
		}
	}
} // End DestroyModels()


// Load The Models
int ReadModel (ModelImage *model, char filename[]) 
{
	FILE		*modelfile = NULL;
	char		g_skins[MAX_MD2SKINS][64];
	dstvert_t	base_st[MAX_VERTS];
	byte		buffer[MAX_VERTS*4+128];
	dmdl_t		modelheader;

	dtriangle_t     tri;
	daliasframe_t	*out;

	int i, j;

	if ((modelfile = fopen (filename, "rb")) == NULL)
		return 0;

	fread (&modelheader, 1, sizeof(modelheader), modelfile); // Read In Header

//	modelheader.framesize = (int)&((daliasframe_t *)0)->verts[modelheader.num_xyz];

	////////////////////////////////////////////////////

	model->m_iFrames =		modelheader.num_frames;
//	printf("%i\n",modelheader.num_frames);
	model->m_iVertices =	modelheader.num_xyz;
	model->m_iTriangles =	modelheader.num_tris;

	model->m_index_list = new make_index_list [modelheader.num_tris];
	model->m_frame_list = new make_frame_list [modelheader.num_frames];

	for (i = 0; i < model->m_iFrames; i++)
		 model->m_frame_list[i].vertex = new make_vertex_list [modelheader.num_xyz];

	////////////////////////////////////////////////////
	fread (&g_skins, 1, modelheader.num_skins * MAX_SKINNAME, modelfile);
	
	fread (&base_st, 1, modelheader.num_st * sizeof(base_st[0]), modelfile);

	for (i = 0; i < modelheader.num_tris; i++) 
	{
		fread (&tri, 1, sizeof(dtriangle_t), modelfile);

		(model->m_index_list)[i].a = tri.index_xyz[2] ;
		(model->m_index_list)[i].b = tri.index_xyz[1] ;
		(model->m_index_list)[i].c = tri.index_xyz[0] ;

		(model->m_index_list)[i].a_s = base_st[tri.index_st[2]].s;
		(model->m_index_list)[i].a_t = base_st[tri.index_st[2]].t;
		(model->m_index_list)[i].b_s = base_st[tri.index_st[1]].s;
		(model->m_index_list)[i].b_t = base_st[tri.index_st[1]].t;
		(model->m_index_list)[i].c_s = base_st[tri.index_st[0]].s;
		(model->m_index_list)[i].c_t = base_st[tri.index_st[0]].t;
	}

	for (i = 0; i < modelheader.num_frames; i++) 
	{
		out = (daliasframe_t *)buffer;

		fread (&*out, 1, modelheader.framesize, modelfile);

		for (j = 0; j < modelheader.num_xyz; j++) 
		{
			(model->m_frame_list)[i].vertex[j].x = out->verts[j].v[0] * out->scale[0] + out->translate[0];
			(model->m_frame_list)[i].vertex[j].y = out->verts[j].v[1] * out->scale[1] + out->translate[1];
			(model->m_frame_list)[i].vertex[j].z = out->verts[j].v[2] * out->scale[2] + out->translate[2];
		}
	}

	fclose (modelfile);
	return 1;
}