/*****************************************************************************
**
**  md.h 
**	
**	  RoleModel class for Role Project.
**	
**	  This class for 3D models.
**
**  Major function : loading and drawing 3D models.
**  Design Idea    : Put everything about complex 3D models in here
**					 other than simple box or rectangles.
**
**					 It can load MD2 models with skin.(quake 2 model)
**
**	Note need to be changed a lot...
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef MODEL_HEADER
#define MODEL_HEADER


#include "types.h"

/*I am not sure if byte is the same as char...
#ifdef _WIN32
	#include <windows.h>
	#define MD2BYTE byte
#endif
*/
typedef struct	roleTexCoord_with_VertexIndex_t
{
	RoleFLOAT a_x, a_y,
			  b_x, b_y,
			  c_x, c_y;
	RoleINT a_idx, b_idx, c_idx;
} RoleTexCoord_with_VertexIndex; 

typedef struct roleModelVertexSet_t
{
	RoleFLOAT x, y, z;
} RoleModelVertexSet;

typedef struct roleFrameSet_t	
{
	RoleModelVertexSet * vertex;
} RoleFrameSet;

typedef struct modelUnit_t {
	char name[MAX_NAME];
	RoleFrameSet * frame_list;
	RoleTexCoord_with_VertexIndex * index_list;
	RoleFLOAT width;
	RoleFLOAT height;
	RoleINT num_vertices;
	RoleINT num_triangles;
	RoleINT num_frames;
	RoleINT modeTable[MAX_MODES][2]; 
} ModelUnit;

class RoleModel;

class RoleModel
{
public:

	RoleModel(string model_name, string skin_name);
	~RoleModel();
	void deleteModels();

	void syncronizeFrame(RoleModel * m);
	void drawModel(RoleFLOAT distance);
	void drawPickModel () ;
	void advanceFrame(RoleINT newmode);
	void setFrame(RoleINT f);
	void switchModel(string model_name, string skin_name,
		             RoleModel * pair);
	RoleINT getFrame() const;
	static ModelUnit * getModelUnit(string model_name
									,RoleFLOAT skin_width
									,RoleFLOAT skin_height);
	RoleINT getMode() const;
	RoleINT getCurrentFrame() const { return frame; }
	RoleINT getLastFrame(int mode) const;
	RoleINT getlastMode() const;// not using.. maybe later
	RoleINT adjustMode(RoleINT newmode,RoleINT option);

private:

	typedef struct header_t	
	{
		int ident;
		int version;

		int skinwidth;
		int skinheight;
		int framesize;

		int num_skins;
		int num_vertices;
		int num_st;
		int num_triangles;
		int num_glcmds;
		int num_frames;

		int ofs_skins;
		int ofs_st;
		int ofs_tris;
		int ofs_frames;
		int ofs_glcmds; 
		int ofs_end;

	} MD2Header;

	typedef struct MD2IndexSet_t
	{
		short model_xyz_idx[3];
		short tex_xy_idx[3];
	} MD2IndexSet;

	typedef struct DSTVertexSet_t
	{
		MD2BYTE v[3];
		MD2BYTE lightnormalindex;
	} MD2VertexSet;

	typedef struct MD2TexCoord_t	
	{
		short x;
		short y;
	} MD2TexCoord;

	typedef struct	md2FrameSet_t
	{
		float scale[3];
		float translate[3];
		char name[MAX_FRAME_NAME];
		MD2VertexSet verts[MAX_VERTS+22];
	} MD2FrameSet;


	static vector<ModelUnit *> modelDB;

	string name;
	static RoleFLOAT scale;
	RoleUINT texName;
	RoleINT frame;
	RoleINT mode;
	RoleINT lastMode;// not using.. maybe later
	ModelUnit * data;
// for each mode, store the index of start and end frame.
	RoleTexCoord_with_VertexIndex * index_list;
	RoleFrameSet * frame_list;
};

#endif