/*****************************************************************************
**
**  md.cpp 
**	
**	  RoleModel class for Role Project.
**	
**	  This class for 3D models and animations.
**
**	See more in md.h
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/
#include "md.h"
#include "Role.h"
#include "object.h"
#include "graphic.h"

// Allocate Memory for MAXMODELS Models

vector<ModelUnit *> RoleModel::modelDB;


// Could be dangerous.... separating model and skin.
// but saving a lot of memories.
RoleModel::RoleModel(string model_name, string skin_name)
{
	frame = 0;
	lastMode = 0;
	mode = 0;
	TexUnit * t = NULL;
	if ((skin_name.compare(0,9,"yohko.bmp")==0) ||
		(skin_name.compare(0,11,"yohko_w.bmp")==0))
	{
		t = Graphic::getTexture(skin_name,Graphic::MIPMAP);
		scale = 25.0f;
	}
	else
	{
		t = Graphic::getTexture(skin_name,Graphic::MIPMAP);
		scale = 35.0f;
	}
	texName = t->tName;
	data = getModelUnit(model_name,t->width, t->height);
	if (data == NULL)
	{
		rolePrintlog("Cannot load model %s\n",model_name.data());
		quit_role(0);
	}
}

RoleModel::~RoleModel (void)
{
	// Be careful not to erase frame_list. it is gonna handled 
	// by modelDB
}

RoleINT RoleModel::getMode() const { return mode; }
RoleINT RoleModel::getlastMode() const { return lastMode;}// not using.. maybe later
RoleINT RoleModel::getFrame() const { return frame; }
RoleFLOAT RoleModel::scale = 35.0f;

void RoleModel::switchModel(string model_name, string skin_name, RoleModel * party)
{

	TexUnit * t = NULL;
	// Converting Scale of Model from MD2 to RoleModel
	if (skin_name.compare(0,9,"yohko.bmp")==0)
	{
		t = Graphic::getTexture(skin_name,Graphic::NORMAL);
		scale = 20.0f;
	}
	else
	{
		t = Graphic::getTexture(skin_name,Graphic::MIPMAP);
		scale = 35.0f;
	}
	texName = t->tName;
	data = getModelUnit(model_name,t->width, t->height);
	if (data == NULL)
	{
		rolePrintlog("Cannot load model %s\n",model_name.data());
		quit_role(0);
	}

	if (party != NULL)
	{
		mode=party->getMode();
		frame=party->getFrame();
		lastMode=party->getlastMode();
	}
}




// Change this to adjust frame. Possibly setting up lookup table No use at all.
RoleINT RoleModel::adjustMode(RoleINT newmode,RoleINT option)
{
	/*
	if (option == 1)
	{
		if (newmode == STANDING)
			return 6;
		if (newmode == RUNNING)
			return 4;
		else
			return newmode;
	}
	else 
	*/
		return newmode;
}
void RoleModel::syncronizeFrame(RoleModel * m)
{
	frame=m->getFrame();
	mode=m->getMode();
}

void RoleModel::advanceFrame(RoleINT newmode)
{
	if (newmode != mode)
	{
		if ((newmode == Object::GOTOXZ) || (newmode == Object::GOTOOBJECT) || (newmode == Object::FIREBALLMODE) || (newmode == Object::LIGHTNINGMODE) || (newmode == Object::FIREMODE))
			newmode = Object::RUNNING; // from standing, change the mode instantly.
		if (mode == Object::STANDING)
			mode = newmode; // from standing, change the mode instantly.
// convert object mode to model mode
	}
	frame++;
	if (data->modeTable[mode][0] > frame)
		frame = data->modeTable[mode][0];
	else if (data->modeTable[mode][1] < frame)
		frame = data->modeTable[mode][0];
	if (newmode != mode)
	{
		mode = newmode; // buffering.
	}
}

RoleINT RoleModel::getLastFrame(int mode) const {
	return data->modeTable[mode][1] - 1;
}


void RoleModel::deleteModels()
{
	for (int i = 0 ; i < modelDB.size();i++)
	{
		free(modelDB[i]->frame_list);
		free(modelDB[i]->index_list);
		free(modelDB[i]);
	}
}

void RoleModel::setFrame(RoleINT f)
{
	frame = f;
}


ModelUnit * RoleModel::getModelUnit(string model_name
									,RoleFLOAT skin_width
									,RoleFLOAT skin_height)
{
	FILE		* md2file = NULL;
	MD2Header	modelheader;
	char		g_skins[MAX_MD2SKINS][64];
	MD2TexCoord	skinCoord[MAX_TRIANGLES];
	char		nameBuffer[MAX_FRAME_NAME] = {0};
	RoleINT		modeIndex=0;
	RoleINT		lastModeIndex=0;
	MD2FrameSet	buffer_frame;
	MD2IndexSet    idx;
	RoleINT num_vertices;
	RoleINT num_triangles;
	RoleINT num_frames;
	RoleTexCoord_with_VertexIndex * index_list;
	RoleFrameSet * frame_list;


	RoleINT i, j;

	for (i = 0 ; i < modelDB.size();i++)
	{
		if (model_name.compare(modelDB[i]->name) == 0)
		{
			if ((skin_width==modelDB[i]->width)
				&& (skin_height==modelDB[i]->height))
			{
				return modelDB[i];
			}
			else
			{
				rolePrintlog("The size of model does not match\n");
				quit_role(0);
			}
		}
	}

	ModelUnit * temp = (ModelUnit *) malloc (sizeof(ModelUnit));
	model_name.copy(temp->name,MAX_NAME);
	
	if ((md2file = fopen (model_name.data(), "rb")) == NULL)
		return RoleFALSE;

	fread (&modelheader, 1, sizeof(modelheader), md2file); // Read In Header

	////////////////////////////////////////////////////

	num_frames = modelheader.num_frames;
	num_vertices =	modelheader.num_vertices;
	num_triangles =	modelheader.num_triangles;

	index_list = new RoleTexCoord_with_VertexIndex[num_triangles];
	frame_list = new RoleFrameSet [num_frames];

	for (i = 0; i < num_frames; i++)
		 frame_list[i].vertex = new RoleModelVertexSet[num_vertices];

	////////////////////////////////////////////////////
	fread (&g_skins, 1, modelheader.num_skins * MAX_SKINNAME, md2file);
	
	fread (&skinCoord, 1, modelheader.num_st * sizeof(MD2TexCoord), md2file);
	for (i = 0; i < num_triangles; i++) 
	{
		fread (&idx, 1, sizeof(MD2IndexSet), md2file);

		index_list[i].a_idx = idx.model_xyz_idx[2] ;
		index_list[i].b_idx = idx.model_xyz_idx[1] ;
		index_list[i].c_idx = idx.model_xyz_idx[0] ;

		index_list[i].a_x = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[2]].x)/skin_width;
		index_list[i].a_y = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[2]].y)/skin_height;
		index_list[i].b_x = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[1]].x)/skin_width;
		index_list[i].b_y = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[1]].y)/skin_height;
		index_list[i].c_x = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[0]].x)/skin_width;
		index_list[i].c_y = (RoleFLOAT) (skinCoord[idx.tex_xy_idx[0]].y)/skin_height;
	}

	modeIndex = 0;
	lastModeIndex = 0;
	for (i = 0; i < num_frames; i++) 
	{
		fread (&buffer_frame, 1, modelheader.framesize, md2file);
		if (strncmp(buffer_frame.name,nameBuffer,3) != 0)
		{
			if ((strncmp(buffer_frame.name,"run",3) == 0) &&
				  (isalpha(buffer_frame.name[3])))
			{

			}
			else
			{
				lastModeIndex = modeIndex;
				if ((strncmp(buffer_frame.name,"run",3) == 0) ||
					(strncmp(buffer_frame.name,"Run",3) == 0) )
				{
					modeIndex = Object::RUNNING;
				}
				else if ((strncmp(buffer_frame.name,"sta",3) == 0) ||
					(strncmp(buffer_frame.name,"Sta",3) == 0) )
				{
					modeIndex = Object::STANDING;
				}
				else if ((strncmp(buffer_frame.name,"atta",3) == 0) ||
					(strncmp(buffer_frame.name,"Atta",3) == 0) )
				{
					modeIndex = Object::ATTACKING;
				}
				else if ((strncmp(buffer_frame.name,"pain",3) == 0) ||
					(strncmp(buffer_frame.name,"Pain",3) == 0) )
				{
					modeIndex = Object::PAIN;
				}
				else if ((strncmp(buffer_frame.name,"deat",3) == 0) ||
					(strncmp(buffer_frame.name,"Deat",3) == 0) )
				{
					modeIndex = Object::DEATH;
				}
				else if ((strncmp(buffer_frame.name,"poin",3) == 0) ||
					(strncmp(buffer_frame.name,"Poin",3) == 0) )
				{
					modeIndex = Object::CASTINGFIREBALL;
				}
				else
				{
					modeIndex = MAX_MODES-1;
				}
				temp->modeTable[modeIndex][0] = i; // new frame start
				strncpy(nameBuffer,buffer_frame.name,4);
				if (i!=0) 
				{
					temp->modeTable[lastModeIndex][1] = i - 1;
				}
				rolePrintlog("Model: %s  Name Of Mode %i : %s\n",model_name.data(),modeIndex,nameBuffer);
			}
		}
		for (j = 0; j < modelheader.num_vertices; j++) 
		{
			frame_list[i].vertex[j].z = (buffer_frame.verts[j].v[0] * buffer_frame.scale[0] + buffer_frame.translate[0])/scale;
			frame_list[i].vertex[j].x = (buffer_frame.verts[j].v[1] * buffer_frame.scale[1] + buffer_frame.translate[1])/scale;
			frame_list[i].vertex[j].y = (buffer_frame.verts[j].v[2] * buffer_frame.scale[2] + buffer_frame.translate[2])/scale;
		}
	}
	if (i > 0)  // if it is not the first frame set the end of frame for the previous mode
	{
		temp->modeTable[modeIndex][1] = num_frames-1;

		if ((modeIndex == Object::DEATH) && ((i-1-temp->modeTable[modeIndex][0]) > 20))
		{
			temp->modeTable[modeIndex][1] = temp->modeTable[modeIndex][0]+6;
		}
	}
//	rolePrintlog("Model: %s  Number of Mode: %i\n",model_name,modeIndex);
	temp->modeTable[Object::DEAD][0] = temp->modeTable[Object::DEATH][1];
	temp->modeTable[Object::DEAD][1] = temp->modeTable[Object::DEATH][1];
	temp->modeTable[Object::CASTINGLIGHTNING][1] = temp->modeTable[Object::CASTINGFIREBALL][1];
	temp->modeTable[Object::CASTINGLIGHTNING][0] = temp->modeTable[Object::CASTINGFIREBALL][0];

	fclose (md2file);
	temp->frame_list = frame_list;
	temp->index_list = index_list;
	temp->num_frames = num_frames;
	temp->num_triangles = num_triangles;
	temp->num_vertices = num_vertices;
	temp->width = skin_width;
	temp->height = skin_height;
	modelDB.push_back(temp);

	return temp;
}


void RoleModel::drawModel (RoleFLOAT distance) 
{
	glBindTexture(GL_TEXTURE_2D, texName);
	glBegin(GL_TRIANGLES);
	for (int i = 0; i < data->num_triangles; i++) {
			glTexCoord2f(data->index_list[i].a_x, data->index_list[i].a_y);
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].a_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].a_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].a_idx].z);
			glTexCoord2f(data->index_list[i].b_x, data->index_list[i].b_y);
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].b_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].b_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].b_idx].z);
			glTexCoord2f(data->index_list[i].c_x, data->index_list[i].c_y);
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].c_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].c_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].c_idx].z);
		polycounter++;
	}
	glEnd();
	return;
}

void RoleModel::drawPickModel () 
{
	
	glBegin(GL_TRIANGLES);
	for (int i = 0; i < data->num_triangles; i++) {
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].a_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].a_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].a_idx].z);
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].b_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].b_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].b_idx].z);
			glVertex3f (data->frame_list[frame].vertex[data->index_list[i].c_idx].x ,
						data->frame_list[frame].vertex[data->index_list[i].c_idx].y ,
						data->frame_list[frame].vertex[data->index_list[i].c_idx].z);
		polycounter++;
	}
	glEnd();
	return;
}
 