/*******************************************************************************/
/*********************************21/09/200*************************************/
/**********************Programmer: Dimitrios Christopoulos**********************/
/**********************for the oglchallenge contest*****************************/
/**********************COLLISION CRAZY******************************************/
/*******************************************************************************/

#include "image.h"
#include "util.h"

/*
 * getint and getshort arehelp functions to load the bitmap byte by byte on 
 * SPARC platform.
 * I've got them from xv bitmap load routinebecause the original bmp loader didn't work
 * I've tried to change as less code as possible.
 */

static unsigned int getint(FILE *fp)
{
  int c, c1, c2, c3;

  /* get 4 bytes*/
  c = getc(fp);  
  c1 = getc(fp);  
  c2 = getc(fp);  
  c3 = getc(fp);
  
  return ((unsigned int) c) +   
    (((unsigned int) c1) << 8) + 
    (((unsigned int) c2) << 16) +
    (((unsigned int) c3) << 24);
}

static unsigned int getshort(FILE *fp)
{
  int c, c1;
  
  /*get 2 bytes*/
  c = getc(fp);  
  c1 = getc(fp);
 
  return ((unsigned int) c) + (((unsigned int) c1) << 8);
 
}
    

/* quick and dirty bitmap loader...for 24 bit bitmaps with 1 plane only.  */
/* See http://www.dcs.ed.ac.uk/~mxr/gfx/2d/BMP.txt for more info.*/

int ImageLoad(const char *filename, Image *image) {
    FILE *file;
    unsigned long size;                 /* size of the image in bytes.*/
    unsigned long i;                    /* standard counter.*/
    unsigned short int planes;          /* number of planes in image (must be 1) */
    unsigned short int bpp;             /* number of bits per pixel (must be 24)*/
    GLubyte * dummy;                          /* temporary color storage for bgr-rgba conversion.*/

    /* make sure the file is there.*/
    if ((file = fopen(filename, "rb"))==NULL) {
      rolePrintlog("File Not Found : %s\n",filename);
      return 0;
    }
    
    /* seek through the bmp header, up to the width/height:*/
    fseek(file, 18, SEEK_CUR);

    /* No 100% errorchecking anymore!!!*/

    /* read the width*/
    image->sizeX = getint (file);
//    rolePrintlog("Width of %s: %lu\n", filename, image->sizeX);
    
    /* read the height */
    image->sizeY = getint (file);
//    rolePrintlog("Height of %s: %lu\n", filename, image->sizeY);
    
    /* calculate the size (assuming 24 bits or 4 bytes per pixel).*/
	// changed by Gil Yuh 2001
    size = image->sizeX * image->sizeY * 4;

    /* read the planes*/
    planes = getshort(file);
    if (planes != 1) {
	rolePrintlog("Planes from %s is not 1: %u\n", filename, planes);
	return 0;
    }

    /* read the bpp*/
    bpp = getshort(file);
    if (bpp != 24) {
	rolePrintlog("Bpp from %s is not 24: %u\n", filename, bpp);
	return 0;
    }
	
    /* seek past the rest of the bitmap header.*/
    fseek(file, 24, SEEK_CUR);

    /* read the data. */
    image->data = (GLubyte *) malloc(size);
	dummy = (GLubyte *) malloc(size*3/4);
    if (image->data == NULL) {
	rolePrintlog("Error allocating memory for color-corrected image data");
	return 0;	
    }

    if ((i = fread(dummy, size*3/4, 1, file)) != 1) {
	rolePrintlog("Error reading image data from %s.\n", filename);
	return 0;
    }

	for (i=0;i<size/4;i++) { /* reverse all of the colors. (bgr -> rgb)*/
	image->data[i*4] = dummy[i*3+2];
	image->data[i*4+1] = dummy[i*3+1];
	image->data[i*4+2] = dummy[i*3];

	// added by Gil Yuh 2001
		if ((dummy[i*3] == 10) && (dummy[i*3+1] == 10) && (dummy[i*3+2] == 10))
		{
			image->data[i*4+3] = (GLubyte) 0;
		}
		else
		{
			image->data[i*4+3] = (GLubyte) 0xFF;
		}
    }
    free(dummy);
    /* we're done.*/
    return 1;
}

RoleBOOL LoadTGA(char *filename, Image * image )			// Loads A TGA File Into Memory
{    
	GLubyte		TGAheader[12]={0,0,2,0,0,0,0,0,0,0,0,0};	// Uncompressed TGA Header
	GLubyte		TGAcompare[12];								// Used To Compare TGA Header
	GLubyte		header[6];									// First 6 Useful Bytes From The Header
	GLuint		bytesPerPixel;								// Holds Number Of Bytes Per Pixel Used In The TGA File
	GLuint		imageSize;									// Used To Store The Image Size When Setting Aside Ram
	GLuint		type=GL_RGBA;								// Set The Default GL Mode To RBGA (32 BPP)
	GLuint		bpp;								// Set The Default GL Mode To RBGA (32 BPP)
	GLuint     temp;

	FILE *file = fopen(filename, "rb");						// Open The TGA File

	if(	file==NULL ||										// Does File Even Exist?
		fread(TGAcompare,1,sizeof(TGAcompare),file)!=sizeof(TGAcompare) ||	// Are There 12 Bytes To Read?
//		memcmp(TGAheader,TGAcompare,sizeof(TGAheader))!=0				||	// Does The Header Match What We Want?
		fread(header,1,sizeof(header),file)!=sizeof(header))				// If So Read Next 6 Header Bytes
	{
		if (file == NULL)									// Did The File Even Exist? *Added Jim Strong*
			return RoleFALSE;									// Return False
		else
		{
			fclose(file);									// If Anything Failed, Close The File
			return RoleFALSE;									// Return False
		}
	}

	image->sizeX  = header[1] * 256 + header[0];			// Determine The TGA Width	(highbyte*256+lowbyte)
	image->sizeY = header[3] * 256 + header[2];			// Determine The TGA Height	(highbyte*256+lowbyte)
    
 	if(	image->sizeX	<=0	||								// Is The Width Less Than Or Equal To Zero
		image->sizeY	<=0	||								// Is The Height Less Than Or Equal To Zero
		(header[4]!=24 && header[4]!=32))					// Is The TGA 24 or 32 Bit?
	{
		fclose(file);										// If Anything Failed, Close The File
		return RoleFALSE;										// Return False
	}

	bpp	= header[4];							// Grab The TGA's Bits Per Pixel (24 or 32)
	bytesPerPixel	= bpp/8;						// Divide By 8 To Get The Bytes Per Pixel
	imageSize		= image->sizeX*image->sizeY*bytesPerPixel;	// Calculate The Memory Required For The TGA Data

    rolePrintlog("Width of %s: %lu ", filename, image->sizeX);
    rolePrintlog("Height of %s: %lu ", filename, image->sizeY);
    rolePrintlog("bpp of %s: %lu\n", filename, bpp);

	image->data=(GLubyte *)malloc(imageSize);		// Reserve Memory To Hold The TGA Data

	if(	image->data==NULL ||							// Does The Storage Memory Exist?
		fread(image->data, 1, imageSize, file)!=imageSize)	// Does The Image Size Match The Memory Reserved?
	{
		if(image->data!=NULL)						// Was Image Data Loaded
			free(image->data);						// If So, Release The Image Data

		fclose(file);										// Close The File
		return RoleFALSE;										// Return False
	}

	for(GLuint i=0; i<int(imageSize); i+=bytesPerPixel)		// Loop Through The Image Data
	{														// Swaps The 1st And 3rd Bytes ('R'ed and 'B'lue)
		temp=image->data[i];							// Temporarily Store The Value At Image Data 'i'
		image->data[i] = image->data[i + 2];	// Set The 1st Byte To The Value Of The 3rd Byte
		image->data[i + 2] = temp;					// Set The 3rd Byte To The Value In 'temp' (1st Byte Value)
	}
	fclose (file);											// Close The File
	return RoleTRUE;											// Texture Building Went Ok, Return True
}