#ifndef heap_header
#define heap_header
#include "../types.h"
#include <ctime>

// change HeapNode with RoamSplitTriangleNode
// or RoamMergeTriangleNode repectively.
// this heap.cpp & heap.h itself is just an example.

// I made another version that has array of data in the heap
// class, but it was slower than using array of pointers.
// So, this is simple and fast.. (And correct..) even if I don't have
// much error checking. Because I mimic the similar code from the class notes~ 
//:)
// 

class RoamMergeDiamondNode;
class RoamSplitTriangleNode;

class HeapNode {
public:
	int priority;
	int heap_index;
	int data;
};


class MinHeap {
	public:
		MinHeap(int);
		void insert(RoamMergeDiamondNode *);
		RoamMergeDiamondNode * deletemin();
		RoamMergeDiamondNode * MinHeap::top();
		void deleteAt(int k);
		void increasedPriorityAt(int k);
		void decreasedPriorityAt(int k);
		void changePriorityAt(int k);
		int isEmpty();
		int getMySize();
		vector<RoamMergeDiamondNode *> queue;
	private:
		void inline bubbleUp(int);
		void inline bubbleDown(int);
		void inline exchange(int,int);
		int capacity;
		int mySize;
};

class MaxHeap {
	public:
		MaxHeap(int);
		void insert(RoamSplitTriangleNode *);
		RoamSplitTriangleNode * top();
		RoamSplitTriangleNode * deletemax();
		void deleteAt(int k);
		void increasedPriorityAt(int k);
		void decreasedPriorityAt(int k);
		void changePriorityAt(int k);
		int isEmpty();
		int getMySize();
		vector<RoamSplitTriangleNode *> queue;
	private:
		void inline bubbleUp(int);
		void inline bubbleDown(int);
		void inline exchange(int,int);
		int capacity;
		int mySize;
};
#endif
