#include "heap.h"
#include "roam.h"


MinHeap::MinHeap(int cap)
{
	mySize = 0;
	capacity = cap;
	queue.resize(capacity);
	queue[0] = NULL;
}

RoamMergeDiamondNode * MinHeap::top()
{
	if (mySize > 0)
		return queue[0];
	else
		return NULL;
}

void MinHeap::deleteAt(int k)
{
	if (k > mySize)
	{
		printf("Critical error while deleting ROAM triangle\n");
	}
	else if (mySize == 1)
	{
		// this is necessary because bubbleDown will set heap_index = 0
		// for the deleting node;
		queue[k]->heap_index = -1;
		mySize = 0;
	}
	else if (k == (mySize-1))
	{
		queue[k]->heap_index = -1;
		mySize--;
	}
	else
	{
		queue[k]->heap_index = -1;
		queue[k]=queue[mySize-1];
		queue[k]->heap_index = k;
		mySize--;
		bubbleDown(k);
	}
}
int MinHeap::getMySize() { return mySize;}
void MinHeap::increasedPriorityAt(int k)
{
	bubbleDown(k);
}

void MinHeap::changePriorityAt(int k)
{
	if (k > 0)
	{
		if (queue[(k-1)/2]->priority > queue[k]->priority)
		{
			bubbleUp(k);
		}
		else
		{
			bubbleDown(k);
		}
	}
	else
	{
		bubbleDown(k);
	}
}

void MinHeap::decreasedPriorityAt(int k)
{
	bubbleUp(k);
}

void inline MinHeap::bubbleDown(int k)
{
	while (2*k+1 < mySize-1)
	{
		int minChildIndex =0;
		if (queue[2*k+1]->priority < queue[2*k+2]->priority)
		{
			minChildIndex = 2*k+1;
		}
		else
		{
			minChildIndex = 2*k+2;
		}
		if (queue[minChildIndex]->priority > queue[k]->priority)
		{
			return;
		}
		exchange(minChildIndex,k);
		k = minChildIndex;
	}
	if (2*k+1 == mySize-1) 
	{
		if (queue[mySize-1]->priority < queue[k]->priority)
		{
			exchange (mySize-1,k);
		}
	}
}

void inline MinHeap::bubbleUp(int k) 
{
	while ((k > 0) && (queue[k]->priority < queue[(k-1)/2]->priority))
	{
		exchange(k,(k-1)/2);
		k = (k-1)/2;
	}
}

void inline MinHeap::exchange(int k1,int k2)
{
	RoamMergeDiamondNode * temp = queue[k1];
	queue[k1] = queue[k2];
	queue[k2] = temp;
	queue[k1]->heap_index = k1;
	queue[k2]->heap_index = k2;
}

void MinHeap::insert(RoamMergeDiamondNode * v)
{
	if (v->heap_index == -1)
	{
		v->heap_index=mySize;
		queue[mySize] = v;
		mySize++;
		bubbleUp(mySize-1);
//		printf("insert %d %d %d top %d\n",v->heap_index,v->priority,
//			v->heap_index,queue[0]->priority);
	}
	else
	{
		bubbleUp(v->heap_index);
		printf("critical error\n");
		exit(1);
//		printf("change %d %d top %d\n",v->index,v->priority,queue[0]->priority);
	}
}

RoamMergeDiamondNode * MinHeap::deletemin()
{
	if (isEmpty())
	{
		return NULL;
	}
	RoamMergeDiamondNode * top = queue[0];
	if (mySize == 1)
	{
		mySize = 0;
	}
	else
	{
		queue[0] = queue[mySize-1];
		mySize--;
		bubbleDown(0);
	}
//	printf("delete %d %d size :%d\n",top->index,top->priority,mySize);
	top->heap_index = -1;
	return top;
}

int MinHeap::isEmpty()
{
	return mySize==0;
}

MaxHeap::MaxHeap(int cap)
{
	mySize = 0;
	capacity = cap;
	queue.resize(capacity);
	queue[0] = NULL;
}

void MaxHeap::changePriorityAt(int k)
{
	if (k > 0)
	{
		if (queue[(k-1)/2]->priority > queue[k]->priority)
		{
			bubbleDown(k);
		}
		else
		{
			bubbleUp(k);
		}
	}
	else
	{
		bubbleDown(k);
	}
}

RoamSplitTriangleNode * MaxHeap::top()
{
	if (mySize > 0)
		return queue[0];
	else
		return NULL;
}
int MaxHeap::getMySize() { return mySize;}
void MaxHeap::increasedPriorityAt(int k)
{
	bubbleUp(k);
}

void MaxHeap::decreasedPriorityAt(int k)
{
	bubbleDown(k);
}

void MaxHeap::deleteAt(int k)
{
	if (k > mySize)
	{
		printf("Critical error while deleting ROAM triangle\n");
	}
	else if (mySize == 1)
	{
		// this is necessary because bubbleDown will set heap_index = 0
		// for the deleting node;
		queue[k]->heap_index = -1;
		mySize = 0;
	}
	else if (k == (mySize-1))
	{
		queue[k]->heap_index = -1;
		mySize--;
	}
	else
	{
		queue[k]->heap_index = -1;
		queue[k]=queue[mySize-1];
		queue[k]->heap_index = k;
		mySize--;
		bubbleDown(k);
	}
}

void inline MaxHeap::bubbleDown(int k)
{
	while (2*k+1 < mySize-1)
	{
		int maxChildIndex =0;
		if (queue[2*k+1]->priority > queue[2*k+2]->priority)
		{
			maxChildIndex = 2*k+1;
		}
		else
		{
			maxChildIndex = 2*k+2;
		}
		if (queue[maxChildIndex]->priority < queue[k]->priority)
		{
			return;
		}
		exchange(maxChildIndex,k);
		k = maxChildIndex;
	}
	if (2*k+1 == mySize-1) 
	{
		if (queue[mySize-1]->priority > queue[k]->priority)
		{
			exchange (mySize-1,k);
		}
	}
}

void inline MaxHeap::bubbleUp(int k) 
{
	while ((k > 0) && (queue[k]->priority > queue[(k-1)/2]->priority))
	{
		exchange(k,(k-1)/2);
		k = (k-1)/2;
	}
}

void inline MaxHeap::exchange(int k1,int k2)
{
	RoamSplitTriangleNode * temp = queue[k1];
	queue[k1] = queue[k2];
	queue[k2] = temp;
	queue[k1]->heap_index = k1;
	queue[k2]->heap_index = k2;
}

void MaxHeap::insert(RoamSplitTriangleNode * v)
{
	if (v->heap_index == -1)
	{
		v->heap_index=mySize;
		queue[mySize] = v;
		mySize++;
		bubbleUp(mySize-1);
//		printf("****  Split insert %d %d %d top %d\n",v->heap_index,v->priority,
//			v->heap_index,queue[0]->priority);
	}
	else
	{
		bubbleUp(v->heap_index);
		printf("Huge Error\n");
		exit(1);
//		printf("change %d %d top %d\n",v->index,v->priority,queue[0]->priority);
	}
}

RoamSplitTriangleNode * MaxHeap::deletemax()
{
	if (isEmpty())
	{
		return NULL;
	}
	RoamSplitTriangleNode * top = queue[0];
	if (mySize == 1)
	{
		mySize = 0;
	}
	else
	{
		queue[0] = queue[mySize-1];
		mySize--;
		bubbleDown(0);
	}
//	printf("delete %d %d size :%d\n",top->index,top->priority,mySize);
	top->heap_index = -1;
	return top;
}

int MaxHeap::isEmpty()
{
	return mySize==0;
}

//driver . check out.
/*
int main (void)
{
	int SIZE = 6000;
	// correctness check

	clock_t start, end;
	vector<HeapNode> nodes;
	nodes.resize(SIZE);

	MinHeap * myHeap = new MinHeap(SIZE);

	int tempPriority = 0;
	start = clock();
	for(int n=0; n< 100; n++)
	{
//		printf("Starting  (adding)                     \n");
		for (int l =0; l < SIZE; l++)
		{
			nodes[l].priority = rand()%SIZE;
			nodes[l].heap_index = -1;
		}
		for (int j = 0; j < SIZE; j++)
		{
//			printf("%6i ",nodes[j].priority);
			myHeap->insert(&(nodes[j]));
		}
//		printf("\n Deleting\n");
		for (j = 0; j < SIZE; j++)
		{
			HeapNode * temp = myHeap->deletemin();
//			printf("%6i ",temp->priority);
			if ((tempPriority > temp->priority) && (j !=0))
			{
				printf("assertion failed with %i < %i",temp->priority,tempPriority);
			}
			tempPriority = temp->priority;
		}
//		printf("\n");
	}
	end = clock();

	printf("%i miliseconds\n", end - start);

	return 0;
}
*/