/*****************************************************************************
**
**  graphic.h (needs OpenGL lib)
**	
**	  Graphic class for Role Project.
**	
**	  This class is a major graphic part of the project.
**
**	Major function : Holds set of texture data, 
**					 frustum extraction, and font,
**			Also is responsible for drawing of individual object.
**			Created in each object class.
**  Design Idea    : Contains most graphic routines in this class
**					so that even if somebody does not know anything about 
**					3D graphics, he can just call the functions in here
**					In this sense, need to be changed a lot.
**
**   Refer to md.h to see 3D models used in RoleEngine program.
**
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#ifndef graphic_header
#define graphic_header


#include "types.h"
#include "md.h"
#include "cAdvParticle.h"

class Player;
class Object;

#define GL_TEXTURE0_ARB                     0x84C0
#define GL_TEXTURE1_ARB                     0x84C1

#ifdef _WIN32
    typedef void (APIENTRY * PFNGLMULTITEXCOORD2FARBPROC)(GLenum texture,GLfloat s,GLfloat t);
    typedef void (APIENTRY * PFNGLACTIVETEXTUREARBPROC)(GLenum texture);
#else
    typedef void (GLAPIENTRY * PFNGLMULTITEXCOORD2FARBPROC)(GLenum texture,GLfloat s,GLfloat t);
    typedef void (GLAPIENTRY * PFNGLACTIVETEXTUREARBPROC)(GLenum texture);
#endif

extern PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB_ptr;
extern PFNGLACTIVETEXTUREARBPROC glActiveTextureARB_ptr;
//void (* glMultiTexCoord2fARB_ptr)(GLenum texture,GLfloat s,GLfloat t);
//void (* glActiveTextureARB_ptr)(GLenum texture);

typedef struct font_t{
	char name[MAX_NAME];
	GLuint fontID;
} RoleFont;

typedef struct textureUnit {
	char name[MAX_NAME];
	RoleFLOAT width;
	RoleFLOAT height;
	GLuint tName;
} TexUnit;

extern void loadFont(void);

/* Object culling functions.
  Extract frustum coordinate and draw objects only in frustum 
 I have not decide where to put for the following functions 
*/
extern void inline extractFrustum(RoleFLOAT m_Frustum[6][4]);
extern RoleBOOL inline cubeInFrustum(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT size,RoleFLOAT m_Frustum[6][4]);
extern RoleBOOL inline areaInFrustum(RoleFLOAT x, RoleFLOAT z, RoleFLOAT size, RoleINT sizey, RoleFLOAT m_Frustum[6][4]);
extern void inline printChars(RoleINT x, RoleINT y, char * format,...);
extern void inline printChars3D(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, char * format,...);
extern void inline drawBox(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z,
					  RoleFLOAT width,RoleFLOAT height,RoleFLOAT length);
extern void inline drawPickBox(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z,
					  RoleFLOAT width,RoleFLOAT height,RoleFLOAT length);

class Graphic
{
public:
	
	/* default constructor.*/
	
	Graphic(string n,Object * o);
	// default destructor
	~Graphic();
	// special destructor
	static void deleteTextures();
	// public constants
	static const RoleINT MIPMAP;
	static const RoleINT NORMAL;
	// Add any necessary features..... I don't know...
    void draw(Player * player);
    void draw(RoleFLOAT x,RoleFLOAT y,RoleFLOAT z,
		RoleFLOAT dx, RoleFLOAT dy, RoleFLOAT dz,Player * player);
	void pick_draw(Player * player,RoleUINT pickID);

	// important tools
	static TexUnit * getTexture(string fileName, RoleINT option);
	// for animation
	void switchModel(string model_name, string skin_name);
	void advanceFrame(RoleINT mode);
	void syncronizeFrame(Graphic * g);
	void setNextUpdate(RoleUINT time);
	RoleUINT getNextUpdate() const;
	RoleModel * getModel() const;

private:

	// we have to set a limit for the amount of texture... for now unlimited.
	static vector<TexUnit *> tNameDB;
	static void loadTexture(RoleUINT & texName, string fileName
						, RoleFLOAT * width, RoleFLOAT * height
						, RoleINT option);	
	// owner of this graphic
	Object * ob;
	// default texture
	RoleUINT tName;
	// the name of this graphic
	string name;
	// 3d model address
	RoleModel * model;
	RoleUINT nextUpdate;
	cParticleManager * particle;

};

#endif
