// The template code for assignment 2 (Polygon Editor)
//

#include <stdio.h>
//#include <GL/glut.h>
//#include <GL/gl.h>
#include <glut.h>
#include "cParticle.h"
#include "rgb.h"

cExplosion Explosion(100);
cFire Fire(200, 0.5, -0.5);

void display(void)
{ 
	// Clear the background
	glClear(GL_COLOR_BUFFER_BIT);

    Explosion.Render();
	Fire.Render();

    glutSwapBuffers();
    glFlush();
}

void resize(int x,int y)
{
  glViewport(0,0,x,y);
  printf("Resized to %d %d\n",x,y);
}

void mouse(int button,int state,int x,int y)
{
  printf("Mouse click at %d %d, button: %d, state %d\n",x,y,button,state);
}

void motion(int x, int y)
{
}

void keyboard(unsigned char key, int x, int y)
{
	switch (key)
	{
		case 'r':
			Explosion.Reset(100);
			Fire.Reset(100);
			break;

	}
}

// Here's the main
int main(int argc, char* argv[])
{

  // Initialize GLUT
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
  glutCreateWindow("Fire");
  glutDisplayFunc(display);
  glutIdleFunc(display);
  glutReshapeFunc(resize);
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutKeyboardFunc(keyboard);
  
  // Initialize GL
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-1,1,-1,1,0,100);
//    glOrtho(-1,1,-0.2,1,0,100);
	glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  // Switch to main loop
  glutMainLoop();

  return 0;        
}
