#ifndef CUTILITY
#define CUTILITY

#include <vector>
#include <functional>
#include <string>
#include <cmath>
#include <iostream>

using namespace std;

#define PI 3.141592653589793

struct cVector3
{
    float x, y, z;

    cVector3(){x = y = z = 0.0;};
    cVector3(float _x, float _y, float _z){ x = _x; y = _y; z = _z;};

    void operator += (const cVector3& rhs)
    {
        x += rhs.x;
        y += rhs.y;
        z += rhs.z;
    };

	void operator *= (const float rhs)
	{
		x *= rhs;
		y *= rhs;
		z *= rhs;
	};

	cVector3 Norm(void);

	float Dist(void)
	{
		return sqrt(x*x + y*y + z*z);
	};

};

cVector3 operator+(const cVector3& lhs, const cVector3& rhs);	
cVector3 operator-(const cVector3& lhs, const cVector3& rhs);	
cVector3 operator*(const cVector3& lhs, const float rhs);
cVector3 operator/(const cVector3& lhs, const float rhs);

ostream& operator<<(ostream& out, const cVector3& rhs);

struct cVector4
{
    float x, y, z, w;

    cVector4(){x = y = z = 0.0;};
    cVector4(float _x, float _y, float _z, float _w){ x = _x; y = _y; z = _z; w = _w;};
};

typedef cVector3 cColor3;
typedef cVector4 cColor4;

struct cBoundBox : public pair<cVector3, cVector3>
{
    cBoundBox() : pair<cVector3, cVector3>(){;};
    cBoundBox(cVector3 _max, cVector3 _min){this->first = _max; this->second = _min;};

    cVector3 GetMax(){return this->first;};
    cVector3 GetMin(){return this->second;};
};

typedef string cTexture;
typedef int cBlendMode;

float Rand(float min, float max);
bool IsTrue(float prob);    //return true with "prob"

#endif