#include "cUtility.h"
#include <cstdlib>

float Rand(float min, float max)
{
    return (min + (max - min) * float(rand() % 30000) / float(30000.0));
//    float unitRand = float(rand() % 1000) / 1000.0;
//    return (max - min) * unitRand + min;
}

bool IsTrue(float prob)
{
    return (Rand(0.0, 1.0) < prob);
}


cVector3 operator+(const cVector3& lhs, const cVector3& rhs)
{
	return cVector3(
		lhs.x + rhs.x,
		lhs.y + rhs.y,
		lhs.z + rhs.z);
}
					
cVector3 operator-(const cVector3& lhs, const cVector3& rhs)
{
	return cVector3(
		lhs.x - rhs.x,
		lhs.y - rhs.y,
		lhs.z - rhs.z);
}

cVector3 operator*(const cVector3& lhs, const float rhs)
{
	return cVector3(
		lhs.x * rhs,
		lhs.y * rhs,
		lhs.z * rhs);
}

cVector3 operator/(const cVector3& lhs, const float rhs)
{
	if (rhs == 0)
	{
		cerr << "DIVISION BY ZERO" << endl;
	}

	return cVector3(
		lhs.x / rhs,
		lhs.y / rhs,
		lhs.z / rhs);
}

cVector3 cVector3::Norm(void)
{
	float dist = sqrt(x*x + y*y + z*z);
	if (dist == 0) return cVector3(0.0, 0.0, 0.0);
	return (*this) / dist;
};

ostream& operator<<(ostream& out, const cVector3& rhs)
{
	out << "(x, y, z) = " << "(" << rhs.x << ", " << rhs.y << ", " << rhs.z << ")";
	return out;
}

