#include "cAdvParticle.h"

//////////////////////////
// Particle

cParticle::cParticle(){;};

void cParticle::Render()
{
    if (!bAlive) return;

	cVector3 V1, V2, V3, V4;
    float curSize = size;
    //if (bEnergySize) = size * energy;

    if (bStretch)
    {
        V1.x = pos.x + curSize;
	    V1.y = pos.y + curSize;

	    V2.x = pos.x - velocity.x + curSize;
	    V2.y = pos.y - velocity.y - curSize;
	    V3.x = pos.x - velocity.x - curSize;
	    V3.y = pos.y - velocity.y - curSize;

	    V4.x = pos.x - curSize;
	    V4.y = pos.y + curSize;
    }
    else
    {
        V1.x = pos.x + curSize;
	    V1.y = pos.y + curSize;
	    V2.x = pos.x + curSize;
	    V2.y = pos.y - curSize;
	    V3.x = pos.x - curSize;
	    V3.y = pos.y - curSize;
	    V4.x = pos.x - curSize;
	    V4.y = pos.y + curSize;
    }

    glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glColor4f(color.x, color.y, color.z, energy);
    
	glBegin(GL_POLYGON);
    if (bSharp)
    {
		glTexCoord2f(1.0, 0.0); glVertex2f(V2.x, V2.y);
		glTexCoord2f(1.0, 1.0); glVertex2f(V3.x, V3.y);
		glTexCoord2f(0.0, 0.5); glVertex2f((V1.x + V4.x) / 2.0, (V1.y + V4.y) / 2.0);
    }
    else
    {
		glTexCoord2f(0.0, 0.0); glVertex2f(V1.x, V1.y);
		glTexCoord2f(1.0, 0.0); glVertex2f(V2.x, V2.y);
		glTexCoord2f(1.0, 1.0); glVertex2f(V3.x, V3.y);
		glTexCoord2f(0.0, 1.0); glVertex2f(V4.x, V4.y);
    }
	glEnd();
}


//////////////////////////
// Particle System

cParticleSystem::cParticleSystem(){;};

cParticleSystem::cParticleSystem(int num)
{
    //set some default setting
    blendMode = 0;
    texture = NULL;
    sysType = UNKNOWN;
    
    //create the particle
    nrAlive = num;
    bAlive = true;

    for(int i=0; i<num; i++)
        particles.push_back(cParticle());

    ///BOUNDING BOX SHOULD BE INIT HERE
}

