#include "cAdvParticle.h"
#include <iostream>

cParticleManager::cParticleManager()
{
    
}

cParticleManager::~cParticleManager() {

}

int cParticleManager::Add(int num, cSystemType sysType, cVector3 pos, cVector3 cam)
{
    //find an empty spot
    vector<cParticleSystem*>::iterator iter;
    for(iter = systems.begin(); iter != systems.end() && (*iter) != NULL; iter++);
    int loc = iter - systems.begin();

	//create the new system
	cParticleSystem* newSys;

    switch (sysType)
    {
    case FIRE:
    case SPARK:
    case EXPLOSION:
	case FIREBALL:
	case LIGHTNINGBALL:
        newSys = new cFire(num, sysType);
        break;
    case LIGHTNING:
        newSys = (new cLightning(num, sysType));
        break;
	case MOVINGFIRE:
		newSys = (new cMovingFire(num, sysType));
		break;
    default:
        cerr << "Trying to add unknown system type" << endl;
        return -1;
    }

    //if nothing is empty, insert at end
    if (iter == systems.end())
    {
        systems.push_back(newSys);
    }
    else
    {
		delete (*iter);
        *iter = newSys;
    }

	systems[loc]->pos = pos;
    systems[loc]->cam = cam;
    return loc;

}

void cParticleManager::Remove(int id)
{
    if (id < 0 || id >= systems.size())
    {
        cerr << "Invalid ID" << endl;
        return;
    }

    if (systems[id] != NULL)
    {
        delete systems[id];
        systems[id] = NULL;
    }
}

void cParticleManager::Reset(int id)
{
    if (id < 0 || id >= systems.size())
    {
        cerr << "Invalid ID" << endl;
        return;
    }

    if (systems[id] != NULL)
    {
        systems[id]->Init(systems[id]->numParticle, systems[id]->sysType);
    }
    else
    {
        cerr << "ATTEMP TO RESET NONE EXIST ID" << endl;
    }
} 
void cParticleManager::Render()
{
    for(int i=0; i<systems.size(); i++)
    {
        //if a system exists
        if (systems[i] != NULL)
        {
            //if a system still contain active particle
            if (systems[i]->bAlive)
            {
                glMatrixMode(GL_MODELVIEW);
                glPushMatrix();
                {
                    cVector3 pos = systems[i]->pos;
                    glTranslatef(pos.x, pos.y, pos.z);
                    systems[i]->Update();
                    systems[i]->Render();
                }
                glPopMatrix();
            }
            else
            {
                //if not alive, remove it
                //Remove(i);
                //don't remove it in case if tries to reset it
            }
        }
    }
}
           