#include "cAdvParticle.h"

//////////////////////////
// Fire Particle implemntation
cParticle cMovingFire::InitParticle()
{
    cParticle temp;

	//set basic property
    temp.bAlive = true;
    temp.bSharp = false;
    temp.bStretch = true;
    temp.color = info.color;
    temp.energy = Rand(info.minEnergy, info.maxEnergy);
    temp.size = info.size;

	//set up location and and moving properites
    float angle = Rand(-PI, PI);
    float dist = Rand(-info.radius, info.radius);

	temp.pos = info.center;
	temp.pos.x += dist * cos(angle);
	temp.pos.y += dist * sin(angle);

	temp.velocity = (info.tip - temp.pos) / float(info.stepParticle);
	//temp.acceleration = info.acc;
	temp.acceleration = info.gravity;

    return temp;
}

void cMovingFire::Init(int num, cSystemType type)
{

    //Set up systerm
    blendMode = 0; //need to be fix later
    sysType = type;
    numParticle = num;

    bAlive = true;

    if (type == MOVINGFIRE) info.InitMovingFire();
    else cerr << "INVALID TYPE FOR INIT" << endl;

	//update first
	info.UpdateMoving();

    nrAlive = num;

    //Set up properties of fire
    texture = info.tex;
    age = 0;

    //Set up particle;
    nrAlive = num;
    bAlive = true;

    particles.erase(particles.begin(), particles.end());
    for(int i=0; i<num; i++)
    {
        particles.push_back(InitParticle());
    }
}
cMovingFire::cMovingFire(int num, cSystemType type)
{
    Init(num, type);
}

void cMovingFire::Render()
{
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    {
//        glRotatef(info.direction , 0.0, 0.0, 1.0);
        for(int i=0; i<particles.size(); i++)
        {
            particles[i].Render();
        }
    }
    glPopMatrix();
}

void cMovingFire::Update()
{
    if (bAlive == false) return;
    
    //if exceed age, kill the fire, note that particle manager will do the deallocation
    if (age > info.fireAge)
    {
        bAlive = false;
        for(int i=0; i<particles.size(); i++) particles[i].bAlive = false;
        return;
    }
    
    //inc fire age
    age++;

	//update the moving fire
	info.UpdateMoving();

    for(int i=0; i<particles.size(); i++)
    {
        //update some physical properties of the particle
		//particles[i].velocity += particles[i].acceleration;
		particles[i].pos += particles[i].velocity;

        particles[i].energy *= info.reduceFactor;
        particles[i].energy -= info.reduceAmount;

        if (info.bRejuvenate)
        {
            if (particles[i].energy < info.minEnergy)
            {
                particles[i] = InitParticle();
            }
        }

        //if out of energy, mark the particle dead
        if (particles[i].energy < info.minEnergy)
        {
            particles[i].bAlive = false;
            nrAlive--;
            
            //if nothing is alive, mark the system dead
            if (nrAlive == 0) bAlive = false;
        }
    }
}