#include "cAdvParticle.h"

//////////////////////////
// Particle implemntation
/*
cParticle cLightning::InitParticle()
{
    cParticle temp;

    temp.bAlive = true;
    temp.bSharp = false;    //change for different effect
    temp.bStretch = true;
    temp.color = info.color;
    temp.energy = Rand(info.minEnergy, info.maxEnergy);
    temp.size = info.size;
//    temp.acceleration = info.acc;

    return temp;
}
*/
void cLightning::Init(int num, cSystemType type)
{
    //Set up systerm
    blendMode = 0; //need to be fix later
    sysType = type;
    numParticle = num;

    bAlive = true;

    if (type == LIGHTNING) info.InitLightning();
    else cerr << "INVALID TYPE FOR INIT" << endl;

    nrAlive = num;

    //Set up properties of Lightning
    texture = info.tex;
    age = 0;

    //Set up particle;
    nrAlive = num;
    bAlive = true;

    particles.erase(particles.begin(), particles.end());

    PreCalParticle(num, info.maxEnergy);
}

void cLightning::PreCalParticle(int num, float energy, float angle, cVector3 pos)
{
    //if no more particle, or out of energy
    if (num == 0) return;
    if (energy < info.minEnergy) return;

    //if lightning should be split here
    if (IsTrue(info.split))
    {
        float unitRand = Rand(0.0, 1.0);

        int num1 = int(float(num) * unitRand);
        int num2 = num - num1;

		energy -= info.minEnergy;

        energy *= info.splitEnergyBoost;
        float e1 = energy * unitRand;
        float e2 = energy - e1;

		e1 += info.minEnergy;
		e2 += info.minEnergy;

        PreCalParticle(num1, e1, angle, pos);
        PreCalParticle(num2, e2, angle, pos);
        return;
    }

    //create a particle
    cVector3 nextDiff;
    nextDiff.x = info.diff * cos(angle);
    nextDiff.y = info.diff * sin(angle);

    cParticle temp;
    temp.acceleration = cVector3(0.0, 0.0, 0.0);
    temp.bAlive = true;
    temp.bSharp = false;
    temp.bStretch = true;
    temp.color = info.color;
    temp.energy = energy;
    temp.size = info.size;

    temp.pos = pos;
    temp.pos += nextDiff;
    temp.velocity = nextDiff;

    particles.push_back(temp);

    //update num, energy
    num--;
    energy *= info.reduceFactor;
    energy -= info.reduceAmount;
    
    //update angle

    float newAngle = -1;
    do
    {
        if (IsTrue(info.tc1))
        {
            newAngle = angle + Rand(-info.ts1, info.ts1);
            continue;
        }

        if (IsTrue(info.tc2))
        {
            newAngle = angle + Rand(-info.ts2, info.ts2);
            continue;
        }

        if (IsTrue(info.tc3))
        {
            newAngle = angle + Rand(-info.ts3, info.ts3);
            continue;
        }
    }
    while (!(newAngle > info.minAngle && newAngle < info.maxAngle));
    
    PreCalParticle(num, energy, newAngle, temp.pos);
    
}

cLightning::cLightning(int num, cSystemType type)
{
    Init(num, type);
}

void cLightning::Render()
{
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    {
        glRotatef(info.direction , 0.0, 0.0, 1.0);
        for(int i=0; i<particles.size(); i++)
        {
			float minRenderEnergy = info.maxEnergy - (info.maxEnergy - info.minEnergy) * float(age)/float(info.lightningAge);

			if (particles[i].energy > minRenderEnergy)
			{
				particles[i].size = info.size * particles[i].energy;
				particles[i].Render();
			}
        }
    }
    glPopMatrix();
}

void cLightning::Update()
{
    if (bAlive == false) return;
    
    //if exceed age, kill the Lightning, note that particle manager will do the deallocation
    if (age > info.lightningAge)
    {
		/*
        bAlive = false;
        for(int i=0; i<particles.size(); i++) particles[i].bAlive = false;
		*/

		Init(particles.size(), sysType);

        return;
    }
    
    //inc Lightning age
    age++;

    for(int i=0; i<particles.size(); i++)
    {
        //update some physical properties of the particle
        ////INSERT HERE

        //if out of energy, mark the particle dead
        if (particles[i].energy < 0)
        {
            particles[i].bAlive = false;
            nrAlive--;
            
            //if nothing is alive, mark the system dead
            if (nrAlive == 0) bAlive = false;
        }
    }
}