#include "cAdvParticle.h"


//////////////////////////
// Fire Particle implemntation
cParticle cFire::InitParticle()
{
    cParticle temp;

    temp.bAlive = true;
    temp.bSharp = false;
    temp.bStretch = true;
//    temp.bEnergySize = true;
    temp.color = info.color;
    temp.energy = Rand(info.minEnergy, info.maxEnergy);
    temp.size = info.size;
    temp.acceleration = info.acc;

    if (sysType == FIRE)
    {
        temp.pos = cVector3(Rand(-info.width, info.width), 0 , 0);
        temp.velocity.y = Rand(-info.vel.y*info.botRatio, info.vel.y);
        temp.velocity.x = Rand(-info.vel.x, info.vel.x);
        temp.velocity.x -= temp.pos.x / info.step;
    }
    else if (sysType == SPARK)
    {
        temp.pos = cVector3(0.0, 0.0, 0.0);
        temp.velocity.y = Rand(-info.vel.y, info.vel.y);
        temp.velocity.x = Rand(-info.vel.x, info.vel.x);
        
        //if (fabs(temp.velocity.x) <= 0.001) cout << "Good";
    }
    else if (sysType == EXPLOSION || sysType == FIREBALL || sysType == LIGHTNINGBALL)
    {
        temp.pos = cVector3(0.0, 0.0, 0.0);
        float angle = Rand(-PI, PI);
        float speed = Rand(-info.radius, info.radius);

        temp.velocity.y = speed * sin(angle);
        temp.velocity.x = speed * cos(angle);
    }
    else cerr << "Invalid system type" << endl;

    return temp;
}

void cFire::Init(int num, cSystemType type)
{
    //Set up systerm
    blendMode = 0; //need to be fix later
    sysType = type;
    numParticle = num;

    bAlive = true;

    if (type == FIRE) info.InitFire();
    else if (type == SPARK) info.InitSpark();
    else if (type == EXPLOSION)
    {
        info.InitExplosion();
        num /= info.numRotate; //use rotation to save memory;
    }
	else if (type == FIREBALL)
	{
		info.InitFireBall();
		num /= info.numRotate;
	}
	else if (type == LIGHTNINGBALL)
	{
		info.InitLightningBall();
		num /= info.numRotate;
	}
    else cerr << "INVALID TYPE FOR INIT" << endl;

    nrAlive = num;

    //Set up properties of fire
    texture = info.tex;
    age = 0;

    //Set up particle;
    nrAlive = num;
    bAlive = true;

    particles.erase(particles.begin(), particles.end());
    for(int i=0; i<num; i++)
    {
        particles.push_back(InitParticle());
    }
}
cFire::cFire(int num, cSystemType type)
{
    Init(num, type);
}

void cFire::Render()
{
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    {
        glRotatef(info.direction , 0.0, 0.0, 1.0);
        //to save memory, rotate around "numRotate" times
        if (sysType == EXPLOSION || sysType == LIGHTNINGBALL)
        {
            for(float r=0; r<360.0; r += 360.0/info.numRotate)
            {
                glMatrixMode(GL_MODELVIEW);
                glPushMatrix();
                {
                    //glRotatef(r + Rand(-10.0, 10.0) , 0.0, 0.0, 1.0);
                    glRotatef(Rand(0, 360.0) , 0.0, 0.0, 1.0);
                    for(int i=0; i<particles.size(); i++)
                    {
                        //vary size with energy
                        //particles[i].size = info.size * particles[i].energy;

                        particles[i].Render();
                    }
                }
                glPopMatrix();
            }
        }
        else
        {
            for(int i=0; i<particles.size(); i++)
            {
				//vary color with energy
				//float energy = particles[i].energy;
				//cVector3 newColor = info.color * energy + info.color2 * (1.0 - energy);
				//particles[i].color = newColor;

                particles[i].Render();
            }
        }
    }
    glPopMatrix();
}

void cFire::Update()
{
    if (bAlive == false) return;
    
    //if exceed age, kill the fire, note that particle manager will do the deallocation
    if (age > info.fireAge)
    {
        bAlive = false;
        for(int i=0; i<particles.size(); i++) particles[i].bAlive = false;
        return;
    }
    
    //inc fire age
    age++;

    for(int i=0; i<particles.size(); i++)
    {
        //update some physical properties of the particle
        particles[i].velocity += info.acc;
        particles[i].pos += particles[i].velocity;
        
        particles[i].energy *= info.reduceFactor;
        particles[i].energy -= info.reduceAmount;

        if (info.bRejuvenate)
        {
            if (particles[i].energy < info.minEnergy)
            {
                particles[i] = InitParticle();
            }
        }

        //if out of energy, mark the particle dead
        if (particles[i].energy < info.minEnergy)
        {
            particles[i].bAlive = false;
            nrAlive--;
            
            //if nothing is alive, mark the system dead
            if (nrAlive == 0) bAlive = false;
        }
    }
}