/*****************************************************************************
**
**  building.h
**	
**	  building management
**	
**	  This class is one of the basic object unit for the project.
**
**	see more in building.h
**
**	
**	(c) 2001 by Byung Gil Yuh
**
***************************************************************************/

#include "types.h"
#include "object.h"
class Object;
class Player;
class Terrain;
class Area;

class BuildingCollisionTable
{
public:
	BuildingCollisionTable(RoleINT level);
	Building(Area * curr_area, Attribute * a, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT height, RoleFLOAT width,
		RoleFLOAT length, string name, RoleINT type__);
		~BuildingCollisionTable();
private:
	vector<RoleBYTE> simpleCollisionList;
};

class Building: public Object
{
public:
	Building(Area * curr_area, Attribute * a, RoleFLOAT x, RoleFLOAT y, RoleFLOAT z, RoleFLOAT height, RoleFLOAT width,
		RoleFLOAT length, string name, RoleINT _type);
	~Building();
	RoleBOOL pcollide(RoleFLOAT x, RoleFLOAT y, RoleFLOAT z,
					  RoleFLOAT sx, RoleFLOAT sy, RoleFLOAT sz,Object * ob);
private:
	RoleBOOL openDoor(Object * o); // check the permission.
	RoleBOOL closeDoor(Object * o);
	void loadBuildingFromFile(string filename);
	RoleINT level;
	vector<vector<RoleFLOAT> *> levelmap;
};

