
#include "object.h"
#include "actionObj.h"
#include "player.h"
#include "graphic.h"
#include "attribute.h"
#include "area.h"

Behavior::Behavior(Object * ob,RoleINT _type)
{
	o = ob;
	type = _type;
	count = 0;
	playerCount = 0;
}
Behavior::~Behavior()
{
}

void Behavior::action(int mode)
{
	if (type == ActionObject::PLAYER) {
		// no behavior for player
		playerCount++;
		if ((playerCount%2) == 0) {
			o->getGraphicPtr()->getModel()->advanceFrame(o->getMode());
		} else if (playerCount == 101) {
			playerCount = 1;
		}

	} else if (type == ActionObject::FIREBALL) {
		o->mode = Object::FIREBALLMODE;
	} else if (type == ActionObject::LIGHTNING) {
		o->mode = Object::LIGHTNINGMODE;
	} else if (type == ActionObject::FIRE) {
	//	o->setLocationX(o->getAttributePtr()->owner->getLocationX());
	//	o->setLocationY(o->getAttributePtr()->owner->getLocationY() + o->getAttributePtr()->owner->getHeight());
	//	o->setLocationZ(o->getAttributePtr()->owner->getLocationZ());
		o->mode = Object::FIREMODE;
//		if (o->getAttributePtr()->owner->getAttributePtr()->hp > 0) {
//			o->getArea()->removeObject(o);
//			delete o;
//			return;
//		}
//		o->goToObject(o->getAttributePtr()->owner, 0.5);
	} else {
		// NPC and Monster
		if ((mode == Object::PAIN) || (mode == Object::DEAD) || (mode == Object::DEATH) 
			|| (mode == Object::CASTINGFIREBALL) || (mode == Object::CASTINGLIGHTNING)) {
			o->mode = mode;
		} else {
			o->seekAndDestroy();
		}	
		o->getGraphicPtr()->getModel()->advanceFrame(o->getMode());
	}
}

RoleINT Behavior::getType() const
{
	return type;
}