#include "Role.h"

extern BackgroundMusic* bgmusic = NULL;

void bgCallback(void *userdata, Uint8 *stream, int len) {
	Uint32 amount;
	int i;

	for (i = 0; i < 2; i++) {
		if (i == 0 && ((Stuff*)userdata)[i].bgPos >= ((Stuff*)userdata)[i].bgLen) {
			((Stuff*)userdata)[i].bgPos = 0;
		}

		amount = ((Stuff*)userdata)[i].bgLen - ((Stuff*)userdata)[i].bgPos;
		if (amount > len) {
			amount = len;
		}

		SDL_MixAudio(stream, ((Stuff*)userdata)[i].bgCvt.buf + ((Stuff*)userdata)[i].bgPos, amount, ((Stuff*)userdata)[i].volume);
	
		((Stuff*)userdata)[i].bgPos += amount;
	}
}

BackgroundMusic::ReplayAudio(int audioIndex, int volume) {
	if (audioData[audioIndex].bgPos == audioData[audioIndex].bgLen) {
		audioData[audioIndex].bgPos = 0;
		cout << volume << endl;
		audioData[audioIndex].volume = volume;
	}
}

BackgroundMusic::BackgroundMusic() {
	SDL_AudioSpec desired;
	char* filenames[] = {"ghettotrain.wav", "itburns.wav"};
	int i;

	audioData = (Stuff*)malloc(sizeof(Stuff) * 2);

	// Set desired format
	desired.freq = 22050;
	desired.channels = 2;
	desired.format = 8;
	desired.samples = 4096;
	desired.callback = bgCallback;
	desired.userdata = (void*)audioData;

	// Open the audio device
	bgSpec = (SDL_AudioSpec*)malloc(sizeof(SDL_AudioSpec));
	if (SDL_OpenAudio(&desired, bgSpec) < 0 ){
		rolePrintlog("Error openning audio device: %s\n", SDL_GetError());
		quit_role(1);
	}

	//cout << "Freq:     " << bgSpec->freq << endl;
	//cout << "Format:   " << bgSpec->format << endl;
	//cout << "Channels: " << bgSpec->channels << endl;
	//cout << "Silence:  " << bgSpec->silence << endl;
	//cout << "Samples:  " << bgSpec->samples << endl;
	//cout << "Size:     " << bgSpec->size << endl;
	//cout << "Callback: " << bgSpec->callback << endl;
	//cout << "UserData: " << bgSpec->userdata << endl;

	// Load audio files
	for (i = 0; i < 2; i++) {
		if (SDL_LoadWAV(filenames[i], &desired, &(audioData[i].bgBuf), &(audioData[i].bgLen)) == NULL) {
			rolePrintlog("Error loading music file: %s\n", SDL_GetError());
			quit_role(1);
		} else {
			// Build AudioCVT
			if (SDL_BuildAudioCVT(&(audioData[i].bgCvt),
								desired.format, desired.channels, desired.freq,
								bgSpec->format, bgSpec->channels, bgSpec->freq) == -1) {
				SDL_CloseAudio();
				free(bgSpec);
				SDL_FreeWAV(audioData[i].bgBuf);
				rolePrintlog("Error loading music file: %s\n", SDL_GetError());
				quit_role(1);
			}

			// Setup for conversion
			audioData[i].bgCvt.len = audioData[i].bgLen;
			audioData[i].bgCvt.buf = (Uint8 *)malloc(audioData[i].bgLen * audioData[i].bgCvt.len_mult);
			memcpy(audioData[i].bgCvt.buf, audioData[i].bgBuf, audioData[i].bgLen);

			// We can delete to original WAV data now
			SDL_FreeWAV(audioData[i].bgBuf);
			audioData[i].bgBuf = NULL;

			// And now we're ready to convert
			if (SDL_ConvertAudio(&(audioData[i].bgCvt)) == -1) {
				SDL_CloseAudio();
				free(bgSpec);
				rolePrintlog("Error converting music file: %s\n", SDL_GetError());
				quit_role(1);
			}
		
			// Set the volume, length and position for the audio data
			cout << SDL_MIX_MAXVOLUME << endl;
			audioData[i].volume = SDL_MIX_MAXVOLUME;
			audioData[i].bgLen = audioData[i].bgCvt.len * audioData[i].bgCvt.len_ratio;
			if (i == 0)
				audioData[i].bgPos = 0;
			else
				audioData[i].bgPos = audioData[i].bgLen;
		}
	}

	SDL_PauseAudio(0);
}

BackgroundMusic::~BackgroundMusic() {
//	SDL_PauseAudio(1);
//	SDL_FreeWAV(bgBuf);
//	SDL_CloseAudio();
//	free(bgSpec);
}

