/*
  Byung Gil Yuh
  (c) 2001 

  area.h

	Area class. 
	contains two important classes: Terrain and objManager.

	Area exists without any player. In other words, player independent.
	Therefore, good for multiplayer version...

	Most of data for gameplay is to be loaded here...
	   except for the heightmap, and textures for terrain.


*/
#ifndef area_header
#define area_header

#include "types.h"
#include "terrain.h"
#include "object.h"
#include "objManager.h"


/*---------------------------------------------------------------------//

   Area class

	contains all the object and terrain information 
	Basically game is loading each area at a time.

//---------------------------------------------------------------------*/

class Area
{
public:
	
	/* default constructor.*/
	
	Area(string a_name);
	// copier
//	Area (const Area & source);
	~Area();
	// drawing is for each player. (For possible network config)
	void draw(Player * p);
	void pick_draw(Player * p);
	void action(void);
	ObjectManager * Area::getObjectManager() const;
	Terrain * getTerrain() const;
	string getName() const;
	RoleINT getSizeX();
	RoleINT getSizeY();
	RoleBOOL addObject(Object * ob);
	RoleBOOL removeObject(Object * ob);
	RoleBOOL getItemFromObject(Object * o,Object * from);
	RoleBOOL loseItemToObject(Object * o,Object * to);


private:

	// objects and terrain are stored for each area.
	void load_area_from_file(); // name is the reference to the location in a file...
	void reload_area();
	// area width & height (2D)

	string name;

	// terrain deals with terrain data, drawing, and etc.
	Terrain * terrain;

	// objlist deals with every object in this area. drawing, sorting, data and etc.
	ObjectManager * objlist;// later we need some kind of data base for object list.

	// this is itemlist. No need for collision detection,so can be located anywhere.
	// No behavior or anything. just needs pure attributes...
	// also if some object gets the item, it disappears from objManager.
	vector<Object *> itemList; 

};

#endif
