/*
  Byung Gil Yuh
  (c) 2001 

  area.cpp

  Area class. 
  see area.h for more information

*/
#include "area.h"
#include "player.h"
#include "graphic.h"

Area::Area(string a_name):name(a_name)
{
	terrain = NULL;
	objlist = NULL;
	terrain = new Terrain(name);
	objlist = new ObjectManager(this);
	load_area_from_file();
}

Area::~Area()
{
	Graphic::deleteTextures();
	delete terrain;
	printf("after terrain deletion\n");
	delete objlist;
	printf("after objlist deletion\n");
}
RoleINT Area::getSizeX() {return terrain->getSizeX();}
RoleINT Area::getSizeY() {return terrain->getSizeY();}

string Area::getName() const
{
	return name;
}

RoleBOOL Area::getItemFromObject(Object * o, Object * from)
{
	itemList.push_back(o);
	o->setLocationX(from->getLocationX());
	o->setLocationY(from->getLocationY());
	o->setLocationZ(from->getLocationZ());
	return RoleTRUE;
}

RoleBOOL Area::loseItemToObject(Object * o, Object * to)
{
	vector<Object *>::iterator itor = itemList.begin();
	int i = 0;
	for (i=0; i< itemList.size();i++)
	{
		if (itemList[i] == o)
		{
			o->setLocationX(1.0f);
			o->setLocationY(1.0f);
			o->setLocationZ(1.0f);
			itemList.erase(itor);
			return RoleTRUE;
		}
		itor++;
	}
	return RoleFALSE;
}

void Area::draw(Player * p)
{
		extractFrustum(p->m_Frustum);
//		terrain->frame_draw(p);
		terrain->draw(p);
		objlist->draw_all(p);
}

void Area::pick_draw(Player * p)
{
	extractFrustum(p->p_Frustum);
	RoleINT picked = objlist->pick_draw_all(p);
#ifdef SELECTDEBUG
	rolePrintlog("checking terrain with %i and ", picked);
#endif
	terrain->pick_draw(p,picked,objlist->getSizeOfObjList());
}


RoleBOOL Area::addObject(Object * ob)
{
	return objlist->addObject(ob);
}
RoleBOOL Area::removeObject(Object * ob)
{
	return objlist->removeObject(ob);
}

Terrain * Area::getTerrain() const
{
	return terrain;
}

ObjectManager * Area::getObjectManager() const
{
	return objlist;
}

void Area::action(void)
{
	objlist->action();
}

void Area::load_area_from_file()
{
	/*
	load all the information about the area
	- size, objects, and everything else...
	Not yet decide the format of file...
	*/
	// until making real function dummy objects...
	objlist->load_object_from_file("test");
}



