// (c)2001 by Andr Knecke

#ifndef __TGA_LOADER_H__
#define __TGA_LOADER_H__

#include <windows.h>		// Header File For Windows
#include <stdio.h>			// Header File For Standard Input/Output
#include <stdarg.h>								// Header File For Variable Argument Routines
#include <string.h>								// Header File For String Management
#include <gl\gl.h>			// Header File For The OpenGL32 Library
#include <gl\glu.h>			// Header File For The GLu32 Library
//#include <gl\glaux.h>		// Header File For The Glaux Library

typedef struct												// Create A Structure
{
	GLubyte	*imageData;										// Image Data (Up To 32 Bits)
	GLuint	bpp;											// Image Color Depth In Bits Per Pixel.
	GLuint	width;											// Image Width
	GLuint	height;											// Image Height
	GLuint	texID;											// Texture ID Used To Select A Texture
} TextureImage;												// Structure Name

#define NUMTGAS 24											// Number of TGA's to load

extern TextureImage textures[NUMTGAS];						// Storage For One Texture
extern bool LoadTGA(TextureImage *texture, char *filename);	// Loading Function	


//--------------------------------------
// TEXTURE-SHORTCUTS
//--------------------------------------
// Names For Engine-Equipment
#define ENG_CROSS		20
#define ENG_INFO		15
#define ENG_MINIMAP		16
#define ENG_MINIMAP_PLAYER 17
#define ENG_FONT		18


// Names For Model-Textures
#define MOD_SOLDIER1	0
#define MOD_SOLDIER2	20
#define MOD_SHADOW		21
#define MOD_SHOTGUN		22

// Names For Effects
#define FX_FIRE1		1
#define FX_FIRE2		2
#define FX_FIRE3		3
#define	FX_FIRE4		4
#define FX_FIRERING		5
#define FX_PARTICLE		23

// Names for the Textures
#define TEX_CEILING		6
#define TEX_FLOOR		7
#define TEX_WALL1		8
#define TEX_WALL2		9
#define TEX_WALL3		10
#define TEX_WALL4		11
#define TEX_WALL5		12	

#define TEX_DOOR1		13

#define TEX_SWITCH		14

//----------------------------------------

#endif