#include "image.h"
#include "types.h"
#include <stdio.h>
#include <stdlib.h>

RoleBOOL LoadTGA(char *filename, Image * image )			// Loads A TGA File Into Memory
{    
	GLubyte		TGAheader[12]={0,0,2,0,0,0,0,0,0,0,0,0};	// Uncompressed TGA Header
	GLubyte		TGAcompare[12];								// Used To Compare TGA Header
	GLubyte		header[6];									// First 6 Useful Bytes From The Header
	GLuint		bytesPerPixel;								// Holds Number Of Bytes Per Pixel Used In The TGA File
	GLuint		imageSize;									// Used To Store The Image Size When Setting Aside Ram
	GLuint		type=GL_RGBA;								// Set The Default GL Mode To RBGA (32 BPP)
	GLuint		bpp;								// Set The Default GL Mode To RBGA (32 BPP)
	GLubyte     * dummy;

	FILE *file = fopen(filename, "rb");						// Open The TGA File

	if(	file==NULL ||										// Does File Even Exist?
		fread(TGAcompare,1,sizeof(TGAcompare),file)!=sizeof(TGAcompare) ||	// Are There 12 Bytes To Read?
//		memcmp(TGAheader,TGAcompare,sizeof(TGAheader))!=0				||	// Does The Header Match What We Want?
		fread(header,1,sizeof(header),file)!=sizeof(header))				// If So Read Next 6 Header Bytes
	{
		if (file == NULL)									// Did The File Even Exist? *Added Jim Strong*
			return RoleFALSE;									// Return False
		else
		{
			fclose(file);									// If Anything Failed, Close The File
			return RoleFALSE;									// Return False
		}
	}

	image->sizeX  = header[1] * 256 + header[0];			// Determine The TGA Width	(highbyte*256+lowbyte)
	image->sizeY = header[3] * 256 + header[2];			// Determine The TGA Height	(highbyte*256+lowbyte)
    
 	if(	image->sizeX	<=0	||								// Is The Width Less Than Or Equal To Zero
		image->sizeY	<=0	||								// Is The Height Less Than Or Equal To Zero
		(header[4]!=24 && header[4]!=32))					// Is The TGA 24 or 32 Bit?
	{
		fclose(file);										// If Anything Failed, Close The File
		return RoleFALSE;										// Return False
	}

	bpp	= header[4];							// Grab The TGA's Bits Per Pixel (24 or 32)
	bytesPerPixel	= bpp/8;						// Divide By 8 To Get The Bytes Per Pixel
	imageSize		= image->sizeX*image->sizeY*bytesPerPixel;	// Calculate The Memory Required For The TGA Data

	dummy=(GLubyte *)malloc(imageSize);		// Reserve Memory To Hold The TGA Data

	if(	dummy==NULL ||							// Does The Storage Memory Exist?
		fread(dummy, 1, imageSize, file)!=imageSize)	// Does The Image Size Match The Memory Reserved?
	{
		if(dummy!=NULL)						// Was Image Data Loaded
			free(dummy);						// If So, Release The Image Data

		fclose(file);										// Close The File
		return RoleFALSE;										// Return False
	}

	int j = 0;
	for(GLuint i=0; i<int(imageSize); i+=bytesPerPixel)		// Loop Through The Image Data
	{														// Swaps The 1st And 3rd Bytes ('R'ed and 'B'lue)
		image->data[j] = dummy[i];							// Temporarily Store The Value At Image Data 'i'
		image->data[j + 1] =dummy[i+1];	// Set The 1st Byte To The Value Of The 3rd Byte
		image->data[j + 2] = dummy[i+2];					// Set The 3rd Byte To The Value In 'temp' (1st Byte Value)
		if (bytesPerPixel ==4)
		{
			image->data[j + 3] = dummy[i+3];
		}
		else
		{
			image->data[j + 3] = (GLubyte) 0xFF;
		}
		j+=4;
	}
	free(dummy);
	fclose (file);											// Close The File
	return RoleTRUE;											// Texture Building Went Ok, Return True
}