/* 

  Role playing game engine ( can be a simulation) 

*/
#ifndef role_header
#define role_header

// debug flag. all message will be in log.txt
// beware that some debug message will be huge
// because each drawing will produce message (about 30fps*...some thousands?)

//#define SELECTDEBUG 1
//#define COLLISIONDEBUG 2
//#define MODELDEBUG 3
//#define MOUSEPRESSDEBUG 4
//#define MOUSEDEBUG 4

// endof debug definition

// version and log information
#define VERSION 0.5
#define LOGFILE "log.txt" // you can set up your own log file.


#include "types.h"
#include "sdl.h"
#include "object.h"   // everything about object 
#include "terrain.h"  // drawing, data structure of pure terrain.
#include "player.h"	  // player log, current status, related objects.
#include "area.h"	  // include objects, terrain & loading script.
#include "util.h"	  // include objects, terrain & loading script.
#include "mouse.h"
#include "graphic.h"

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

#include "attribute.h"	// stuff about attributes
//#include "sdl_audio.h"	// necessary??
#include "audio.h"		// audio stuff

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

#define NOFOG -10
#define FOG 10


extern unsigned int polycounter;
extern RoleMouse * normal_mouse;

#endif

