/*

  Role.cpp

  Byung Gil Yuh
  (c) 2001

  3D Engine for Role Playing Game.

  This file is for the test purpose. 

  !!!important for the programmers!!!
  Always glMatrixMode(GL_PROJECTION); is assumed to be restored
  before display() function is called. So, whenever GL_PROJECTION matrix is changed, 
  save first, and restore before you exit the function. (Use push & popMatrix()).

*/

#include <stdlib.h>
#include "Role.h"
#include "roam.h"
// clean the following up later (after finishing at least behavior class)
// global variables.

// resolution
//#define XSIZE 512	
//#define YSIZE 384
//#define XSIZE 640	
//#define YSIZE 480
#define XSIZE 800	
#define YSIZE 600
// Menu mode
#define NORMAL 0
#define HELP 1
#define FILEMENU 2
#define CHANGEWEAPON 3
// log file name

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

#define HPBARX 450
#define HPBARY 50
#define MPBARX 450
#define MPBARY 30
#define EXPBARX 450
#define EXPBARY 70

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //



// global variables

RoleINT fogMode = FOG;
RoleINT menuMode = 0;
// for debugging purpose... if it is too slow speed up
Uint32 fps = 0;
Uint32 fpscounter = 0;
RoleINT polyMode = GL_FILL;
RoleBOOL roam_on = RoleFALSE;

RoleUINT polycounter = 0;
// unit step movement. one moving amount of player for each keyinput
RoleFLOAT speed = 0.7;
RoleFLOAT turnspeed = 4;
// resolution
RoleINT width = XSIZE;
RoleINT height = YSIZE;
// side walls, get some cool graphic.
RoleUINT wallPaper[2];
// logfile. debuggin tool.

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

//BackgroundMusic * bgmusic;

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

// Two important global variables. Only valid in Role.cpp.
Area * world;
Player * player;

RoleMouse * normal_mouse;
extern FILE * logfile;

void reshape(RoleINT w,RoleINT h,RoleFLOAT far_limit);


/* accume
#define PI_ 3.14159265358979323846
void accFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear
				, GLdouble zFar, GLdouble pixdx, GLdouble pixdy, GLdouble eyedx, GLdouble eyedy
				, GLdouble focus)
{
	GLdouble xwsize, ywsize;
	GLdouble dx, dy;
	GLint viewport[4];
	glGetIntegerv(GL_VIEWPORT, viewport);
	xwsize= right-left;
	ywsize = top - bottom;
	dx = -(pixdx*xwsize/(GLdouble) viewport[2] +
		eyedx*zNear/focus);
	dy = -(pixdy*ywsize /(GLdouble) viewport[3] +
		eyedy*zNear/focus);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(left+dx,right+dx,bottom +dy,top+dy,
		zNear, zFar);
//	glMatrixMode(GL_MODELVIEW);
//	glLoadIdentity();
//	glTranslatef(-eyedx,-eyedy,0.0);
}

void accPerspective(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar
					, GLdouble pixdx,GLdouble pixdy, GLdouble eyedx, GLdouble eyedy
					, GLdouble focus)
{
	GLdouble fov2, left, right, bottom, top;
	fov2 = ((fovy*PI_) / 180.0) /2.0;

	top = zNear/ (cos(fov2)/sin(fov2));
	bottom = -top;
	right = top*aspect;
	left = -right;
	accFrustum(left, right, bottom, top, zNear, zFar, pixdx, pixdy, eyedx, eyedy, focus);
}
*/

void intro(void)
{
	TexUnit * tx = Graphic::getTexture("intro.bmp",Graphic::MIPMAP);			// Side wall
	wallPaper[2] = tx->tName;
	glViewport(0,0, (GLsizei) width, (GLsizei) height);
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix
	glOrtho(0,width,0,height,-100,100);						// Set Up An Ortho Screen
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
// wall paper
	glEnable (GL_TEXTURE_2D);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glBindTexture(GL_TEXTURE_2D, wallPaper[2] );
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f); glVertex2f(0.0f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex2f(0.0f,height);
		glTexCoord2f(1.0f,1.0f); glVertex2f(width,height);
		glTexCoord2f(1.0f,0.0f); glVertex2f(width,0.0f);
	glEnd();
	SDL_GL_SwapBuffers();
	SDL_Event event;
	boolean start = false;
	while (!start) 
	{
		while (SDL_PollEvent(&event)) 
		{
			switch(event.type) 
			{
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym) {
				case SDLK_a:
					start = true;
					numplayer = 1;
					printf("start");
					break;
				case SDLK_b:
					start = true;
					printf("start");
					break;
	//			handle_key_down(&event.key.keysym);
				}
			break;
			}
		}
	}
}



// even before video initialization. setting up logfile.
void roleInit()
{
	printf("Starting Role Engine V %.2f\n",VERSION);
    if ((logfile = fopen(LOGFILE, "w"))==NULL) {
      fprintf(stderr, "Cannot Create file : %s\n",LOGFILE);
      exit(1);
    }
	rolePrintlog("Starting Role Engine V %.2f\n",VERSION);
	rolePrintlog(" Created by Role Engine automatically\n");
	rolePrintlog(" Any error message will show up here\n\n");
	rolePrintlog(" Enjoy the game.  Gil, Chris, Cedric, and Raymond 2001\n\n\n");
}

// OpenGL initialization.
void glinit (void)
{
	glShadeModel(GL_SMOOTH);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	intro();

    glActiveTextureARB_ptr = (PFNGLACTIVETEXTUREARBPROC)SDL_GL_GetProcAddress("glActiveTextureARB");
    glMultiTexCoord2fARB_ptr = (PFNGLMULTITEXCOORD2FARBPROC)SDL_GL_GetProcAddress("glMultiTexCoord2fARB");
	if ((glActiveTextureARB_ptr == NULL) || (glMultiTexCoord2fARB_ptr == NULL))
	{
		rolePrintlog("Must have multitexture enabled graphic card\n");
		multitexture = 0;
	}
	else 
	{
		multitexture = 1;
	}
//    glActiveTextureARB_ptr = SDL_GL_GetProcAddress("glActiveTextureARB");
//  glMultiTexCoord2fARB_ptr = SDL_GL_GetProcAddress("glMultiTexCoord2fARB");

	glShadeModel(GL_SMOOTH);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	TexUnit * tx = Graphic::getTexture("board.bmp",1);			// Side wall
	wallPaper[0] = tx->tName;
	tx = Graphic::getTexture("bottom.bmp",1);			// Side wall
	wallPaper[1] = tx->tName;
	world = new Area("test");
	player = new Player(world,numplayer);
	loadFont();
	normal_mouse = new RoleMouse(width,height,50,100,width-100,height-100,player);
}

// OpenGL reshape function. 
void reshape(RoleINT w, RoleINT h, RoleFLOAT far_limit)
{
	glViewport(50,100, (GLsizei) (w-100), (GLsizei) (h-100));
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(40.0f, (RoleFLOAT) (w-100)/(RoleFLOAT) (h-100), 0.1f, far_limit);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_DEPTH_TEST);
}


// OpenGL display function. - for normal mode.
void display(void)
{
/*
//	reshape(width,height,player->getVisibility());
	GLfloat light1_position[] = {1280.0,15.0,1380.0,1.0};
	GLfloat light0_position[] = {0.0,75.0,0.0,1.0};
	GLfloat light1_white[] = {1.0,1.0,1.0,1.0};
	GLfloat light1_diffuse[] = {1.0,1.0,1.0,1.0};
	GLfloat light1_ambient[] = {1.0,1.0,1.0,1.0};
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHT1);
	glLightf(GL_LIGHT1,GL_LINEAR_ATTENUATION,0.01);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,light1_white);
	glLightfv(GL_LIGHT1,GL_SPECULAR,light1_white);
	glLightfv(GL_LIGHT1,GL_AMBIENT,light1_white);
	RoleFLOAT fogColor[4] = {0.0f,0.0f,0.0f,1.0f};
	glClearColor(0.0f,0.0f,0.0f,1.0f);
*/
	RoleFLOAT fogColor[4] = {0.9f,1.0f,1.0f,1.0f};
	glClearColor(0.9f,1.0f,1.0f,1.0f);


	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
//	glClearColor(0.0f,0.0f,0.0f,1.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	if (fogMode!=NOFOG)
	{
		glEnable(GL_FOG);
		{
			fogMode = GL_LINEAR;
			glFogi(GL_FOG_MODE,fogMode);
			glFogfv(GL_FOG_COLOR,fogColor);
				glFogf(GL_FOG_DENSITY,0.5);
			glHint(GL_FOG_HINT, GL_DONT_CARE);
			if (player !=NULL)
			{
				glFogf(GL_FOG_START,player->getVisibility()*2/3);
				glFogf(GL_FOG_END,player->getVisibility());
			}
			else
			{
				glFogf(GL_FOG_START,1000*1/2);
				glFogf(GL_FOG_END,1000);
			}
		}
	}
	else
	{
		glDisable(GL_FOG);
	}

//	light that follows camera.
//	glLightfv(GL_LIGHT0,GL_POSITION,light0_position);
	
// camera set is gluLookAt(camera_position[0], camera_position[1], camera_position[2],
//	             camera_center[0], camera_center[1], camera_center[2],camera_up[0], camera_up[1], camera_up[2],);
	player->cameraSet();

// position light.
//	glLightfv(GL_LIGHT1,GL_POSITION,light1_position);
// display all objects in the frustrum. check out object culling in graphic.cpp
	glEnable (GL_TEXTURE_2D);
	glEnable( GL_CULL_FACE );			// enable back face culling 
	glPolygonMode(GL_FRONT,polyMode);
	world->draw(player);
//#ifdef MOUSEDEBUG
//	drawPickBox(
//			normal_mouse->getMouse3dX(),normal_mouse->getMouse3dY(),normal_mouse->getMouse3dZ(),
//			0.25,0.5,0.25);
//#endif
	if ((player->getControlObj()->getMode() == Object::GOTOXZ)
		|| (player->getControlObj()->getMode() == Object::GOTOOBJECT))
	{
		glDisable (GL_TEXTURE_2D);
		glColor3f(1.0f,0.0f,0.0f);
		drawPickBox(
				player->getControlObj()->getDestX(),
				world->getTerrain()->getHeight(
					player->getControlObj()->getDestX(),
					player->getControlObj()->getDestZ()),
				player->getControlObj()->getDestZ(),
				0.25,1.0,0.25);	
		glColor3f(1.0f,1.0f,1.0f);
		glEnable (GL_TEXTURE_2D);
	}
	glDisable( GL_CULL_FACE );			// enable back Face culling 
	glDepthMask(GL_TRUE);
	fpscounter++;
	glViewport(0,0, (GLsizei) width, (GLsizei) height);
	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GREATER,0.0);
	glEnable (GL_TEXTURE_2D);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDisable(GL_DEPTH_TEST);							// Disables Depth Testing


	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPushMatrix();
	glLoadIdentity();									// Reset The Projection Matrix
	glOrtho(0,width,0,height,-100,100);						// Set Up An Ortho Screen
	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
// wall paper

	glBindTexture(GL_TEXTURE_2D, wallPaper[0] );
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f); glVertex2f(0.0f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex2f(0.0f,height);
		glTexCoord2f(1.0f,1.0f); glVertex2f(50.f,height);
		glTexCoord2f(1.0f,0.0f); glVertex2f(50.f,0.0f);

		glTexCoord2f(0.0f,0.0f); glVertex2f(width-50.0f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex2f(width-50.0f,height);
		glTexCoord2f(1.0f,1.0f); glVertex2f(width,height);
		glTexCoord2f(1.0f,0.0f); glVertex2f(width,0.0f);
	glEnd();
	glBindTexture(GL_TEXTURE_2D, wallPaper[1] );
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f,0.0f); glVertex2f(50.0f,0.0f);
		glTexCoord2f(0.0f,1.0f); glVertex2f(50.0f,100.0f);
		glTexCoord2f(1.0f,1.0f); glVertex2f(width-50.0f,100.0f);
		glTexCoord2f(1.0f,0.0f); glVertex2f(width-50.0f,0.0f);
	glEnd();
/*	
	glDisable(GL_TEXTURE_2D);
	glColor3f(0,0,0);
	glBegin(GL_QUADS);
		glVertex2f(0.0f,0.0f);
		glVertex2f(0.0f,height);
		glVertex2f(50.f,height);
		glVertex2f(50.f,0.0f);

		glVertex2f(width-50.0f,0.0f);
		glVertex2f(width-50.0f,height);
		glVertex2f(width,height);
		glVertex2f(width,0.0f);
	glEnd();
	glBegin(GL_QUADS);
		glVertex2f(50.0f,0.0f);
		glVertex2f(50.0f,100.0f);
		glVertex2f(width-50.0f,100.0f);
		glVertex2f(width-50.0f,0.0f);
	glEnd();
*/
	if (roam_on) 
	{
		world->getTerrain()->getRoam()->draw_triangles();
	}
	glEnable(GL_TEXTURE_2D);
	glColor3f(1,1,1);
// Necessary Text Info
	printChars (60,70,"Help : F1");
	printChars (60,90,"x:%.1f  y:%.1f z:%.1f",
			normal_mouse->getMouse3dX(),normal_mouse->getMouse3dY(),normal_mouse->getMouse3dZ());
	if (normal_mouse->getSelectedObj() !=NULL)
	{

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //
		
		printChars (200,70,"%s selected hp(%i/%i)",
			normal_mouse->getSelectedObj()->getName().data(),
			normal_mouse->getSelectedObj()->getAttributePtr()->hp,
			normal_mouse->getSelectedObj()->getAttributePtr()->level * HP_PER_LEVEL);

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	}
	else
		printChars (200,70,"terrain selected");

	printChars (60,10,"%i fps  #objects: %i far view: %.1f",fps,world->getObjectManager()->getSizeOfObjList(),player->getVisibility());
	printChars (60,30,"%i triangles/frame",polycounter);
	printChars (60,50,"x:%.1f  y:%.1f z:%.1f",
		player->getControlObj()->getLocationX(),
		player->getControlObj()->getLocationY(),
		player->getControlObj()->getLocationZ());

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	// Print out player statistics

	// HP BAR
	printChars (HPBARX, HPBARY, "Hit  Point");

	printChars (HPBARX + 200, HPBARY, "(%i/%i)",
		player->getControlObj()->getAttributePtr()->hp,
		player->getControlObj()->getAttributePtr()->level * HP_PER_LEVEL);

	glDisable(GL_TEXTURE_2D);
	glColor3f(1.0f,1.0f,1.0f);
	glBegin(GL_QUADS);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->hp /
			(player->getControlObj()->getAttributePtr()->level * HP_PER_LEVEL)) *
			90 + HPBARX + 110, HPBARY);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->hp /
			(player->getControlObj()->getAttributePtr()->level * HP_PER_LEVEL)) *
			90 + HPBARX + 110, HPBARY + 15);
		glVertex2f(HPBARX + 200, HPBARY + 15);
		glVertex2f(HPBARX + 200, HPBARY);
	glEnd();
	glColor3f(1.0f,0.2f,0.3f);
	glBegin(GL_QUADS);
		glVertex2f(HPBARX + 110, HPBARY);
		glVertex2f(HPBARX + 110, HPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->hp /
			(player->getControlObj()->getAttributePtr()->level * HP_PER_LEVEL)) *
			90 + HPBARX + 110, HPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->hp /
			(player->getControlObj()->getAttributePtr()->level * HP_PER_LEVEL)) *
			90 + HPBARX + 110, HPBARY);
	glEnd();
	
	// MANA BAR
	glEnable(GL_TEXTURE_2D);
	printChars (MPBARX, MPBARY, "Mana Point");

	printChars (MPBARX + 200, MPBARY, "(%i/%i)",
		player->getControlObj()->getAttributePtr()->mp,
		player->getControlObj()->getAttributePtr()->level * MP_PER_LEVEL);
	glDisable(GL_TEXTURE_2D);

	glColor3f(1.0f,1.0f,1.0f);
	glBegin(GL_QUADS);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->mp /
			(player->getControlObj()->getAttributePtr()->level * MP_PER_LEVEL)) *
			90 + MPBARX + 110, MPBARY);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->mp /
			(player->getControlObj()->getAttributePtr()->level * MP_PER_LEVEL)) *
			90 + MPBARX + 110, MPBARY + 15);
		glVertex2f(MPBARX + 200, MPBARY + 15);
		glVertex2f(MPBARX + 200, MPBARY);
	glEnd();
	glColor3f(0.3f,0.2f,1.0f);
	glBegin(GL_QUADS);
		glVertex2f(MPBARX + 110, MPBARY);
		glVertex2f(MPBARX + 110, MPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->mp /
			(player->getControlObj()->getAttributePtr()->level * MP_PER_LEVEL)) *
			90 + MPBARX + 110, MPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->mp /
			(player->getControlObj()->getAttributePtr()->level * MP_PER_LEVEL)) *
			90 + MPBARX + 110, MPBARY);
	glEnd();

	// EXP BAR
	glEnable(GL_TEXTURE_2D);
	printChars (EXPBARX, EXPBARY, "EXP Point");

	RoleINT	nextLevelExp =	
		player->getControlObj()->getAttributePtr()->level * 
		player->getControlObj()->getAttributePtr()->level;
	printChars (EXPBARX + 200, EXPBARY, "(%i/%i)",
		player->getControlObj()->getAttributePtr()->exp,
		nextLevelExp);
	glDisable(GL_TEXTURE_2D);

	glColor3f(1.0f,1.0f,1.0f);
	glBegin(GL_QUADS);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->exp /
			(nextLevelExp)) *
			90 + EXPBARX + 110, EXPBARY);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->exp /
			(nextLevelExp)) *
			90 + EXPBARX + 110, EXPBARY + 15);
		glVertex2f(EXPBARX + 200, EXPBARY + 15);
		glVertex2f(EXPBARX + 200, EXPBARY);
	glEnd();
	glColor3f(0.8f,0.8f,0.0f);
	glBegin(GL_QUADS);
		glVertex2f(EXPBARX + 110, EXPBARY);
		glVertex2f(EXPBARX + 110, EXPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->exp /
			(nextLevelExp)) *
			90 + EXPBARX + 110, EXPBARY + 15);
		glVertex2f((1.0f * player->getControlObj()->getAttributePtr()->exp /
			(nextLevelExp)) *
			90 + EXPBARX + 110, EXPBARY);
	glEnd();

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //
	
	// restore previous Matrix mode
	glViewport(50,100, (GLsizei) (width-100), (GLsizei) (height-100));
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glPopMatrix();
	glDisable(GL_ALPHA_TEST);
	glEnable(GL_DEPTH_TEST);
	polycounter = 0;
	glFlush();
}
	

void menu_display(void)
{
	glColor3f(0.3f,0.3f,0.3f);
	display();
	glViewport(0,0, (GLsizei) width, (GLsizei) height);
	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GREATER,0.0);
	glEnable (GL_TEXTURE_2D);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDisable(GL_DEPTH_TEST);							
	glMatrixMode(GL_PROJECTION);						
	glPushMatrix();
	glLoadIdentity();									
	glOrtho(0,width,0,height,-100,100);					
	glMatrixMode(GL_MODELVIEW);							
	glLoadIdentity();									
	glColor3f(1.0f,0.95f,1.0f);

// Necessary Menu Info
		switch (menuMode)
		{
		case FILEMENU:
			printChars (150,350,"--- FILE MENU ---");
			printChars (150,320,"Quit : q");
			printChars (150,300,"Return to game : Escape");
			break;
		case HELP:
			printChars (150,350,"--- HELP MENU ---");
			printChars (100,320,"ARROWS , NUMPAD : direction");
			printChars (100,300,"Left CTR + ARROWS: Camera Move");
			printChars (100,280,"f : Fog Toggle   c : Camera fix Toggle");
			printChars (100,260,"holding space: Attack graphic(Not real attack)");
			printChars (100,240,"F1: this menu   F2 : Changing Weapon");
			printChars (100,220,"F10 : File Menu (Escape in game mode)");
			printChars (100,200,"Left Ctr-q : Quit");
			printChars (100,180,"The other keys... just try");
			printChars (100,160,"Return to game : Escape");
			break;
		case CHANGEWEAPON:
			break;
		default:
			printChars (150,350,"--- Changing Mode ---");
			break;
		}
		glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
		glDisable(GL_ALPHA_TEST);
		glColor3f(1.0f,1.0f,1.0f);
	// the following is an example of printing 3D Object respect to a camera.
	// In other words, it is gonna be used for drawing item screen or menu screen.
		if (menuMode == CHANGEWEAPON)
		{

// same projection as the NORMAL menu (display) projection view.			
			glMatrixMode(GL_PROJECTION);
			glPopMatrix();
			glPushMatrix();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			gluLookAt(0.0f,0.0f,0.0f,
				0.0f,0.0f,1.0f,
				0.0f,1.0f,0.0f);
	
			vector<Object *> * itemList = player->getControlObj()->getItemList();
			RoleINT tempmode = player->getCameraMode();
			player->setCameraMode(ATZERO);
			glDisable (GL_TEXTURE_2D);
			glColor4f(1.0f,1.0f,1.0f,0.40f);
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	// hitting..name
			glBegin(GL_QUADS);
				glNormal3f(0,0,-1); // need to be cacluated
				glVertex3f(-2.2f,-0.6f,5.0f);
				glVertex3f(-2.2f,1.0f,5.0f);
				glVertex3f(2.2f,1.0f,5.0f);
				glVertex3f(2.2f,-0.6f,5.0f);
			glEnd();
			glDisable(GL_BLEND);
			glEnable( GL_CULL_FACE );			// enable back face culling 
			glDisable(GL_DEPTH_TEST);							
			glEnable(GL_ALPHA_TEST);
			glEnable (GL_TEXTURE_2D);
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
			for (int i = 0; (i < itemList->size() && i < 5);i++)
			{
				printChars3D (1.5f,1.0f,5.0f,"--- CHANGING WEAPON ---");
	//			rolePrintlog("Itemlist size %i\n",itemList->size());
				(*itemList)[i]->draw(2.0f-i*1.2f,-1.0f,5.0f,-1.0f,0.0f,0.5f,player);
				printChars3D(2.0f-i*1.2f,-1.0f,5.0f,"%i %s",i,(*itemList)[i]->getName().data());
			}
			glDisable(GL_ALPHA_TEST);
			glEnable(GL_DEPTH_TEST);							
			player->setCameraMode(tempmode);
			glDisable( GL_CULL_FACE );			// enable back Face culling 
		}
	// restoring Projection matrix.
	glViewport(50,100, (GLsizei) (width-100), (GLsizei) (height-100));
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
}

/**********************************************************************************
	objectActions : Object AI. If object should move, it is through this routine
***********************************************************************************/

void objectActions(void)
{
	world->action();
}

void handle_key_down(SDL_keysym * keysym)
{
	int i = 0;

	switch(keysym->sym) {
	case SDLK_ESCAPE:
	case SDLK_F10:
		menuMode = FILEMENU;
		break;
	case SDLK_c:
		if (player->getCameraMode() == MANUAL)
		{
			player->setCameraMode(AUTO);
		}
		else
		{
			player->setCameraMode(MANUAL);
		}
		break;
	case SDLK_h:
	case SDLK_F1:
		menuMode = HELP;
		break;
	case SDLK_F2:
		menuMode = CHANGEWEAPON;
		break;
	case SDLK_F3:
		if (polyMode == GL_FILL) 
		{
			polyMode = GL_LINE;
		}
		else 
		{
			polyMode = GL_FILL;
		}
		break;
	case SDLK_F4:
		if (roam_on == RoleTRUE) 
		{
			roam_on = RoleFALSE;
		}
		else 
		{
			roam_on = RoleTRUE;
		}
		break;
	case SDLK_f:
		
		if (fogMode == NOFOG) 
		{
			fogMode = FOG;
			player->setVisibility(1100.0);
		}
		else
		{
			fogMode = NOFOG;
			player->setVisibility(1100.0);
		}
		reshape(width,height,player->getVisibility());
		break;
	case SDLK_r:
		player->cameraSetCoord(0.0+1000,100.0,-400+1000);
		break;
	case SDLK_KP1:
		player->cameraSetCoord(-200.0+1000,7.0,-150+1000);
		break;
	case SDLK_KP4:
		player->ObjectGoLeft(speed);
		break;
	case SDLK_KP6:
		player->ObjectGoRight(speed);
		break;
	case SDLK_KP3:
		player->cameraSetCoord(200.0+1000,7.0,150+1000);
		break;
	case SDLK_m:
		player->ObjectCastFireball(player->getControlObj()->getDirectionX(), player->getControlObj()->getDirectionZ());
		break;
	case SDLK_l:
		player->ObjectCastLightning();
		break;
	case SDLK_a:
		player->gotoObj();
		break;
	case 82:
		player->cameraSetCoord((RoleFLOAT)rand()*2000/(RAND_MAX+1),
			7.0,(RoleFLOAT)rand()*2000/(RAND_MAX+1));
		break;
	case SDLK_x:
		player->setVisibility(player->getVisibility()-50.0);
		reshape(width,height,player->getVisibility());
		break;
	case SDLK_z:
		player->setVisibility(player->getVisibility()+50.0);
		reshape(width,height,player->getVisibility());
		break;
	case SDLK_s:
		speed+=0.3;
		break;
	case 83:
		if (speed > 0.8)
			speed-=0.3;
		break;
	default:
		break;
	}
}

void handle_mouse_down(SDL_MouseButtonEvent * event)
{
	switch(event->button)
	{
	case SDL_BUTTON_LEFT:
		normal_mouse->processMouse(event->x,event->y);
		if (normal_mouse->getSelectedObj() !=NULL)
		{
			player->ObjectGoToObject(normal_mouse->getSelectedObjNum(),speed);
		}
		else
		{
			player->ObjectGoToXZ(normal_mouse->getMouse3dX(),
				normal_mouse->getMouse3dY(),normal_mouse->getMouse3dZ(),speed);
		}
		break;
	// Ray added RIGHT BUTTON
	case SDL_BUTTON_RIGHT:
		normal_mouse->processMouse(event->x,event->y);
		if (normal_mouse->getSelectedObj() != NULL) {
			player->ObjectGoToAndAttack(normal_mouse->getSelectedObjNum(),speed);
		}
		else 
		{
			player->ObjectAttack();
		}
		break;
	case SDL_BUTTON_MIDDLE:
		normal_mouse->processMouse(event->x, event->y);
		if (normal_mouse->getSelectedObj() == NULL) {
			player->ObjectCastFireball(player->getControlObj()->getDirectionX(), player->getControlObj()->getDirectionZ());
		} else {
			RoleFLOAT newDirX = normal_mouse->getSelectedObj()->getLocationX() - player->getControlObj()->getLocationX();
			RoleFLOAT newDirZ = normal_mouse->getSelectedObj()->getLocationZ() - player->getControlObj()->getLocationZ();
			RoleFLOAT amount = sqrt(newDirX * newDirX + newDirZ * newDirZ);
			if (amount == 0) {
				newDirX = player->getControlObj()->getDirectionX();
				newDirZ = player->getControlObj()->getDirectionZ();
			} else {
				newDirX /= amount;
				newDirZ /= amount;
			}
			player->ObjectCastFireball(newDirX, newDirZ);
		}
		break;
	}
}

void handle_mouse_motion(SDL_MouseMotionEvent * event)
{
}


// Keyboard and mouse is constantly checked by this function.

void process_events(void)
{
	SDL_Event event;
	RoleINT mouseDownEvents=0;

	player->preevents();
	normal_mouse->processMouse();

	while (SDL_PollEvent(&event)) 
	{
		switch(event.type) 
		{
		case SDL_KEYDOWN:
			handle_key_down(&event.key.keysym);
			break;
		case SDL_MOUSEBUTTONDOWN:
			// if there are more than one events in event queue, just do one.
			// later change this..
			if (mouseDownEvents == 0)
				handle_mouse_down((SDL_MouseButtonEvent *) &event);
			else
				mouseDownEvents++;
			break;
		case SDL_MOUSEMOTION:
			// if there are more than one events in event queue, just do one.
			// later change this..
			handle_mouse_motion((SDL_MouseMotionEvent *) &event);
			break;
			/*
Structure Data

type SDL_MOUSEBUTTONDOWN or SDL_MOUSEBUTTONUP 
button The mouse button index (SDL_BUTTON_LEFT, SDL_BUTTON_MIDDLE, SDL_BUTTON_RIGHT) 
state SDL_PRESSED or SDL_RELEASED 
x, y The X/Y coordinates of the mouse at press/release time 
*/		case SDL_QUIT:
			quit_role(0);
			break;
		}
	}
	int numKeys;
	Uint8* pKeys = SDL_GetKeyState(&numKeys);

	if (pKeys[SDLK_LCTRL])
	{
		if ((pKeys[SDLK_KP8]) || (pKeys[SDLK_UP]))
			player->cameraGoUp(speed);
		else if ((pKeys[SDLK_KP2]) || (pKeys[SDLK_DOWN]))
			player->cameraGoDown(speed);
		else if ((pKeys[SDLK_KP4]) || (pKeys[SDLK_LEFT]))
			player->cameraGoLeft(speed);
		else if ((pKeys[SDLK_KP6]) || (pKeys[SDLK_RIGHT]))
			player->cameraGoRight(speed);
		if (pKeys[SDLK_q])
			quit_role(0);
	}
	else if (pKeys[SDLK_LSHIFT])
	{
		if ((pKeys[SDLK_KP8]) || (pKeys[SDLK_UP]))
			player->cameraZoomIn(speed);
		else if ((pKeys[SDLK_KP2]) || (pKeys[SDLK_DOWN]))
			player->cameraZoomOut(speed);
		else if ((pKeys[SDLK_KP4]) || (pKeys[SDLK_LEFT]))
			player->cameraGoLeft(speed);
		else if ((pKeys[SDLK_KP6]) || (pKeys[SDLK_RIGHT]))
			player->cameraGoRight(speed);
	}
	else
	{
		if (pKeys[SDLK_SPACE])
			player->ObjectAttack();
		else
		{
			if ((pKeys[SDLK_KP8]) || (pKeys[SDLK_UP]))
			{
				if ((pKeys[SDLK_KP7]) || (pKeys[SDLK_LEFT]))
					player->ObjectTurnLeft(turnspeed);
				else if ((pKeys[SDLK_KP9]) || (pKeys[SDLK_RIGHT]))
					player->ObjectTurnRight(turnspeed);
				player->ObjectGoFront(speed);
			}
			else if ((pKeys[SDLK_KP2]) || (pKeys[SDLK_DOWN]))
			{
				if ((pKeys[SDLK_KP7]) || (pKeys[SDLK_LEFT]))
					player->ObjectTurnRight(turnspeed);
				else if ((pKeys[SDLK_KP9]) || (pKeys[SDLK_RIGHT]))
					player->ObjectTurnLeft(turnspeed);
				player->ObjectGoBack(speed);
			}
			else
			{
				if ((pKeys[SDLK_KP7]) || (pKeys[SDLK_LEFT]))
					player->ObjectTurnLeft(turnspeed);
				else if ((pKeys[SDLK_KP9]) || (pKeys[SDLK_RIGHT]))
					player->ObjectTurnRight(turnspeed);
			}
		}
	}
	if (normal_mouse->getScreenX() < 3)
	{
		player->cameraGoRight(speed*2.0);
	}
	else if (normal_mouse->getScreenX() > width-4)
	{
		player->cameraGoLeft(speed*2.0);
	}
	player->processObjectEvents();
}

void menu_handle_key_down(SDL_keysym * keysym)
{
	int i = 0;

	switch (menuMode)
	{
	case FILEMENU:
		switch(keysym->sym) {
		case SDLK_q:
			quit_role(0);
			break;
		default:
			break;
		}
		break;
	case CHANGEWEAPON:
		if ((keysym->sym >= SDLK_0) || 
			(keysym->sym <= SDLK_9))
		{
			player->switchWeapon(keysym->sym-SDLK_0);
		}
		else if ((keysym->sym >= SDLK_KP0) || 
			(keysym->sym <= SDLK_KP9))
		{
			player->switchWeapon(keysym->sym-SDLK_KP0);
		}
		break;
	default:
		break;
	}
	switch(keysym->sym) {
	case SDLK_ESCAPE:
		menuMode = NORMAL;
		break;
	case SDLK_F1:
		menuMode = HELP;
		break;
	case SDLK_F2:
		menuMode = CHANGEWEAPON;
		break;
	case SDLK_F10:
		menuMode = FILEMENU;
		break;
	default:
		break;
	}
}

void menu_process_events(void)
{
	SDL_Event event;
	player->preevents();
	while (SDL_PollEvent(&event)) {
		switch(event.type) {
		case SDL_KEYDOWN:
			menu_handle_key_down(&event.key.keysym);
			break;
		case SDL_QUIT:
			quit_role(0);
			break;
		}
	}
	int numKeys;
	Uint8* pKeys = SDL_GetKeyState(&numKeys);

	if (pKeys[SDLK_LCTRL])
	{
		if (pKeys[SDLK_q])
			quit_role(0);
	}
	player->processObjectEvents();
}

// Finally main...

int main(int argc, char ** argv)
{
	Uint32 currtime = 0;
	Uint32 nextUpdate=0;
	Uint32 objectUpdate=0;
	Uint32 pretime = 0;
	fogMode = FOG;

	const SDL_VideoInfo * info = NULL;
	int bpp = 0; // color depth in bits of our window
	int flags = 0;
	

	roleInit();
	if (argc == 3) 
	{
//		if (sscanf(argv[1],"%i",&numplayer) !=1)
//		{
//			return 0;
//		}
		numplayer = atoi (argv[1]);
		if (numplayer < 1) {
			return 0;
		}
		ipaddress = argv[2];
		rolePrintlog("numplayer : %i, ipaddress : %s\n\n",numplayer, ipaddress);
	}
/***************************************************************************/
// Video setting... Pretty standard. getting the idea from SDL example code.

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_AUDIO) < 0) 
	{
		rolePrintlog ("SDL Video/Timer/Audio initialization failed: %s\n",
			SDL_GetError());
		quit_role(1);
	}

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	info = SDL_GetVideoInfo();

	if (!info) 
	{
		rolePrintlog ("Video query failed : %s\n", SDL_GetError());
		quit_role(1);
	}


	width = XSIZE;
	height = YSIZE;
	bpp = info->vfmt->BitsPerPixel;

	SDL_GL_SetAttribute ( SDL_GL_RED_SIZE,5);
	SDL_GL_SetAttribute ( SDL_GL_GREEN_SIZE,5);
	SDL_GL_SetAttribute ( SDL_GL_BLUE_SIZE,5);
	SDL_GL_SetAttribute ( SDL_GL_DEPTH_SIZE,16);
	SDL_GL_SetAttribute ( SDL_GL_DOUBLEBUFFER,1);


	flags = SDL_OPENGL|SDL_FULLSCREEN;
	if (SDL_SetVideoMode(width, height, bpp, flags) == 0) 
	{
		rolePrintlog("Video mode set failed %s\n",SDL_GetError());
		quit_role(1);
	}

// ----------------- BEGIN MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

	bgmusic = new BackgroundMusic();

// ----------------- END MODIFIED BY CEDRIC AND RAYMOND ---------------------- //

/***************************************************************************/
	glinit();
	reshape(width,height,player->getVisibility());
/***************************************************************************/
// main never ending loop.
	while (1)
	{

		// starting with getting time for the loop. time is integer and its unit is milisecond.
		// note that 1. if the computer is slower than 10fps, everything is slowdown.
		//           2. if the computer is slower than 20fps, input is going to slowdown.
			currtime = SDL_GetTicks();
			if (currtime - pretime > 1000)
			{
				// every second operation.
				fps = fpscounter;
				fpscounter = 0;
				pretime = currtime;
			}
			if (menuMode == NORMAL)
			{
				if (currtime > nextUpdate)
				{
					nextUpdate = currtime+50; // 40 input per second.
//					player->getControlObj()->setMode(Object::STANDING);
					process_events();
				}
				if (currtime > objectUpdate)
				{
					objectUpdate = currtime+100; // 10 movement per second. 
					objectActions(); 
				}
//				process_events();
				display();
			}
			else // any menu mode
			{
/* for multiplayer game, nothing can pause
				if (currtime > objectUpdate)
				{
					objectUpdate = currtime+100; // 10 movement per second. 
					objectActions(); 
				}
*/				if (currtime > nextUpdate)
				{
					nextUpdate = currtime+50; // 40 input per second.
					menu_process_events();
				}
				if (currtime > objectUpdate)
				{
					objectUpdate = currtime+100; // 10 movement per second. 
					objectActions(); 
				}
				menu_display();
			}
			SDL_GL_SwapBuffers();
	}
	return 0;
}
