package edu.cmu.cs.cs214.chat.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import edu.cmu.cs.cs214.chat.core.ChatServer;

public class SimpleChatClient extends JPanel {
	private static final long serialVersionUID = 6647535125556634481L;
	
	final JFrame parentFrame;
	final List<String> names;

	public SimpleChatClient(JFrame frame) {
		this.parentFrame = frame;
		this.names = new ArrayList<String>();
		
														        // Creates a series of components to add to the panel.
		JLabel participantLabel = new JLabel("Name: ");
		final JTextField participantText = new JTextField(20);  // Must be final to be accessible to the anonymous class.
		JButton participantButton = new JButton("Add participant");
		JPanel participantPanel = new JPanel();
		participantPanel.setLayout(new BorderLayout());
		participantPanel.add(participantLabel, BorderLayout.WEST);
		participantPanel.add(participantText, BorderLayout.CENTER);
		participantPanel.add(participantButton, BorderLayout.EAST);
		
		ActionListener newParticipantListener = new ActionListener() {  // Defines an anonymous class to handle
			public void actionPerformed(ActionEvent e) {                // events generated on the participantButton
				String name = participantText.getText();                // or participantText field.
				if (!name.equals("") && !names.contains(name)) {
					names.add(name);
				}
				participantText.setText("");
				participantText.requestFocus();
			}
		};
		
		participantButton.addActionListener(newParticipantListener);
		participantText.addActionListener(newParticipantListener);
				
		JButton createButton = new JButton("Start chat");
		createButton.addActionListener(new ActionListener() {  // Starts a new chat when the createButton is clicked.
			public void actionPerformed(ActionEvent e) {
				if (!names.isEmpty()) {
					startChatSession();
				}
			}
		});
		
		this.setLayout(new BorderLayout());
		add(participantPanel, BorderLayout.NORTH);  // Adds the components we've created
		add(createButton, BorderLayout.SOUTH);      // to the panel (and to the window).
		this.setVisible(true);
	}
	
	
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				JFrame frame = new JFrame("Start a SimpleChat session");
				frame.add(new SimpleChatClient(frame));
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				frame.pack();
				frame.setResizable(false);
				frame.setVisible(true);
			}
		});
		
	}
	
	
	/**
	 * Starts a new chat, opening one window for each participant.
	 */
	private void startChatSession() {
		final ChatServer server = new ChatServer();
		final String title = "Simple Chat Client -- ";
		
		String firstName = names.get(0); 
		parentFrame.remove(this);                           // Removes the initial dialog panel and
		parentFrame.add(new ChatPanel(server, firstName));  // starts the first participant's chat
		parentFrame.setTitle(title + firstName);            // in the existing window.
		parentFrame.setResizable(true);
		parentFrame.pack();
		
		for (int i = 1; i < names.size(); ++i) {  // Creates a new window for each other participant.
			final String name = names.get(i);
			SwingUtilities.invokeLater(new Runnable() {
				@Override
				public void run() {
					JFrame frame = new JFrame(title + name);
					frame.add(new ChatPanel(server, name));
					frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					frame.pack();
					frame.setResizable(true);
					frame.setVisible(true);
				}
			});
		}
		
	}

}
