package edu.cmu.cs.cs214.chat.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import edu.cmu.cs.cs214.chat.core.ChatServer;
import edu.cmu.cs.cs214.chat.core.ChatSubscriber;

public class ChatPanel extends JPanel implements ChatSubscriber {
	private static final long serialVersionUID = 4819162036004676580L;
	
	private static final int FIELD_WIDTH = 60;
	private static final int AREA_WIDTH = FIELD_WIDTH + 10;
	private static final int AREA_HEIGHT = 20;
	
	private final String name;
	private final ChatServer server;
	private final JTextArea chatArea;
	
	public ChatPanel(ChatServer _server, String _name) {
		if (_name == null || _server == null) {
			throw new NullPointerException();
		}
		this.name = _name;
		this.server = _server;
		
		this.chatArea = new JTextArea(AREA_HEIGHT, AREA_WIDTH);    // Sets up a scrollable text
		chatArea.setEditable(false);                               // area that line-wraps its
		chatArea.setLineWrap(true);                                // messages, for the chat
		chatArea.setWrapStyleWord(true);                           // messages.
		JScrollPane scrollPane = new JScrollPane(chatArea);
		
		final JTextField chatField = new JTextField(FIELD_WIDTH);  // Sets up a text field for
		JButton sendButton = new JButton("Send");                  // typing chat messages,
		JPanel messagePanel = new JPanel();                        // and a button to send them.
		messagePanel.setLayout(new BorderLayout());
		messagePanel.add(chatField, BorderLayout.WEST);
		messagePanel.add(sendButton, BorderLayout.EAST);
		
		ActionListener sendChatListener = new ActionListener() {   // Observer to send a message
			public void actionPerformed(ActionEvent e) {           // when the user presses the
				String message = chatField.getText();              // send button or hits enter
				if (!message.equals("")) {                         // in the message field.
					server.publish(name, message);
				}
				chatField.setText("");
				chatField.requestFocus();
			}
		};
		sendButton.addActionListener(sendChatListener);
		chatField.addActionListener(sendChatListener);
		
		setLayout(new BorderLayout());
		add(scrollPane, BorderLayout.NORTH);
		add(messagePanel, BorderLayout.SOUTH);
		setVisible(true);
		
		server.subscribe(this);  // Subscribes to chat messages
	}
	
	@Override
	public void handleMessage(String name, String message) {
		String newText = " " + name + ": " + message + "\n";
		chatArea.append(newText);
	}
}
