/*****************************************************************************/
/*****************************************************************************/

/* Trajectory Types */
#define NOT_INCLUDED 0
#define LINEAR_SPLINE 1 
#define CUBIC_SPLINE 3 
#define QUINTIC_SPLINE 5 

/*****************************************************************************/

typedef struct knot3
{
  int type;
  float time;
  float position;
  float velocity;
  float acceleration;
  int id; /* unique ID, so can access specific knots */
  struct knot3 *previous;
  struct knot3 *next;
} KNOT3;

typedef struct dofs
{
  char *name;
  int dof;
  int n_knots;
  KNOT3 *knots;
} DOFS;

/*****************************************************************************/

int init_trajectory( DOFS *traj, int n_dof );
int print_trajectory( DOFS *traj, int n_dof );
int set_first_knot_to( DOFS *current_desireds, int dof, int type, float time, 
		   float position, float velocity, float acceleration );
int clear_knots( DOFS *traj, int dof );
int clear_all_knots( DOFS *traj, int n_dof );
KNOT3 *add_knot_point( DOFS *traj, int dof, int type, float time, 
		float position, float velocity, float acceleration );
KNOT3 *add_knot_point_array( DOFS *traj, int dof, int type, float time, 
		float *values );
KNOT3 *add_knot_point_knot( DOFS *traj, int dof, int type, float *values );
int lookup_spline3( DOFS *traj, int dof, float time, DOFS *current_desireds,
		float *p_position, float *p_velocity, float *p_acceleration );
int lookup_spline3_alt( DOFS *traj, int dof, float time, 
			DOFS *current_desireds,
		float *p_position, float *p_velocity, float *p_acceleration );
int 
advance_all_periodic_knots( DOFS *traj, int n_dofs, float time, float amount );

/*****************************************************************************/
/*****************************************************************************/
