/* The 2D view extension to X graphics */
#include <math.h>
#include "pixels.h"
#include "views.h"

/****************************************************************************/

#define X 0
#define Y 1
#define Z 2

#define DEBUG_VIEW3 0

/****************************************************************************/
/****************************************************************************/

/* 
main()
*/
views3_main()
{
  View3 v3;
  pView3 pv3;

  pv3 = &v3;

  init_window( 1.0 );
  set_up_view3( pv3,
	       0.0, 0.0, 1.0,
	       1.0, 1.0, 1.0,
	       0.0, 0.0, -1.0,
	       0.0, 1.0, 0.0,
	       1.0 );

  v3_draw_line( -0.5, -0.5, 0.0, 0.5, 0.0, 0.0, SET, pv3 );
  v3_draw_line( -1.0, -1.0, 0.0, 1.0, 1.0, 0.0, SET, pv3 );

  flush_graphics();

  printf( "Press return to quit.\n" );
  getchar();
}

/****************************************************************************/

set_up_view3( pv3, 
	     camera_location_x, camera_location_y, camera_location_z,
	     scale_x, scale_y, scale_z,
	     view_direction_x, view_direction_y, view_direction_z,
	     view_up_x, view_up_y, view_up_z,
	     zoom )
     pView3 pv3;
     float scale_x, scale_y, scale_z;
     float camera_location_x, camera_location_y, camera_location_z;
     float view_direction_x, view_direction_y, view_direction_z;
     float view_up_x, view_up_y, view_up_z;
     float zoom;
{
  pv3->camera_location[X] = camera_location_x;
  pv3->camera_location[Y] = camera_location_y;
  pv3->camera_location[Z] = camera_location_z;
  pv3->scale[X] = scale_x;
  pv3->scale[Y] = scale_y;
  pv3->scale[Z] = scale_z;
  pv3->view_direction[X] = view_direction_x;
  pv3->view_direction[Y] = view_direction_y;
  pv3->view_direction[Z] = view_direction_z;
  pv3->view_up[X] = view_up_x;
  pv3->view_up[Y] = view_up_y;
  pv3->view_up[Z] = view_up_z;
  pv3->zoom = zoom;

  update_v3( pv3 );
}

/****************************************************************************/

update_v3( pv3 )
     pView3 pv3;
{
  int i, j;
  float r_z[3], r_x[3], r_y[3];

  /* The view direction is the negative Z axis */
  r_z[X] = -pv3->view_direction[X]/pv3->scale[X];
  r_z[Y] = -pv3->view_direction[Y]/pv3->scale[Y];
  r_z[Z] = -pv3->view_direction[Z]/pv3->scale[Z];
  /* scale_vector( pv3->view_direction, -1.0, r_z ); */
  unit_vector( r_z, r_z );
  
  cross_product( pv3->view_up, r_z, r_x );
  unit_vector( r_x, r_x );

  cross_product( r_z, r_x, r_y );
  unit_vector( r_y, r_y );

  for( i = 0; i < 3; i++ )
    {
      pv3->view_rotation[X][i] = r_x[i];
      pv3->view_rotation[Y][i] = r_y[i];
      pv3->view_rotation[Z][i] = r_z[i];
    }

  set_up_view( &(pv3->v2), -1.0, -1.0, 1.0, 1.0 );
}

/****************************************************************************/

v3_draw_line( x1, y1, z1, x2, y2, z2, operation, pv3 )
     float x1, y1, z1, x2, y2, z2;
     int operation;
     pView3 pv3;
{
  pView pv;
  float point_1_3D[3], point_2_3D[3];
  float point_1_2D[3], point_2_2D[3];
  
  if ( DEBUG_VIEW3 )
    printf( "%g %g %g %g %g %g\n", x1, y1, z1, x2, y2, z2 );

  point_1_3D[X] = x1;
  point_1_3D[Y] = y1;
  point_1_3D[Z] = z1;
  point_2_3D[X] = x2;
  point_2_3D[Y] = y2;
  point_2_3D[Z] = z2;

  convert_3D_to_2D( point_1_3D, point_1_2D, pv3 );
  convert_3D_to_2D( point_2_3D, point_2_2D, pv3 );

  if ( DEBUG_VIEW3 )
    {
      printf( "%g %g %g -> %g %g\n", x1, y1, z1,
	     point_1_2D[X], point_1_2D[Y] );
      printf( "%g %g %g -> %g %g\n", x2, y2, z2,
	     point_2_2D[X], point_2_2D[Y] );
    }

  vdraw_line( point_1_2D[X], point_1_2D[Y], point_2_2D[X], point_2_2D[Y], 
	     operation, &(pv3->v2) );
}

/****************************************************************************/
/***************************************************************************/

convert_3D_to_2D( v3, v2, pv3 )
     float v3[3];
     float v2[3];
     pView3 pv3;
{
  int i;
  float v_scaled[3];
  float v_translated[3];
  float v_rotated[3];
  float v_zoomed[3];

  if ( DEBUG_VIEW3 )
    print_vector( v3 );

  /* Translate so that the camera is located at (0, 0, 0) */
  for( i = 0; i < 3; i++ )
    v_translated[i] = v3[i] - pv3->camera_location[i];
  if ( DEBUG_VIEW3 )
    print_vector( v_translated );

  /* Scale x, y and z */
  for( i = 0; i < 3; i++ )
    v_scaled[i] = v_translated[i]/pv3->scale[i];
  if ( DEBUG_VIEW3 )
    print_vector( v_scaled );

  /* Rotate so camera points along negative Z axis */
  rotate_3D( pv3->view_rotation, v_scaled, v_rotated );
  if ( DEBUG_VIEW3 )
    print_vector( v_rotated );

  /* Clip to get rid of stuff behind */
  /* We don't do that here */
  
  /* Zoom */
  v_zoomed[X] = pv3->zoom*v_rotated[X];
  v_zoomed[Y] = pv3->zoom*v_rotated[Y];
  v_zoomed[Z] = v_rotated[Z];
  if ( DEBUG_VIEW3 )
    print_vector( v_zoomed );

  /* Perspective projection. Remember that the camera looks down the
   negative Z axis */
  v2[X] = v_zoomed[X]/(-v_zoomed[Z]);
  v2[Y] = v_zoomed[Y]/(-v_zoomed[Z]);
  v2[Z] = -v_zoomed[Z];
  if ( DEBUG_VIEW3 )
    print_vector( v2 );
}

/***************************************************************************/

rotate_3D( r_matrix, v1, v2 )
     float r_matrix[3][3];
     float v1[3]; 
     float v2[3];
{
  int i, j;

  for( i = 0; i < 3; i++ )
    {
      v2[i] = 0;
      for( j = 0; j < 3; j++ )
	{
	  v2[i] += r_matrix[i][j] * v1[j];
	}
    }
}

/***************************************************************************/
/****************************************************************************/
/****************************************************************************/
/***************************************************************************/

scale_vector( v1, s, v2 )
     float v1[3];
     float s;
     float v2[3];
{
  int i;

  for( i = 0; i < 3; i++ )
    v2[i] = s*v1[i];
}

/***************************************************************************/

unit_vector( v1, v2 ) 
     float v1[3];
     float v2[3];
{
  int i;
  float length = 0;

  for( i = 0; i < 3; i++ )
    length += v1[i]*v1[i];

  length = sqrt( (double) length );
  
  for( i = 0; i < 3; i++ )
    v2[i] = v1[i]/length;
}

/***************************************************************************/

cross_product( v1, v2, v3 )
     float v1[3];
     float v2[3];
     float v3[3];
{

  v3[X] = v1[Y]*v2[Z] - v1[Z]*v2[Y];
  v3[Y] = v1[Z]*v2[X] - v1[X]*v2[Z];
  v3[Z] = v1[X]*v2[Y] - v1[Y]*v2[X];
}

/***************************************************************************/

print_vector( v )
     float v[3];
{
  printf( "%g %g %g\n", v[X], v[Y], v[Z] );
}

/***************************************************************************/

box3( x1, y1, z1, x2, y2, z2, operation, pv3 )
     float x1, y1, z1, x2, y2, z2;
     int operation;
     pView3 pv3;
{
  v3_draw_line( x1, y1, z1, x2, y1, z1, operation, pv3 );  
  v3_draw_line( x1, y1, z1, x1, y2, z1, operation, pv3 );  
  v3_draw_line( x1, y1, z1, x1, y1, z2, operation, pv3 );  
  v3_draw_line( x2, y1, z1, x2, y2, z1, operation, pv3 );  
  v3_draw_line( x2, y1, z1, x2, y1, z2, operation, pv3 );  
  v3_draw_line( x1, y2, z1, x2, y2, z1, operation, pv3 );  
  v3_draw_line( x1, y2, z1, x1, y2, z2, operation, pv3 );  
  v3_draw_line( x1, y1, z2, x2, y1, z2, operation, pv3 );  
  v3_draw_line( x1, y1, z2, x1, y2, z2, operation, pv3 );  
  v3_draw_line( x2, y2, z2, x1, y2, z2, operation, pv3 );  
  v3_draw_line( x2, y2, z2, x2, y1, z2, operation, pv3 );  
  v3_draw_line( x2, y2, z2, x2, y2, z1, operation, pv3 );  
}

/****************************************************************************/

draw_cross_3( x, y, z, dx, dy, dz, operation, pv3 )
     float x, y, z, dx, dy, dz;
     int operation;
     pView3 pv3;
{

  v3_draw_line( x - dx, y, z, x + dx, y, z, operation, pv3 );
  v3_draw_line( x, y - dy, z, x, y + dy, z, operation, pv3 );
  v3_draw_line( x, y, z - dz, x, y, z + dz, operation, pv3 );
}

/****************************************************************************/

