/* Stolen from /usr/include/pixrect/pixrect.h */

/*
 * Operations.  In the case of depth=1 pixrects the 'op' in 'rasterop' may be
 * any binary Boolean function, encoded as a non-negative integer < 16,
 * the op code.  The function is applied per-pixel.  
 *
 * The following permit the op to be expressed as Boolean combinations
 * of the two inputs 'source' and 'dest'.  Thus oring the source and destination
 * together is written as PIX_SRC|PIX_DST, while xoring the source with the
 * destination is PIX_SRC^PIX_DST.  Since ~op is negative, the macro PIX_NOT
 * is provided for use in place of ~.  For bit plane mask operations
 * PIX_PLN may be included in the boolean combination for depth 8 pixrects.
 */
#define PIX_SRC         (0xC << 1)
#define PIX_DST         (0xA << 1)
#define PIX_NOT(op)     ((0xf<<1)&(~(op)))              /* clean ~op */
#define PIX_CLR         (PIX_SRC&PIX_NOT(PIX_SRC))      /* background */
#define PIX_SET         (PIX_SRC|PIX_NOT(PIX_SRC))      /* foreground */
#define PIX_COLOR(c)    ((c)<<5)
#define PIX_OPCOLOR(op) ((op)>>5)

#define ltGray  1
#define dkGray  2
#define gray    3
#define black   4
#define white   5

/* Pixel operations. */
#define SET PIX_SET
#define CLEAR PIX_CLR
#define OR (PIX_SRC | PIX_DST)
#define AND (PIX_SRC & PIX_DST)
#define XOR (PIX_SRC ^ PIX_DST)
#define NORMAL_VIDEO PIX_SRC /* for pw_text and bitblts only. */
#define INVERSE_VIDEO PIX_NOT(PIX_SRC) /* for pw_text and bitblts only. */
