/* These routines keep track of mouse position in terms of use coordinates
based on the view pcv passed to these routines. */

/* To run this under SUNTOOLS uncomment sections marked by "SUNTOOLS only" */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
/* SUNTOOLS only
#include <sunwindow/window_hs.h>
*/
#include "pixels.h"
#include "views.h"

float fmouse_x, fmouse_y; 

/* from views.c */
extern float display_x_to_user(), display_y_to_user();
extern float user_x_to_display(), user_y_to_display();

static char fxs[200];
static char fys[200];

/* from graphics.c */
struct pixwin *w_pw;

static int l = 10; /* cursor size. */
static int p[2];
static int _x, _y, _last_x, _last_y;

/****************************************************************************/

init_and_warp_mouse( init_x, init_y, pcv )
     float init_x, init_y;
     pView pcv;
{

  printf( "Tracking mouse ...\n" );
  printf( "Move mouse into this window and hit ^C to stop tracking.\n" );

  /* Initialize variables and warp mouse. */
  fmouse_x = init_x;
  fmouse_y = init_y;
  _last_x = _x = (int) user_x_to_display( (double) fmouse_x, pcv );
  _last_y = _y = (int) user_y_to_display( (double) fmouse_y, pcv );

  /*
  draw_line( _x - l, _y, _x + l, _y, XOR );
  draw_line( _x, _y - l, _x, _y + l, XOR );
  */
  warp_mouse( _x, _y );

/* SUNTOOLS only
  sprintf( fxs, "%5f", fmouse_x );
  sprintf( fys, "%5f", fmouse_y );
  pw_text( w_pw, 10, 100, INVERSE_VIDEO, NULL, fxs );
  pw_text( w_pw, 10, 120, INVERSE_VIDEO, NULL, fys );
*/
}

/****************************************************************************/

read_mouse_and_update_display( pcv )
     pView pcv;
{
  int c;
  
  c = read_mouse( p );
  
  _x = p[0];
  _y = p[1];

  /* Manage cursor. */
  if ( ( _x != _last_x ) || ( _y != _last_y ) )
    {
      /*
      draw_line( _last_x - l, _last_y, _last_x + l, _last_y, XOR );
      draw_line( _last_x, _last_y - l, _last_x, _last_y + l, XOR );
      draw_line( _x - l, _y, _x + l, _y, XOR );
      draw_line( _x, _y - l, _x, _y + l, XOR );
      */
      _last_x = _x;
      _last_y = _y;
      fmouse_x = (double) display_x_to_user( (double) _x, pcv );
      fmouse_y = (double) display_y_to_user( (double) _y, pcv );
/* SUNTOOLS only
      sprintf( fxs, "%5f", fmouse_x );
      sprintf( fys, "%5f", fmouse_y );
      pw_text( w_pw, 10, 100, INVERSE_VIDEO, NULL, fxs );
      pw_text( w_pw, 10, 120, INVERSE_VIDEO, NULL, fys );
*/
    }
  
/* SUNTOOLS only
  if ( c > 0 )
    {
      if ( c > 255 || !(isprint(c)) )
	printf( "(%d)\n", c );
      else
	printf( "%c (%d)\n", (char) c, c );
    }
*/
/* ??? c >= 0 ) ?????*/
  if ( c > 0 )
    {
      printf( "(%d)\n", c );
    }

  return( c );
}

/****************************************************************************/
