#include <stdio.h>
#include <X11/Xlib.h>
/* includes <X/X.h> and <sys/types.h> */
#include "pixels.h"

#define BORDER_WIDTH 3
#define POSTSCRIPT_PAGE_WIDTH 2400
#define POSTSCRIPT_PAGE_HEIGHT 3150
#define OVERRIDE_WINDOW_MANAGER True
#define MY_GX_FUNCTION GXcopy

Pixmap x_gray;
Pixmap x_dkGray;
Pixmap x_ltGray;
Pixmap x_white;
int    current_fill_pattern = black;

Display *display;

/* NULL => default to value of DISPLAY variable. */
static char *display_name = NULL;

static int screen;
static XWindowAttributes window_info; /* Where info on window goes. */
static XFontStruct *font_info; /* Font to be displayed. */
static char *font_name = "9x15";
static GC setGC, clrGC, xorGC;			 /* STRUCTURES*/
static GC setGC_white, clrGC_white, xorGC_white;
static GC setGC_black, clrGC_black, xorGC_black;
static GC setGC_gray, clrGC_gray, xorGC_gray; 
static GC setGC_ltGray, clrGC_ltGray, xorGC_ltGray; 
static GC setGC_dkGray, clrGC_dkGray, xorGC_dkGray; 
static GC setTxtGC, clrTxtGC, xorTxtGC;
GC select_gc( int operation );
int x_graphics_error (char *identifier);
int x_flush (void);
void   SetFillPattern(int pat);

/*
main( argc, argv )
int argc;
char **argv;
{
  test_graphics_x11();
  test_graphics_simple();
}
*/

test_graphics_x11()
{
  Window w1, w2;
  Window x_create_window();

  unsigned int width;

  x_init_graphics();

  printf( "Screen size: %d x %d (%dmm x %dmm)\n",
	 DisplayWidth( display, screen ),
	 DisplayHeight( display, screen ),
	 DisplayWidthMM( display, screen ),
	 DisplayHeightMM( display, screen ) );

  w1 = x_create_window( "w1", 0, 0, 200, 200 );
  w2 = x_create_window( "w2", 700, 0, 900, 1200 );
  x_map_window( w1 );
  x_map_window( w2 );

  width = x_window_width(w1);
  printf("%d\n", width);

  x_draw_line(w1, 0, 0, 50, 50, SET, 0);
  x_draw_line(w1, 0, 0, 25, 25, CLEAR, 0);
  x_draw_line(w1, 20, 20, 35, 35, XOR, 0);
  
  x_draw_text(w2, 20, 20, "Test", SET, 0);
  x_draw_text(w2, 20, 50, "Test", CLEAR, 0);
  x_draw_text(w2, 20, 80, "Test", XOR, 0);
  x_draw_text(w2, 20, 80, "Te", XOR, 0);

  printf( "Press RETURN to continue.\n" );
  getchar();
  printf( "Goodbye, Joe.\n" );

  x_kill_window(w1);
  x_kill_window(w2);
  x_kill_graphics();
}

/****************************************************************************/

x_init_graphics()

{
  XGCValues valuesset, valuesclr, valuesxor;

  printf( "Trying to open %s\n", XDisplayName( display_name ) );

  /* connect to X server. */
  if ( !( display = ( XOpenDisplay( display_name ) ) ) )  
    {
      fprintf( stderr, "GRAPHICS-X11: Cannot connect to X server %s\n",
	      XDisplayName( display_name ) );
      x_graphics_error( "Error while trying to open display." );
    }

  screen = DefaultScreen(display);

  if ( !( font_info = XLoadQueryFont( display, font_name ) ) )
    {
      fprintf( stderr, "Error while trying to open font %s\n", font_name );
      x_graphics_error( "Can't find font. Try xlsfonts to find a new one." );
    }

  /*CREATES GCs TO BE USED FOR DRAWABLE*/

  valuesset.function = MY_GX_FUNCTION;
  valuesset.foreground = BlackPixel(display, screen);
  valuesset.background = WhitePixel(display, screen);
  valuesset.plane_mask = AllPlanes;
  valuesset.font = font_info->fid;
  /* valuesset.line_width = 5; */
  setGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCBackground | GCPlaneMask
		    /* | GCLineWidth */,
		    &valuesset);
  setTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCBackground | GCFont,
		       &valuesset);
  XSetGraphicsExposures( display, setGC, 0 );
  XSetFunction( display, setGC, MY_GX_FUNCTION );

  valuesclr.background = BlackPixel(display, screen);
  valuesclr.foreground = WhitePixel(display, screen);
  valuesclr.plane_mask = AllPlanes;
  valuesclr.font = font_info->fid;
  /* valuesclr.line_width = 5; */
  clrGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCBackground | GCPlaneMask
		    /* | GCLineWidth */, 
		    &valuesclr);
  clrTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCBackground | GCFont,
		       &valuesclr);
  XSetGraphicsExposures( display, clrGC, 0 );
  
  valuesxor.function = GXinvert;
  valuesxor.foreground = BlackPixel(display, screen);
  valuesxor.plane_mask = AllPlanes;
  valuesxor.font = font_info->fid;
  /* valuesxor.line_width = 5; */
  xorGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCFunction | GCPlaneMask
		    /* | GCLineWidth */, 
		    &valuesxor);
  xorTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCFunction | GCFont,
		       &valuesxor);
  XSetGraphicsExposures( display, xorGC, 0 );

#ifdef COMMENT
  valuesset.function = MY_GX_FUNCTION;
  valuesset.foreground = BlackPixel(display, screen);
  valuesset.background = WhitePixel(display, screen);
  valuesset.plane_mask = AllPlanes;
  valuesset.font = font_info->fid;
  /* valuesset.line_width = 5; */
  setGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCBackground | GCPlaneMask
		    /* | GCLineWidth */,
		    &valuesset );
  setGC_black = XCreateGC(display, RootWindow(display, screen),
			  GCForeground | GCBackground | GCPlaneMask,
			  &valuesset );
  setTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCBackground | GCFont,
		       &valuesset );
  XSetGraphicsExposures( display, setGC_black, 0 );
  XSetFunction( display, setGC_black, MY_GX_FUNCTION );

  valuesclr.background = BlackPixel(display, screen);
  valuesclr.foreground = WhitePixel(display, screen);
  valuesclr.plane_mask = AllPlanes;
  valuesclr.font = font_info->fid;
  /* valuesclr.line_width = 5; */
  clrGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCBackground | GCPlaneMask
		    /* | GCLineWidth */, 
		    &valuesclr );
  clrGC_black = XCreateGC(display, RootWindow(display, screen),
			  GCForeground | GCBackground | GCPlaneMask,
			  &valuesclr );
  clrTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCBackground | GCFont,
		       &valuesclr);
  XSetGraphicsExposures( display, clrGC_black, 0 );
  
  valuesxor.function = GXinvert;
  valuesxor.foreground = BlackPixel(display, screen);
  valuesxor.plane_mask = AllPlanes;
  valuesxor.font = font_info->fid;
  /* valuesxor.line_width = 5; */
  xorGC = XCreateGC(display, RootWindow(display, screen),
		    GCForeground | GCFunction | GCPlaneMask
		    /* | GCLineWidth */, 
		    &valuesxor);
  xorGC_black = XCreateGC(display, RootWindow(display, screen),
			  GCForeground | GCFunction | GCPlaneMask,
			  &valuesxor );
  xorTxtGC = XCreateGC(display, RootWindow(display, screen),
		       GCForeground | GCFunction | GCFont,
		       &valuesxor );
  XSetGraphicsExposures( display, xorGC_black, 0 );

   /* create pixmaps for pattern */
 
   x_gray = XCreatePixmap(display,RootWindow(display, screen), 2, 2,
               DefaultDepthOfScreen(DefaultScreenOfDisplay(display)));
   XDrawPoint(display,x_gray,setGC_black,0,0);
   XDrawPoint(display,x_gray,setGC_black,1,1);
   XDrawPoint(display,x_gray,clrGC_black,0,1);
   XDrawPoint(display,x_gray,clrGC_black,1,0);
 
 
   x_ltGray = XCreatePixmap(display,RootWindow(display, screen), 2, 2,
               DefaultDepthOfScreen(DefaultScreenOfDisplay(display)));
   XDrawPoint(display,x_ltGray,setGC_black,0,0);
 
 
   x_dkGray = XCreatePixmap(display,RootWindow(display, screen), 2, 2,
               DefaultDepthOfScreen(DefaultScreenOfDisplay(display)));
   XDrawPoint(display,x_dkGray,setGC_black,0,0);
   XDrawPoint(display,x_dkGray,setGC_black,1,1);
   XDrawPoint(display,x_dkGray,setGC_black,1,0);
 
   x_white = XCreatePixmap(display,RootWindow(display, screen), 2, 2,
               DefaultDepthOfScreen(DefaultScreenOfDisplay(display)));
 
   /* create the GCs for the pattern */
   /* note: the values are used from above */
 
 
   setGC_gray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesset);
   XSetGraphicsExposures( display, setGC_gray, 0);
   XSetFunction( display, setGC_gray, MY_GX_FUNCTION);
   XSetFillStyle( display, setGC_gray, FillStippled);
   XSetStipple( display, setGC_gray, (Pixmap) x_gray);
 
   clrGC_gray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesclr);
   XSetGraphicsExposures( display, clrGC_gray, 0);
   XSetFillStyle( display, clrGC_gray, FillStippled);
   XSetStipple( display, clrGC_gray, (Pixmap) x_gray);
 
   xorGC_gray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCFunction | GCPlaneMask,
                   &valuesxor);
   XSetGraphicsExposures( display, xorGC_gray, 0);
   XSetFillStyle( display, xorGC_gray, FillStippled);
   XSetStipple( display, xorGC_gray, (Pixmap)x_gray);
 

   setGC_ltGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesset);
   XSetFunction( display, setGC_ltGray, MY_GX_FUNCTION);
   XSetGraphicsExposures( display, setGC_ltGray, 0);
   XSetFillStyle( display, setGC_ltGray, FillStippled);
   XSetStipple( display, setGC_ltGray, (Pixmap) x_ltGray);
 
   clrGC_ltGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesclr);
   XSetGraphicsExposures( display, clrGC_ltGray, 0);
   XSetFillStyle( display, clrGC_ltGray, FillStippled);
   XSetStipple( display, clrGC_ltGray, (Pixmap) x_ltGray);
 
   xorGC_ltGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCFunction | GCPlaneMask,
                   &valuesxor);
   XSetGraphicsExposures( display, xorGC_ltGray, 0);
   XSetFillStyle( display, xorGC_ltGray, FillStippled);
   XSetStipple( display, xorGC_ltGray, (Pixmap) x_ltGray);
 
 
 
 
   setGC_dkGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesset);
   XSetFunction( display, setGC_dkGray, MY_GX_FUNCTION);
   XSetGraphicsExposures( display, setGC_dkGray, 0);
   XSetFillStyle( display, setGC_dkGray, FillStippled);
   XSetStipple( display, setGC_dkGray, (Pixmap) x_dkGray);
 
   clrGC_dkGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesclr);
   XSetGraphicsExposures( display, clrGC_dkGray, 0);
   XSetFillStyle( display, clrGC_dkGray, FillStippled);
   XSetStipple( display, clrGC_dkGray, (Pixmap) x_dkGray);
 
   xorGC_dkGray = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCFunction | GCPlaneMask,
                   &valuesxor);
   XSetGraphicsExposures( display, xorGC_dkGray, 0);
   XSetFillStyle( display, xorGC_dkGray, FillStippled);
   XSetStipple( display, xorGC_dkGray, (Pixmap) x_dkGray);
 
 
   setGC_white = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesset);
   XSetFunction( display, setGC_white, MY_GX_FUNCTION);
   XSetGraphicsExposures( display, setGC_white, 0);
   XSetFillStyle( display, setGC_white, FillStippled);
   XSetStipple( display, setGC_white, (Pixmap) x_white);
 
   clrGC_white = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCBackground | GCPlaneMask,
                   &valuesclr);
   XSetGraphicsExposures( display, clrGC_white, 0);
   XSetFillStyle( display, clrGC_white, FillStippled);
   XSetStipple( display, clrGC_white, (Pixmap) x_white);
 
   xorGC_white = XCreateGC(display, RootWindow(display, screen),
                   GCForeground | GCFunction | GCPlaneMask,
                   &valuesxor);
   XSetGraphicsExposures( display, xorGC_white, 0);
   XSetFillStyle( display, xorGC_white, FillStippled);
   XSetStipple( display, xorGC_white, (Pixmap) x_white);
 
   /* set the current pixmap to black */
#endif
}

/****************************************************************************/

/*
 * Select a gc based on operation.
 */

GC
select_gc( int operation )
{

  switch (operation) 
    {

    case SET:
      return(setGC);
      break;

    case CLEAR:
      return(clrGC);
      break;

    case XOR:
      return(xorGC);
      break;

#ifdef COMMENT
  switch ( operation )
    {
    case SET:
      switch(current_fill_pattern)
	{
	case black:
	  return(setGC_black);
	  break;
	case white:
	  return(setGC_white);
	  break;
	case gray:
	  return(setGC_gray);
	  break;
	case ltGray:
	  return(setGC_ltGray);
	  break;
	case dkGray:
	  return(setGC_dkGray);
	  break;
	default:
	  return(setGC_black);
	  break;
	}
      break;

    case CLEAR:
      switch(current_fill_pattern)
	{
	case black:
	  return(clrGC_black);
	  break;
	case white:
	  return(clrGC_white);
	  break;
	case gray:
	  return(clrGC_gray);
	  break;
	case ltGray:
	  return(clrGC_ltGray);
	  break;
	case dkGray:
	  return(clrGC_dkGray);
	  break;
	default:
	  return(clrGC_black);
	  break;
	}
      break;

    case XOR:
      switch(current_fill_pattern)
	{
	case black:
	  return(xorGC_black);
	  break;
	case white:
	  return(xorGC_white);
	  break;
	case gray:
	  return(xorGC_gray);
	  break;
	case ltGray:
	  return(xorGC_ltGray);
	  break;
	case dkGray:
	  return(xorGC_dkGray);
	  break;
	default:
	  return(xorGC_black);
	  break;
	}
      break;
#endif

    default:
      fprintf( stderr, "X11-GRAPHICS: Can't handle operation %d\n", 
	       operation );
      return(NULL);
      break;
    }
}

/****************************************************************************/

Window 
x_create_window( name, left, top, width, height ) 
     char *name;
     int left, top, width, height;
{
  Window w;
  XSetWindowAttributes attr;
  unsigned long set_mask;

  /* override redirect allows the window to be mapped under
     program control rather than user or window manager control.
     See attr stucture below (True in override_redirect position)
     and set_mask below.
     This is also why XCreateWindow() is used rather than XCreateSimpleWindow()
     */

  if ( OVERRIDE_WINDOW_MANAGER )
    set_mask = CWOverrideRedirect | CWBackPixel | CWBorderPixel;
  else
    set_mask = CWBackPixel | CWBorderPixel;

  attr.override_redirect = True;
  attr.background_pixel = WhitePixel(display, screen);
  attr.border_pixel = BlackPixel(display, screen);
  attr.save_under         = True;
  attr.backing_store      = Always;
  
  if ( !( w = XCreateWindow( display,  RootWindow(display,screen),
			    left, top, width, height, BORDER_WIDTH,
			    CopyFromParent, CopyFromParent, CopyFromParent,
			    set_mask, &attr)))
    x_graphics_error( "Error while creating window.\n" );

  XStoreName( display, w, name );

  x_flush();

  return(w);
}

/****************************************************************************/

x_map_window (window)
     Window window;
{
  XEvent report;
  unsigned long mask;

  mask = ExposureMask | VisibilityChangeMask | StructureNotifyMask |
    ButtonPressMask | ButtonReleaseMask;

  /* Make sure window gets exposed. */
  /* Select event types wanted. */
  XSelectInput( display, window, mask );
  XMapRaised( display, window ); /* Put window up on screen. */
  x_flush(); /* And make server see it. */

  XWindowEvent( display, window, ExposureMask, &report );
  /*
  XNextEvent( display, &report );
  */
  if ( report.type != Expose )
    {
      fprintf( stderr,
	      "GRAPHICS-X11: Expose not first event from window. %d\n",
	      report.type );
      x_graphics_error( "Error while mapping window.\n" );
    }
  /* ??????
  XSelectInput( display, window, 0 );
  */
}

/****************************************************************************/

x_unmap_window (window)
     Window window;
{
  XUnmapWindow( display, window ); /* Take window off screen. */
  x_flush(); /* And make server see it. */
}

/****************************************************************************/

x_flush()
{
  XFlush(display);
}

/****************************************************************************/

x_kill_window (window)
     Window window;
{
  XDestroyWindow( display,window ); /* Throw window away. */
  XFlush(display); /* And make server see it. */
}

/****************************************************************************/

x_kill_graphics()
{
  XFreeFont( display, font_info );
  XFreeGC( display, setGC );
  XFreeGC( display, clrGC );
  XFreeGC( display, xorGC );
  XFreeGC( display, setGC_black );
  XFreeGC( display, clrGC_black );
  XFreeGC( display, xorGC_black );
  XFreeGC( display, setGC_white );
  XFreeGC( display, clrGC_white );
  XFreeGC( display, xorGC_white );
  XFreeGC( display, setGC_gray );
  XFreeGC( display, clrGC_gray );
  XFreeGC( display, xorGC_gray );
  XFreeGC( display, setGC_ltGray );
  XFreeGC( display, clrGC_ltGray );
  XFreeGC( display, xorGC_ltGray );
  XFreeGC( display, setGC_dkGray );
  XFreeGC( display, clrGC_dkGray );
  XFreeGC( display, xorGC_dkGray );
  XFreeGC( display, setTxtGC );
  XFreeGC( display, clrTxtGC );
  XFreeGC( display, xorTxtGC );
  x_flush();
  XCloseDisplay( display );
}

/****************************************************************************/

x_clear_window(window)
     Window window;
{
  XClearWindow( display,window );
  x_flush();
}

/****************************************************************************/

x_clear_window_no_flush(window)
     Window window;
{
  XClearWindow( display,window );
}

/****************************************************************************/

x_draw_point( window, x, y, operation, flush )
     Window window;
     int x, y, operation, flush;
{
  GC gc;

  if ((gc = select_gc(operation)))
    {
      XDrawPoint( display, window, gc, x, y );
      if (flush)
	x_flush(); /* And make server see it. */
    }
}

/****************************************************************************/

x_draw_line( window, x1, y1, x2, y2, operation, flush )
     Window window;
     int x1, y1, x2, y2, operation, flush;
{
  GC gc;

  if ((gc = select_gc(operation)))
    {
      XDrawLine( display, window, gc, x1, y1, x2, y2);
      if (flush)
	x_flush(); /* And make server see it. */
    }
}

/****************************************************************************/

x_draw_box( window, x, y, width, height, operation, flush )
     Window window;
     int width, height, x, y, operation, flush;

{
  GC gc;

  if ((gc = select_gc(operation)))
    {
      XDrawRectangle( display, window, gc, x, y, width, height);
      if (flush)
	x_flush();
    }
}

/****************************************************************************/

x_draw_filled_rectangle( window, x, y, width, height, operation, flush )
     Window window;
     int width, height, x, y, operation, flush;
{

  GC gc;

  if ((gc = select_gc(operation)))
    {
      XFillRectangle( display, window, gc, x, y, width, height);
      if (flush)
	x_flush();
    }
}
	
/****************************************************************************/

x_draw_circle( window, x, y, width, height, angle1, angle2, operation, flush )
     Window window;
     int x, y, width, height, angle1, angle2, operation, flush;
{

  GC gc;

  if ((gc = select_gc(operation)))
    {
      XDrawArc( display, window, gc, x, y, width, height, angle1, angle2 );
      if (flush)
	x_flush();
    }
}
	
/****************************************************************************/

x_draw_filled_circle( window, x, y, width, height,
		     angle1, angle2, operation, flush )
     Window window;
     int x, y, width, height, angle1, angle2, operation, flush;
{
  GC gc;

  if ((gc = select_gc(operation)))
    {
      XFillArc( display, window, gc, x, y, width, height, angle1, angle2 );
      if (flush)
	x_flush();
    }
}

/****************************************************************************/

x_draw_text( window, x, y, text, operation, flush )
     Window window;
     int x, y, operation, flush;
     char *text;
{

  GC gc;

  switch( operation )
    {
    case SET:
      gc = setTxtGC;
      break;

    case CLEAR:
      gc = clrTxtGC;
      break;

    case XOR:
      gc = xorTxtGC;
      break;

    default:
      fprintf( stderr, "X11-GRAPHICS: Can't handle text operation %d\n",
	      operation );
      break;
    }
  XDrawImageString( display, window, gc, x, y, text, strlen( text ));
  x_flush(); /* And make server see it. */
}

/****************************************************************************/

x_window_width(window)

     Window window;

{
  if ( !XGetWindowAttributes(display, window, &window_info ) )
    x_graphics_error( "Error while trying to query window." );
  
  return( (int) window_info.width );
}

/****************************************************************************/

x_window_height(window)

     Window window;

{
  if ( !XGetWindowAttributes(display, window, &window_info ) )
    x_graphics_error( "Error while trying to query window." );

  return( (int) window_info.height );
}
/****************************************************************************/

x_window_x(window)

     Window window;

{
  if ( !XGetWindowAttributes(display, window, &window_info ) )
    x_graphics_error( "Error while trying to query window." );

  return( (int) window_info.x );
}

/****************************************************************************/

x_window_y(window)

     Window window;

{
  if ( !XGetWindowAttributes(display, window, &window_info ) )
    x_graphics_error( "Error while trying to query window." );

  return( (int) window_info.y );
}

/****************************************************************************/

x_warp_mouse( window, x, y )

     Window window;
     int x, y;

{

  int mouse_x, mouse_y;

  XWarpPointer( display, None, window, 0, 0, 0, 0, 
                mouse_x = x, mouse_y = y );
  x_flush(); /* And make server see it. */
}

/****************************************************************************/

static int mouse_x, mouse_y, mouse_buttons;
static Window trash1, trash2;
int trash3, trash4;

/* In order to return two variables I need to be given an array to fill. */
/* Returns the mouse buttons. */

x_read_mouse( window, position )
     Window window;
     int position[]; 
{
  
  XQueryPointer( display, window, &trash1, &trash2, &trash3, &trash4, 
                 &mouse_x, &mouse_y, &mouse_buttons );
  position[0] = mouse_x;
  position[1] = mouse_y;
  return( mouse_buttons );
}

/****************************************************************************/

x_read_mouse_buttons( window )
     Window window;

{

  XQueryPointer( display, window, &trash1, &trash2, &trash3, &trash4, 
                 &mouse_x, &mouse_y, &mouse_buttons );
  return( mouse_buttons );
}

/****************************************************************************/

XEvent the_event;

x_wait_button_click(window)
     Window window;
{

  XSelectInput(display, window, ButtonPressMask);

  while (!XCheckTypedWindowEvent( display, window, ButtonPress, &the_event ))
    {}
}

/****************************************************************************/

/*
 * x_graphics_error - Fatal error.
 */
x_graphics_error( identifier )
     char *identifier;
{
  
  fprintf( stderr, "GRAPHICS-X11: %s\n", identifier );
  exit(-1);
}

/****************************************************************************/

void x_plot_float_array (window, array, length,
			 ring_start, time_step, time_offset, operation,
			 display_left, display_bottom,
			 display_right, display_top,
			 user_left, user_bottom,
			 user_right, user_top)

     float  *array, time_step, time_offset;
     int    length, ring_start, operation;
     int    display_left, display_top, display_right, display_bottom;
     double user_left, user_top, user_right, user_bottom;

{

  float x_conversion, y_conversion;
  register i, index;

  register int x, y;
  register int last_x, last_y;

  GC gc;

  x_conversion = (user_right - user_left) == 0 ? 
    0.0 : (display_right - display_left) / ( user_right - user_left);

  y_conversion = (user_bottom - user_top) == 0 ?
    0.0 : (display_top - display_bottom) / (user_top - user_bottom);

  gc = select_gc(operation);
  
  index = (0 + ring_start) % length;
  last_x = display_left + (time_offset - user_left) * x_conversion;
  last_y = display_bottom + (array[index] - user_bottom) * y_conversion;

  XDrawPoint( display, window, gc, last_x, last_y );

  for (i = 0; i < length; i++)
    {
      index = (i + ring_start) % length;
      x = display_left + (time_offset + i*time_step - user_left)*x_conversion;
      y = display_bottom + (array[index] - user_bottom)*y_conversion;
      XDrawLine( display, window, gc, last_x, last_y, x, y);
      last_x = x;
      last_y = y;
    }

  x_flush(); /* And make server see it. */
}
    

/****************************************************************************/
/**************************************************************************/
/*  hardcopy a window or the entire screen and send it to the printer     */
/**************************************************************************/

/* parse your current print command for a file in print_command  */

hardcopy(Window my_window, char *print_command)
{
if (my_window == 0) my_window = RootWindow(display,screen);
xdump(my_window);
system (print_command);
}

/**************************************************************************
  set a current fill pattern   
**************************************************************************/
void
SetFillPattern(int pat)
{

  current_fill_pattern = pat;


}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/* This is the really simple interface with just one window. */

test_graphics_simple()
{
  int i;
  int mouse[2];

  init_window( 0.5 );

  printf( "Window width and height: %d %d\n",
	 width_of_window(), height_of_window() );

  /* Clear screen. */
  clear_window();

  draw_line( 0, 0, width_of_window(), height_of_window(), SET );
  draw_line( 0, height_of_window(), width_of_window(), 0, SET );

  /* draw top, bottom, left, right borders on box */
  draw_line( 200, 200, 350, 200, SET );
  draw_line( 350, 200, 350, 350, SET );
  draw_line( 350, 350, 200, 350, SET );
  draw_line( 200, 350, 200, 200, SET );

  /* write text on canvas */
  draw_text( 225, 250, "Hello World!", SET );
  draw_text( 225, 275, "Hi Mom!", CLEAR );

  /*
  for(;;)
    {
      i = read_mouse( mouse );
      if ( i )
	printf( "%d %d %d\n", i, mouse[0], mouse[1] );
    }
    */

  printf( "Press RETURN to continue.\n" );
  getchar();

  done_with_window();
}

/****************************************************************************/

static Window simple_w; /* window id of window to be used. */
static int simple_width;
static int simple_height;
static Pixmap simple_backbuffer;        /* backbuffer for the window */
static Window send_pixels_to;

/****************************************************************************/

/* Create a window in the top right corner of the screen with the given
   aspect-ratio (width/height) in pixels. */
init_window( aspect_ratio )
     float aspect_ratio;
{
  int left, top;		/* window position. */
  float screen_aspect_ratio;
  char *window_name = "Simple Graphics Window";

  x_init_graphics();
  screen_aspect_ratio =
    ((float) DisplayWidth( display, screen ))/
      DisplayHeight( display, screen );
  if ( aspect_ratio >= screen_aspect_ratio )
    {
      /* width limited. */
      simple_width = DisplayWidth( display, screen ) - 2*BORDER_WIDTH;
      simple_height = (int) (simple_width/aspect_ratio);
    }
  else
    {
      /* height limited. */
      simple_height = DisplayHeight( display, screen ) - 2*BORDER_WIDTH;
      simple_width = (int) (simple_height*aspect_ratio);
    }
  simple_w = x_create_window( "Graphics Window",
		      DisplayWidth( display, screen ) - simple_width
		      - 2*BORDER_WIDTH, 0, simple_width, simple_height );
  x_map_window( simple_w );

  simple_backbuffer 
    = XCreatePixmap( display, simple_w, simple_width, simple_height,
		     DefaultDepthOfScreen(DefaultScreenOfDisplay(display)) );
  XFillRectangle( display, simple_backbuffer, select_gc(CLEAR), 0, 0,
		  simple_width, simple_height);

  send_pixels_to = simple_w;
}

/****************************************************************************/

#ifdef COMMENT
/* Create a window which can be printed in landscape mode.
 aspect_ratio is ignored. */
init_window_landscape( aspect_ratio )
     float aspect_ratio;
{
  unsigned int width, height;	/* window size. */
  int left, top;		/* window position. */
  float screen_aspect_ratio;
  char *window_name = "Simple Graphics Window";

  x_init_graphics();
  screen_aspect_ratio =
    ((float) DisplayWidth( display, screen ))/
      DisplayHeight( display, screen );
  /* SUN hi res display */
  /*
  width = 1569;
  height = 1194;
  */
  /* SUN low res display */
  width = 1152-31;
  height = 900-6;
  w = x_create_window( "Graphics Window",
		      DisplayWidth( display, screen ) - width
		      - 2*BORDER_WIDTH, 0, width, height );
  x_map_window( w );
}
#endif

/****************************************************************************/

#ifdef COMMENT
/* Create a window in the top right corner of the screen with the given
   size in pixels */
init_window_pixels( width, height )
  unsigned int width, height;	/* window size. */
{
  int left, top;		/* window position. */
  char *window_name = "Simple Graphics Window";

  x_init_graphics();
  w = x_create_window( "Graphics Window",
		      DisplayWidth( display, screen ) - width
		      - 2*BORDER_WIDTH, 0, width, height );
  x_map_window( w );
}
#endif

/****************************************************************************/

Window
get_simple_window()
{
  return simple_w;
}

/****************************************************************************/

draw_line( x1, y1, x2, y2, operation )
     int x1, y1, x2, y2, operation;
{
  x_draw_line( send_pixels_to, x1, y1, x2, y2, operation, 0 );
}

/****************************************************************************/

draw_text( x, y, text, operation )
     int x, y, operation;
     char *text;
{
  x_draw_text( send_pixels_to, x, y, text, operation, 0 );
}

/****************************************************************************/

flush_graphics()
{
  if ( send_pixels_to == simple_backbuffer )
    XCopyArea( display, simple_backbuffer, simple_w,
	       select_gc(SET),  0, 0, simple_width, simple_height, 0, 0);
  x_flush();
}

/****************************************************************************/

done_with_window()
{
  x_kill_window ( simple_w );
  x_kill_graphics( simple_w );
}

/****************************************************************************/

clear_window()
{
  x_clear_window_no_flush( send_pixels_to );
}

/****************************************************************************/

width_of_window()
{
  return( simple_width );
}

/****************************************************************************/

height_of_window()
{
  return( simple_height );
}

/****************************************************************************/

warp_mouse( x, y )
     int x, y;
{
  return x_warp_mouse( simple_w, x, y );
}

/****************************************************************************/

read_mouse( position )
     int position[]; 
{
  return x_read_mouse( simple_w, position );
}

/****************************************************************************/

