/*****************************************************************************/

#include <stdio.h>
#include <math.h>

#include "main.h"
#include "opt-parameters.h"

/*****************************************************************************/
/*****************************************************************************/

extern SIM sim;

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

main( int argc, char **argv )
{
  OPT_PARAM *read_opt_param_file();
  OPT_PARAM *params;
  float v[MAX_N_PARAMETERS];
  int n_parameters;
  extern float get_score( SIM *s );
  float cost;

  init_default_parameters( &sim );

  if ( argc < 2 )
    {
      fprintf( stderr, "Optimize using which parameter file?\n" );
      fprintf( stderr, "%s parameter-file\n", argv[0] );
      exit( -1 );
    }
  params = read_opt_param_file( argv[1] );
  n_parameters = process_parameters( params, &sim, 1 );
  if ( n_parameters > MAX_N_PARAMETERS )
    {
      fprintf( stderr, "Too many parameters %d > %d\n",
	       n_parameters, MAX_N_PARAMETERS );
      exit( -1 );
    }

  sim.rand_scale = 0;

  init_sim( &sim );
  init_my_graphics();

  reinit_sim( &sim );
  reinit_display();
  redisplay_stuff();

  /*
  printf( "Press return to continue.\n" );
  getchar();
  */

  for( ; sim.time < sim.trial_duration; )
    {
      controller( &sim );
      save_data( &sim );
      integrate_one_time_step( &sim );
      redisplay_stuff();
    }

  write_the_mrdplot_file( &sim );

  cost = get_score( &sim );

  printf( "Cost: %g\n", cost );
}

/*****************************************************************************/
