/************************************************************************/
/*
opt-policy1: optimize a policy
*/
/************************************************************************/

#include <stdio.h>
#include <math.h>

#include "opt-parameters.h"
#include "main.h"

/*
#define GRAPHICS
*/

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

static OPT_PARAM *params;
extern SIM sim;
static float all_time_low_cost = 1e20;
static int debug_powell = 0;
static int func_calls = 0;
static int n_parameters = 0;
static char output_file[10000];

/*****************************************************************************/
/* Powell stuff */

#define FTOL 1.0e-7
static float p[MAX_N_PARAMETERS+1];
static float p_min[MAX_N_PARAMETERS+1];
static float p_max[MAX_N_PARAMETERS+1];
static float **xi;
static int iter;

/*****************************************************************************/
/*****************************************************************************/

float func_core(x)
float x[];
{
  float cost = 0;
  extern float get_score( SIM *s );

  func_calls++;

  vector_to_sim( &(x[1]), n_parameters, params );
  reinit_sim( &sim );
#ifdef GRAPHICS
  reinit_display();
#endif

  for( ; sim.time < sim.trial_duration; )
    {
      controller( &sim );
      integrate_one_time_step( &sim );
#ifdef GRAPHICS
      redisplay_stuff();
#endif
    }

  cost = get_score( &sim );

  return cost;
}

/***************************************************************************/

float call_one_func(x)
float x[];
{
  float cost = 0;
  int i;

  sim.rand_seed = 1;
  cost += func_core( x );

  if ( cost < all_time_low_cost )
    {
      printf( "ALL TIME LOW COST: %g\n", cost );
      for ( i = 1; i <= n_parameters; i++ )
	printf( "init_parameters[%d] = %18.12f;\n", i-1, p[i] );
      if( cost < all_time_low_cost )
	all_time_low_cost = cost;
      write_param_file( output_file, params );
    }

  if ( debug_powell )
    {
      printf( "%d %d: cost %g\n", iter, func_calls, cost );
      for( i = 1; i <= n_parameters; i++ )
	printf( "%g ", x[i] );
      printf( "\n\n" );
    }

  return cost;
}

/***************************************************************************/

float call_many_func(x)
float x[];
{
  float cost = 0;
  float c;
  int i;

  printf( "call_many_func\n" );

  for( i = 0; i < sim.how_many_trials; i++ )
    {
      sim.rand_seed = i + 1;
      c = func_core( x );
      cost += c;
      /* printf( "%d: %g\n", i, c ); */
    }

  if ( cost < all_time_low_cost )
    {
      printf( "ALL TIME LOW COST: %g\n", cost );
      for ( i = 1; i <= n_parameters; i++ )
	printf( "init_parameters[%d] = %18.12f;\n", i-1, p[i] );
      if( cost < all_time_low_cost )
	all_time_low_cost = cost;
      write_param_file( output_file, params );
    }

  if ( debug_powell )
    {
      printf( "%d %d: cost %g\n", iter, func_calls, cost );
      for( i = 1; i <= n_parameters; i++ )
	printf( "%g ", x[i] );
      printf( "\n\n" );
    }

  return cost;
}

/************************************************************************/
/************************************************************************/
/* Main: initialize and then call powell optimizer */

int main( int argc, char **argv )
{
  int i, j, k;
  float **matrix();
  float fret;
  double step = 0.01;
  float cost2;
  OPT_PARAM *read_opt_param_file();
  
  init_default_parameters( &sim );

  if ( argc < 2 )
    {
      fprintf( stderr, "Optimize using which parameter file?\n" );
      fprintf( stderr, "%s parameter-file\n", argv[0] );
      exit( -1 );
    }
  params = read_opt_param_file( argv[1] );
  n_parameters = process_parameters( params, &sim, 1 );
  if ( n_parameters > MAX_N_PARAMETERS )
    {
      fprintf( stderr, "Too many parameters %d > %d\n",
	       n_parameters, MAX_N_PARAMETERS );
      exit( -1 );
    }
  sprintf( output_file, "%s.new", argv[1] );

  init_sim( &sim );
#ifdef GRAPHICS
  init_my_graphics();
#endif

  debug_powell = 1;
  for( i = 1; i <= n_parameters; i++ )
    {
      p_min[i] = -1e10;
      p_max[i] = 1e10;
    }
  xi = matrix( 1, n_parameters, 1, n_parameters );

  for ( i = 1; i <= n_parameters; i++ )
    for ( j = 1; j <= n_parameters; j++ )
      xi[i][j] = (i == j ? step : 0.0 );
  parameters_to_vector( params, &p[1] );
  call_many_func( p );
  /*
  printf( "Press return to continue.\n" );
  getchar();
  */

  /* return() here if all you want to see is one policy run. */
  powell( p, p_min, p_max, xi, n_parameters, FTOL, &iter, &fret, call_many_func, debug_powell );

  cost2 = call_many_func( p );

  printf( "Iterations: %d (%d)\n\n", iter, func_calls );
  printf( "Minimum found at: \n" );
  for ( i = 1; i <= n_parameters; i++ )
    printf( "init_parameters[%d] = %18.12f;\n", i-1, p[i] );
  printf( "\n\nMinimum function value = %12.6f, should equal %12.6f \n\n",
	  fret, cost2 );
  printf( "All time low cost: %g\n", all_time_low_cost );
}

/************************************************************************/
