/******************************************************************/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>

#include "opt-parameters.h"

/******************************************************************/

OPT_PARAM *malloc_opt_param()
{
  OPT_PARAM *result;

  result = malloc( sizeof( OPT_PARAM ) );
  if ( result == NULL )
    {
      fprintf( stderr, "No memory to allocate OPT_PARAM.\n" );
      exit( -1 );
    }
  result->name = NULL;
  result->value = 0;
  result->optimize = 0;
  result->regularize = 0;
  result->nominal_value = 0;
  result->regularize_weight = 0;
  result->next = NULL;
  return result;
}

/******************************************************************/

OPT_PARAM *read_opt_param_file( char *filename )
{
  FILE *stream;
  char buffer[10000];
  OPT_PARAM *p, *top, *bottom;

  top = NULL;
  bottom = NULL;
  p = NULL;
  stream = fopen( filename, "r" );
  if ( stream == NULL )
    {
      fprintf( stderr, "Can't open %s\n", filename );
      exit( -1 );
    }
  for(;;)
    {
      /* get name of variable */
      if ( fscanf( stream, "%s", buffer ) < 1 )
	break;
      p = malloc_opt_param();
      p->name = strdup( buffer );
      if ( fscanf( stream, "%lf", &(p->value) ) < 1 )
	{
	  fprintf( stderr, "Missing value for %s in %s\n",
		   p->name, filename );
	  exit( -1 );
	}

      /* read various commands */
      for( ; ; )
	{
	  if ( fscanf( stream, "%s", buffer ) < 1 )
	    {
	      fprintf( stderr, "Missing end for %s in %s\n",
		       p->name, filename );
	      exit( -1 );
	    }
	  if ( strcmp( buffer, "end" ) == 0 )
	    break;
	  if ( strcmp( buffer, "opt" ) == 0 )
	    p->optimize = 1;
	}

      if ( top == NULL )
	top = p;
      if ( bottom != NULL )
	bottom->next = p;
      bottom = p;
    }
  fclose( stream );
  return top;
}

/******************************************************************/

write_opt_param_file( FILE *stream, OPT_PARAM *p )
{
  for( ; ; )
    {
      if ( p == NULL )
	break;
      fprintf( stream, "%s %lg", p->name, p->value );
      if ( p->optimize )
	fprintf( stream, " opt" );
      fprintf( stream, " end\n" );
      p = p->next;
    }
}

/******************************************************************/

/*
main()
{
  OPT_PARAM *p;

  p = read_opt_param_file( "test" );
  write_opt_param_file( stdout, p ); 
}
*/

/******************************************************************/
