/* 
Fix all left and right things to be [2] instead of l_ and r_
*/

#define LEFT 0
#define RIGHT 1

/* These are handy constants. XX rather than X to avoid math.h conflicts */
#define XX 0
#define YY 1
#define ZZ 2

#define OK 1
#define CRASHED 2

// parameters for simulation
typedef struct {
  double time_step;          // simulation physics time step    
  double time;               // current time in simulation
  double desireds_index;      // time index into desireds(t)
  double last_time;          // a variable used by controller.

  // Angles
  double pitch;
  double hip_angle[2];
  double knee_angle[2];

  // Location of various body parts. */
  double head[3];
  double hip[3];
  double knee[2][3];
  double foot[2][3];
  
  // Angular velocities
  double pitchd;
  double hip_angled[2];
  double knee_angled[2];

  // Linear velocities
  double headd[3];
  double hipd[3];
  double kneed[2][3];
  double footd[2][3];

  // Accelerations
  double hipdd[3];
  double pitchdd;
  double hip_angledd[2];
  double knee_angledd[2];

  // ground model
  double gnd_k; /* DELETE */
  double gnd_k_x; /* DELETE */
  double gnd_b; /* DELETE */

  // original ground contact point.
  double foot_zero[2][3]; /* DELETE */

  // foot positions and forces
  double footpos[2][3];  /* DELETE */
  double footvel[2][3];  /* DELETE */
  double gndforce[2][3];

  // gains
  double k_hip;
  double b_hip;
  double k_knee;
  double b_knee;
  double k_pitch;
  double b_pitch;

  // desired positions
  double head_d[3];
  double hip_d[3];
  double knee_d[2][3];
  double foot_d[2][3];
  double pitch_d;
  double hip_angle_d[2];
  double knee_angle_d[2];

  // desired velocities
  double headd_d[3];
  double hipd_d[3];
  double kneed_d[2][3];
  double footd_d[2][3];
  double pitchd_d;
  double hip_angled_d[2];
  double knee_angled_d[2];

  // desired accelerations
  double hipdd_d[3];
  double pitchdd_d;
  double hip_angledd_d[2];
  double knee_angledd_d[2];

  // absolute angles
  double body_abs_angle[2];
  double thigh_abs_angle[2];
  double calf_abs_angle[2];

  // commanded torques
  double hip_command[2];
  double knee_command[2];
  double hip_feedforward[2];
  double knee_feedforward[2];

  // torques (actually applied)
  double hip_torque[2];
  double knee_torque[2];

  // controller variables
  int controller_state;
  double state_start_time;
  double state_elapsed_time;

  // debugging variables
  double step_length;

  // Are we CRASHED? 
  int status;
  double crashed_penalty_increment;

  // dynamics stuff
  int sdfast_flag;
  int sdfast_mode;
  int sdfast_last_mode; /* DELETE? */
  double state_sdfast[100];
  double state_sdfast2[100];
  double ds_state[100];
  double ss_state[100];
  double x_offset;
  int ss_foot_down;

  // kinematics
  double torso_length;
  double pelvis_mass;
  double pelvis_I;
  double thigh_length;
  double thigh_cm;
  double thigh_mass;
  double thigh_I;
  double calf_length;
  double calf_cm;
  double calf_mass;
  double calf_I;

  double head_offset[3];
  double hip_offset[3];
  double knee_offset[3];
  double foot_offset[3];

  // estimated model
  double hip_I_model;

  // random stuff
  double how_many_trials;
  int rand_seed;
  double rand_scale;

  /* Overall parameters */
  double trial_duration;

  /* Objective function */
  double desired_speed;
  double speed_penalty_weight;
  double torque_penalty_weight;

  /* Measured quantities */
  double top_velocity;

  /* Initial posture */
  double wait_duration;
  double wait_l_hip;
  double wait_l_knee;
  double wait_r_hip;
  double wait_r_knee;

  /* Launch1 parameters: dip knees */
  double l1_knee_feedforward;
  double l1_duration;
  double l1_movement_duration;
  double l1_lhip;
  double l1_lknee;
  double l1_rhip;
  double l1_rknee;

  /* Launch2 parameters: right leg pushoff */
  double l2_movement_duration;
  double l2_rhip;
  double l2_rknee;
  double l2_z_force_threshold;

  /* Launch3 parameters: right swing */
  double l3_duration;
  double l3_rhip1_time;
  double l3_rhip1;
  double l3_rhip2_time;
  double l3_rhip2;
  double l3_rknee1_time;
  double l3_rknee1;
  double l3_rknee2_time;
  double l3_rknee2;
  double l3_rknee3_time;
  double l3_rknee3;
  double l3_lhip_time;
  double l3_lhip;
  double l3_lknee1_time;
  double l3_lknee1;
  double l3_lknee2_time;
  double l3_lknee2;

  /* Steady state gait parameters */
  double swing_time;
  double swing_hip1;
  double swing_hip1_time;
  double swing_hip2;
  double swing_knee1;
  double swing_knee1_time;
  double swing_knee2;
  double swing_knee2_time;
  double swing_knee3;
  double swing_knee3_time;
  double pushoff_duration;
  double stance_knee_top;
  double stance_knee_top_time;
  double knee_extension_duration;

  double knee_ff_peak_time;
  double knee_ff_peak;
  double knee_ff_time;
  double knee_ff;

  /* Gains */
  double hip_gain;
  double hip_target_max;
  double knee_gain;
  double knee_target_min;
  double knee_target_max;

} SIM;

