/*************************************************************************/

#include <stdio.h>
#include <math.h>
#include "../mrdplot/mrdplot.h"

#include "main.h"

/*************************************************************************/

#define N_CHANNELS 59

#define MRDPLOT_L_HIP 0
#define MRDPLOT_L_KNEE 1
#define MRDPLOT_R_HIP 2
#define MRDPLOT_R_KNEE 3
#define MRDPLOT_L_HIP_D 4
#define MRDPLOT_L_KNEE_D 5
#define MRDPLOT_R_HIP_D 6
#define MRDPLOT_R_KNEE_D 7
#define MRDPLOT_L_HIPD 8
#define MRDPLOT_L_KNEED 9
#define MRDPLOT_R_HIPD 10
#define MRDPLOT_R_KNEED 11
#define MRDPLOT_L_HIPD_D 12
#define MRDPLOT_L_KNEED_D 13
#define MRDPLOT_R_HIPD_D 14
#define MRDPLOT_R_KNEED_D 15
#define MRDPLOT_X 16
#define MRDPLOT_Z 17
#define MRDPLOT_PITCH 18
#define MRDPLOT_XD 19
#define MRDPLOT_ZD 20
#define MRDPLOT_PITCHD 21
#define MRDPLOT_L_HIP_TORQUE 22
#define MRDPLOT_L_KNEE_TORQUE 23
#define MRDPLOT_R_HIP_TORQUE 24
#define MRDPLOT_R_KNEE_TORQUE 25
#define MRDPLOT_L_FOOT_X 26
#define MRDPLOT_L_FOOT_Z 27
#define MRDPLOT_R_FOOT_X 28
#define MRDPLOT_R_FOOT_Z 29
#define MRDPLOT_L_FOOT_FX 30
#define MRDPLOT_L_FOOT_FZ 31
#define MRDPLOT_R_FOOT_FX 32
#define MRDPLOT_R_FOOT_FZ 33
#define MRDPLOT_STATE 34
#define MRDPLOT_STATE_TIME 35
#define MRDPLOT_TIME 36
#define MRDPLOT_STEP_LENGTH 37
#define MRDPLOT_L_BODY_ABS_ANGLE 38
#define MRDPLOT_L_THIGH_ABS_ANGLE 39
#define MRDPLOT_L_CALF_ABS_ANGLE 40
#define MRDPLOT_R_BODY_ABS_ANGLE 41
#define MRDPLOT_R_THIGH_ABS_ANGLE 42
#define MRDPLOT_R_CALF_ABS_ANGLE 43
#define MRDPLOT_L_HIP_COMMAND 44
#define MRDPLOT_L_KNEE_COMMAND 45
#define MRDPLOT_R_HIP_COMMAND 46
#define MRDPLOT_R_KNEE_COMMAND 47
#define MRDPLOT_L_HIP_FEEDFORWARD 48
#define MRDPLOT_L_KNEE_FEEDFORWARD 49
#define MRDPLOT_R_HIP_FEEDFORWARD 50
#define MRDPLOT_R_KNEE_FEEDFORWARD 51
#define MRDPLOT_XDD 52
#define MRDPLOT_ZDD 53
#define MRDPLOT_PITCHDD 54
#define MRDPLOT_L_HIPDD 55
#define MRDPLOT_L_KNEEDD 56
#define MRDPLOT_R_HIPDD 57
#define MRDPLOT_R_KNEEDD 58

/*************************************************************************/

extern SIM sim;

/*************************************************************************/

main()
{
  MRDPLOT_DATA *d; 
  int i, index;

  d = read_mrdplot( last_data() ); 
  if ( d->n_channels != N_CHANNELS )
    {
      fprintf( stderr, "Wrong number of channels: %d %d\n", 
	       d->n_channels, N_CHANNELS );
    }
  for( i = 0, index = 0; i < d->n_points; i++, index += d->n_channels )
    {
      unload_data( d->data, index, &sim );
      printf( "%g\n", sim.time );
    }
    
}

/*************************************************************************/
