/************************************************************************/
/*
  graphics.c: Draw the biped walking during a simulation
*/
/************************************************************************/

#include <stdio.h>
#include <math.h>
#include "../graphics-x11/pixels.h"
#include "../graphics-x11/views.h"

#include "main.h"

extern SIM sim;

extern float last_x1, last_y1, last_x2, last_y2;
float body_x1, body_y1, body_x2, body_y2;
float left_thigh_x1, left_thigh_y1, left_thigh_x2, left_thigh_y2;
float left_calf_x1, left_calf_y1, left_calf_x2, left_calf_y2;
float right_thigh_x1, right_thigh_y1, right_thigh_x2, right_thigh_y2;
float right_calf_x1, right_calf_y1, right_calf_x2, right_calf_y2;

static int first_time = 1;

View v, *pv;

/************************************************************************/
/************************************************************************/

void display_stuff()
{
  extern double xt[];
  double hip_x, hip_z;
  double body_x, body_z;
  double knee_x[2], knee_z[2];
  double foot_x[2], foot_z[2];

  vdraw_line( -0.5, 0.0, 5.5, 0.0, SET, pv );
  vdraw_line( 0.0, -0.05, 0.0, 0.55, SET, pv );
  vdraw_line( 5.0, -0.05, 5.0, 0.55, SET, pv );

  vdraw_line( sim.hip[XX], sim.hip[ZZ], sim.head[XX], sim.head[ZZ],
	      SET, pv );
  body_x1 = last_x1;
  body_y1 = last_y1;
  body_x2 = last_x2;
  body_y2 = last_y2;

  vdraw_line( sim.hip[XX], sim.hip[ZZ], sim.knee[LEFT][XX], sim.knee[LEFT][ZZ],
	      SET, pv );
  left_thigh_x1 = last_x1;
  left_thigh_y1 = last_y1;
  left_thigh_x2 = last_x2;
  left_thigh_y2 = last_y2;

  vdraw_line( sim.hip[XX], sim.hip[ZZ], sim.knee[RIGHT][XX], sim.knee[RIGHT][ZZ],
	      SET, pv );
  right_thigh_x1 = last_x1;
  right_thigh_y1 = last_y1;
  right_thigh_x2 = last_x2;
  right_thigh_y2 = last_y2;

  vdraw_line( sim.knee[LEFT][XX], sim.knee[LEFT][ZZ], sim.foot[LEFT][XX], sim.foot[LEFT][ZZ],
	      SET, pv );
  left_calf_x1 = last_x1;
  left_calf_y1 = last_y1;
  left_calf_x2 = last_x2;
  left_calf_y2 = last_y2;

  vdraw_line( sim.knee[RIGHT][XX], sim.knee[RIGHT][ZZ], sim.foot[RIGHT][XX],
	      sim.foot[RIGHT][ZZ],
	      SET, pv );
  right_calf_x1 = last_x1;
  right_calf_y1 = last_y1;
  right_calf_x2 = last_x2;
  right_calf_y2 = last_y2;

  flush_graphics();
}

/************************************************************************/

void erase_stuff()
{
  _vdraw_line( right_calf_x1, right_calf_y1, right_calf_x2, right_calf_y2,
	       CLEAR );
  _vdraw_line( left_calf_x1, left_calf_y1, left_calf_x2, left_calf_y2,
	       CLEAR );
  _vdraw_line( right_thigh_x1, right_thigh_y1, right_thigh_x2, right_thigh_y2,
	       CLEAR );
  _vdraw_line( left_thigh_x1, left_thigh_y1, left_thigh_x2, left_thigh_y2,
	       CLEAR );
  _vdraw_line( body_x1, body_y1, body_x2, body_y2, CLEAR );
}

/************************************************************************/

void redisplay_stuff()
{
  static int count = 0;

  /*
  count++;
  if ( count < 30 )
    return;
  count = 0;
  */

  erase_stuff();
  display_stuff();
}

/************************************************************************/

void reinit_display()
{
  clear_window();
  display_stuff();
  first_time = 1;
}

/************************************************************************/

void init_my_graphics()
{

  init_window( 10.0 );
  pv = &v;
  set_up_view( pv, -0.5, -0.05, 5.5, 0.55 );
  reinit_display();
}

/************************************************************************/
